/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminConsole;
import org.keycloak.services.resources.admin.AdminCorsPreflightService;
import org.keycloak.services.resources.admin.RealmsAdminResource;
import org.keycloak.services.resources.admin.info.ServerInfoAdminResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.theme.Theme;
import org.keycloak.urls.UrlType;

@Path(value="/admin")
public class AdminRoot {
    protected static final Logger logger = Logger.getLogger(AdminRoot.class);
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    protected AppAuthManager authManager;
    protected TokenManager tokenManager = new TokenManager();
    @Context
    protected KeycloakSession session;

    public AdminRoot() {
        this.authManager = new AppAuthManager();
    }

    public static UriBuilder adminBaseUrl(UriInfo uriInfo) {
        return AdminRoot.adminBaseUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder adminBaseUrl(UriBuilder base) {
        return base.path(AdminRoot.class);
    }

    @GET
    public Response masterRealmAdminConsoleRedirect() {
        RealmModel master = new RealmManager(this.session).getKeycloakAdminstrationRealm();
        return Response.status((int)302).location(this.session.getContext().getUri(UrlType.ADMIN).getBaseUriBuilder().path(AdminRoot.class).path(AdminRoot.class, "getAdminConsole").path("/").build(new Object[]{master.getName()})).build();
    }

    @Path(value="index.{html:html}")
    @GET
    public Response masterRealmAdminConsoleRedirectHtml() {
        return this.masterRealmAdminConsoleRedirect();
    }

    protected RealmModel locateRealm(String name, RealmManager realmManager) {
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm not found.  Did you type in a bad URL?");
        }
        this.session.getContext().setRealm(realm);
        return realm;
    }

    public static UriBuilder adminConsoleUrl(UriInfo uriInfo) {
        return AdminRoot.adminConsoleUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder adminConsoleUrl(UriBuilder base) {
        return AdminRoot.adminBaseUrl(base).path(AdminRoot.class, "getAdminConsole");
    }

    @Path(value="{realm}/console")
    public AdminConsole getAdminConsole(@PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.locateRealm(name, realmManager);
        AdminConsole service = new AdminConsole(realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    protected AdminAuth authenticateRealmAdminRequest(HttpHeaders headers) {
        AccessToken token;
        String tokenString = this.authManager.extractAuthorizationHeaderToken(headers);
        if (tokenString == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        try {
            JWSInput input = new JWSInput(tokenString);
            token = (AccessToken)input.readJsonContent(AccessToken.class);
        }
        catch (JWSInputException e) {
            throw new NotAuthorizedException((Object)"Bearer token format error", new Object[0]);
        }
        String realmName = token.getIssuer().substring(token.getIssuer().lastIndexOf(47) + 1);
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            throw new NotAuthorizedException((Object)"Unknown realm in token", new Object[0]);
        }
        this.session.getContext().setRealm(realm);
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateBearerToken(this.session, realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection, headers);
        if (authResult == null) {
            logger.debug((Object)"Token not valid");
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        ClientModel client = realm.getClientByClientId(token.getIssuedFor());
        if (client == null) {
            throw new NotFoundException("Could not find client for authorization");
        }
        return new AdminAuth(realm, authResult.getToken(), authResult.getUser(), client);
    }

    public static UriBuilder realmsUrl(UriInfo uriInfo) {
        return AdminRoot.realmsUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder realmsUrl(UriBuilder base) {
        return AdminRoot.adminBaseUrl(base).path(AdminRoot.class, "getRealmsAdmin");
    }

    @Path(value="realms")
    public Object getRealmsAdmin(@Context HttpHeaders headers) {
        if (this.request.getHttpMethod().equals("OPTIONS")) {
            return new AdminCorsPreflightService(this.request);
        }
        AdminAuth auth = this.authenticateRealmAdminRequest(headers);
        if (auth != null) {
            logger.debug((Object)("authenticated admin access for: " + auth.getUser().getUsername()));
        }
        Cors.add(this.request).allowedOrigins(auth.getToken()).allowedMethods("GET", "PUT", "POST", "DELETE").exposedHeaders("Location").auth().build(this.response);
        RealmsAdminResource adminResource = new RealmsAdminResource(auth, this.tokenManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)adminResource);
        return adminResource;
    }

    @Path(value="serverinfo")
    public Object getServerInfo(@Context HttpHeaders headers) {
        if (this.request.getHttpMethod().equals("OPTIONS")) {
            return new AdminCorsPreflightService(this.request);
        }
        AdminAuth auth = this.authenticateRealmAdminRequest(headers);
        if (!AdminPermissions.realms(this.session, auth).isAdmin()) {
            throw new ForbiddenException();
        }
        if (auth != null) {
            logger.debug((Object)("authenticated admin access for: " + auth.getUser().getUsername()));
        }
        Cors.add(this.request).allowedOrigins(auth.getToken()).allowedMethods("GET", "PUT", "POST", "DELETE").auth().build(this.response);
        ServerInfoAdminResource adminResource = new ServerInfoAdminResource();
        ResteasyProviderFactory.getInstance().injectProperties((Object)adminResource);
        return adminResource;
    }

    public static Theme getTheme(KeycloakSession session, RealmModel realm) throws IOException {
        return session.theme().getTheme(Theme.Type.ADMIN);
    }

    public static Properties getMessages(KeycloakSession session, RealmModel realm, String lang) {
        try {
            Theme theme = AdminRoot.getTheme(session, realm);
            Locale locale = lang != null ? Locale.forLanguageTag(lang) : Locale.ENGLISH;
            return theme.getMessages(locale);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to load messages from theme", (Throwable)e);
            return new Properties();
        }
    }

    public static Properties getMessages(KeycloakSession session, RealmModel realm, String lang, String ... bundles) {
        Properties compound = new Properties();
        for (String bundle : bundles) {
            Properties current = AdminRoot.getMessages(session, realm, lang, bundle);
            compound.putAll((Map<?, ?>)current);
        }
        return compound;
    }

    private static Properties getMessages(KeycloakSession session, RealmModel realm, String lang, String bundle) {
        try {
            Theme theme = AdminRoot.getTheme(session, realm);
            Locale locale = lang != null ? Locale.forLanguageTag(lang) : Locale.ENGLISH;
            return theme.getMessages(bundle, locale);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to load messages from theme", (Throwable)e);
            return new Properties();
        }
    }
}

