/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class PropertiesUtil {
    private static final Logger logger = Logger.getLogger(PropertiesUtil.class);
    public static final Pattern DETECT_ENCODING_PATTERN = Pattern.compile("^#\\s*encoding:\\s*([\\w.:-]+)", 2);
    public static final Charset DEFAULT_ENCODING = Charset.forName("ISO-8859-1");

    public static Charset detectEncoding(InputStream in) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, DEFAULT_ENCODING));){
            Matcher matcher;
            String firstLine = br.readLine();
            if (firstLine != null && (matcher = DETECT_ENCODING_PATTERN.matcher(firstLine)).find()) {
                String encoding = matcher.group(1);
                if (Charset.isSupported(encoding)) {
                    Charset charset = Charset.forName(encoding);
                    return charset;
                }
                logger.warnv("Unsupported encoding: {0}", (Object)encoding);
            }
        }
        return DEFAULT_ENCODING;
    }
}

