/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.resources.account.resources.AbstractResourceService;
import org.keycloak.services.resources.account.resources.ResourceService;

public class ResourcesService
extends AbstractResourceService {
    public ResourcesService(KeycloakSession session, UserModel user, Auth auth, HttpRequest request) {
        super(session, user, auth, request);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getResources(@QueryParam(value="name") String name, @QueryParam(value="first") Integer first, @QueryParam(value="max") Integer max) {
        HashMap<String, String[]> filters = new HashMap<String, String[]>();
        filters.put("owner", new String[]{this.user.getId()});
        if (name != null) {
            filters.put("name", new String[]{name});
        }
        return this.queryResponse((f, m) -> this.resourceStore.findByResourceServer(filters, null, f.intValue(), m.intValue()).stream().map(resource -> new AbstractResourceService.Resource((Resource)resource, this.user, this.provider)), first, max);
    }

    @GET
    @Path(value="shared-with-me")
    @Produces(value={"application/json"})
    public Response getSharedWithMe(@QueryParam(value="name") String name, @QueryParam(value="first") Integer first, @QueryParam(value="max") Integer max) {
        return this.queryResponse((f, m) -> this.toPermissions(this.ticketStore.findGrantedResources(this.auth.getUser().getId(), name, f.intValue(), m.intValue()), false).stream(), first, max);
    }

    @GET
    @Path(value="shared-with-others")
    @Produces(value={"application/json"})
    public Response getSharedWithOthers(@QueryParam(value="first") Integer first, @QueryParam(value="max") Integer max) {
        return this.queryResponse((f, m) -> this.toPermissions(this.ticketStore.findGrantedOwnerResources(this.auth.getUser().getId(), f.intValue(), m.intValue()), true).stream(), first, max);
    }

    @Path(value="{id}")
    public Object getResource(@PathParam(value="id") String id) {
        Resource resource = this.resourceStore.findById(id, null);
        if (resource == null) {
            throw new NotFoundException("resource_not_found");
        }
        if (!resource.getOwner().equals(this.user.getId())) {
            throw new BadRequestException("invalid_resource");
        }
        return new ResourceService(resource, this.provider.getKeycloakSession(), this.user, this.auth, this.request);
    }

    private Collection<AbstractResourceService.ResourcePermission> toPermissions(List<Resource> resources, boolean withRequesters) {
        ArrayList<AbstractResourceService.ResourcePermission> permissions = new ArrayList<AbstractResourceService.ResourcePermission>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (Resource resource : resources) {
            List tickets;
            AbstractResourceService.ResourcePermission permission = new AbstractResourceService.ResourcePermission(resource, this.provider);
            if (withRequesters) {
                HashMap<String, String> filters = new HashMap<String, String>();
                filters.put("owner", this.user.getId());
                filters.put("granted", Boolean.TRUE.toString());
                filters.put("resource.id", resource.getId());
                tickets = ticketStore.find(filters, null, -1, -1);
            } else {
                tickets = ticketStore.findGranted(resource.getName(), this.user.getId(), null);
            }
            for (PermissionTicket ticket : tickets) {
                if (!resource.equals(ticket.getResource())) continue;
                if (withRequesters) {
                    AbstractResourceService.Permission user = permission.getPermission(ticket.getRequester());
                    if (user == null) {
                        user = new AbstractResourceService.Permission(ticket.getRequester(), this.provider);
                        permission.addPermission(ticket.getRequester(), user);
                    }
                    user.addScope(ticket.getScope().getName());
                    continue;
                }
                permission.addScope(new AbstractResourceService.Scope(ticket.getScope()));
            }
            permissions.add(permission);
        }
        return permissions;
    }

    private Response queryResponse(BiFunction<Integer, Integer, Stream<?>> query, Integer first, Integer max) {
        if (first != null && max != null) {
            List result = query.apply(first, max + 1).collect(Collectors.toList());
            int size = result.size();
            if (size > max) {
                result = result.subList(0, size - 1);
            }
            return this.cors(Response.ok().entity(result).links(this.createPageLinks(first, max, size)));
        }
        return this.cors(Response.ok().entity(query.apply(-1, -1).collect(Collectors.toList())));
    }

    private Link[] createPageLinks(Integer first, Integer max, int resultSize) {
        boolean nextPage;
        if (resultSize == 0 || first == 0 && resultSize <= max) {
            return new Link[0];
        }
        ArrayList<Link> links = new ArrayList<Link>();
        boolean bl = nextPage = resultSize > max;
        if (nextPage) {
            links.add(Link.fromUri((URI)KeycloakUriBuilder.fromUri((URI)this.request.getUri().getRequestUri()).replaceQuery("first={first}&max={max}").build(new Object[]{first + max, max})).rel("next").build(new Object[0]));
        }
        if (first > 0) {
            links.add(Link.fromUri((URI)KeycloakUriBuilder.fromUri((URI)this.request.getUri().getRequestUri()).replaceQuery("first={first}&max={max}").build(new Object[]{nextPage ? first : first - max, max})).rel("prev").build(new Object[0]));
        }
        return links.toArray(new Link[links.size()]);
    }
}

