/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.common.util.Resteasy;
import org.keycloak.common.util.ServerCookie;

public class CookieHelper {
    public static final String LEGACY_COOKIE = "_LEGACY";
    private static final Logger logger = Logger.getLogger(CookieHelper.class);

    public static void addCookie(String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly, ServerCookie.SameSiteAttributeValue sameSite) {
        ServerCookie.SameSiteAttributeValue sameSiteParam = sameSite;
        if (maxAge == 0) {
            sameSite = null;
        }
        boolean secure_sameSite = sameSite == ServerCookie.SameSiteAttributeValue.NONE || secure;
        HttpResponse response = Resteasy.getContextData(HttpResponse.class);
        StringBuffer cookieBuf = new StringBuffer();
        ServerCookie.appendCookieValue((StringBuffer)cookieBuf, (int)1, (String)name, (String)value, (String)path, (String)domain, (String)comment, (int)maxAge, (boolean)secure_sameSite, (boolean)httpOnly, (ServerCookie.SameSiteAttributeValue)sameSite);
        String cookie = cookieBuf.toString();
        response.getOutputHeaders().add((Object)"Set-Cookie", (Object)cookie);
        if (sameSiteParam == ServerCookie.SameSiteAttributeValue.NONE) {
            CookieHelper.addCookie(name + LEGACY_COOKIE, value, path, domain, comment, maxAge, secure, httpOnly, null);
        }
    }

    public static void addCookie(String name, String value, String path, String domain, String comment, int maxAge, boolean secure, boolean httpOnly) {
        CookieHelper.addCookie(name, value, path, domain, comment, maxAge, secure, httpOnly, null);
    }

    public static Set<String> getCookieValue(String name) {
        Cookie cookie;
        HttpHeaders headers = Resteasy.getContextData(HttpHeaders.class);
        HashSet<String> cookiesVal = new HashSet<String>();
        List cookieHeader = (List)headers.getRequestHeaders().get((Object)"Cookie");
        if (cookieHeader != null) {
            logger.debugv("{1} cookie found in the request's header", (Object)name);
            cookieHeader.stream().map(s -> CookieHelper.parseCookie(s, name)).forEach(cookiesVal::addAll);
        }
        if ((cookie = (Cookie)headers.getCookies().get(name)) != null) {
            logger.debugv("{1} cookie found in the cookie's field", (Object)name);
            cookiesVal.add(cookie.getValue());
        }
        return cookiesVal;
    }

    public static Set<String> parseCookie(String cookieHeader, String name) {
        String[] parts = cookieHeader.split("[;,]");
        Set<String> cookies = Arrays.stream(parts).filter(part -> part.startsWith(name + "=")).map(part -> part.substring(part.indexOf(61) + 1)).collect(Collectors.toSet());
        return cookies;
    }

    public static Cookie getCookie(Map<String, Cookie> cookies, String name) {
        Cookie cookie = cookies.get(name);
        if (cookie != null) {
            return cookie;
        }
        String legacy = name + LEGACY_COOKIE;
        logger.debugv("Couldn't find cookie {0}, trying {0}", (Object)name, (Object)legacy);
        return cookies.get(legacy);
    }
}

