/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.timer.basic;

import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.timer.TimerProvider;
import org.keycloak.timer.TimerProviderFactory;
import org.keycloak.timer.basic.BasicTimerProvider;
import org.keycloak.timer.basic.TimerTaskContextImpl;

public class BasicTimerProviderFactory
implements TimerProviderFactory {
    private Timer timer;
    private ConcurrentMap<String, TimerTaskContextImpl> scheduledTasks = new ConcurrentHashMap<String, TimerTaskContextImpl>();

    public TimerProvider create(KeycloakSession session) {
        return new BasicTimerProvider(session, this.timer, this);
    }

    public void init(Config.Scope config) {
        this.timer = new Timer();
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.timer.cancel();
        this.timer = null;
    }

    public String getId() {
        return "basic";
    }

    protected TimerTaskContextImpl putTask(String taskName, TimerTaskContextImpl task) {
        return this.scheduledTasks.put(taskName, task);
    }

    protected TimerTaskContextImpl removeTask(String taskName) {
        return (TimerTaskContextImpl)this.scheduledTasks.remove(taskName);
    }
}

