/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.twitter;

import org.keycloak.social.AuthCallback;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.RequestToken;

public class TwitterProvider
implements SocialProvider {
    public String getId() {
        return "twitter";
    }

    public AuthRequest getAuthUrl(SocialProviderConfig request) throws SocialProviderException {
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            twitter.setOAuthConsumer(request.getKey(), request.getSecret());
            RequestToken requestToken = twitter.getOAuthRequestToken(request.getCallbackUrl());
            return AuthRequest.create((String)requestToken.getToken(), (String)requestToken.getAuthenticationURL()).setAttribute("token", requestToken.getToken()).setAttribute("tokenSecret", requestToken.getTokenSecret()).build();
        }
        catch (Exception e) {
            throw new SocialProviderException((Throwable)e);
        }
    }

    public String getName() {
        return "Twitter";
    }

    public SocialUser processCallback(SocialProviderConfig config, AuthCallback callback) throws SocialProviderException {
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            twitter.setOAuthConsumer(config.getKey(), config.getSecret());
            String verifier = callback.getQueryParam("oauth_verifier");
            RequestToken requestToken = new RequestToken((String)callback.getAttribute("token"), (String)callback.getAttribute("tokenSecret"));
            twitter.getOAuthAccessToken(requestToken, verifier);
            User twitterUser = twitter.verifyCredentials();
            SocialUser user = new SocialUser(Long.toString(twitterUser.getId()));
            user.setUsername(twitterUser.getScreenName());
            String twitterName = twitterUser.getName();
            int spaceIndex = twitterName.lastIndexOf(32);
            if (spaceIndex != -1) {
                user.setFirstName(twitterName.substring(0, spaceIndex));
                user.setLastName(twitterName.substring(spaceIndex + 1));
            } else {
                user.setFirstName(twitterName);
            }
            return user;
        }
        catch (Exception e) {
            throw new SocialProviderException((Throwable)e);
        }
    }

    public String getRequestIdParamName() {
        return "oauth_token";
    }
}

