/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springboot;

import org.apache.catalina.Valve;
import org.keycloak.adapters.springboot.KeycloakBaseSpringBootConfiguration;
import org.keycloak.adapters.springboot.KeycloakSpringBootProperties;
import org.keycloak.adapters.tomcat.KeycloakAuthenticatorValve;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={KeycloakSpringBootProperties.class})
@ConditionalOnProperty(value={"keycloak.enabled"}, matchIfMissing=true)
public class KeycloakAutoConfiguration
extends KeycloakBaseSpringBootConfiguration {
    @Bean
    public WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> getKeycloakContainerCustomizer() {
        return new WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>(){

            public void customize(ConfigurableServletWebServerFactory configurableServletWebServerFactory) {
                if (configurableServletWebServerFactory instanceof TomcatServletWebServerFactory) {
                    TomcatServletWebServerFactory container = (TomcatServletWebServerFactory)configurableServletWebServerFactory;
                    container.addContextValves(new Valve[]{new KeycloakAuthenticatorValve()});
                    container.addContextCustomizers(new TomcatContextCustomizer[]{KeycloakAutoConfiguration.this.tomcatKeycloakContextCustomizer()});
                } else if (configurableServletWebServerFactory instanceof UndertowServletWebServerFactory) {
                    UndertowServletWebServerFactory container = (UndertowServletWebServerFactory)configurableServletWebServerFactory;
                    container.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{KeycloakAutoConfiguration.this.undertowKeycloakContextCustomizer()});
                } else if (configurableServletWebServerFactory instanceof JettyServletWebServerFactory) {
                    JettyServletWebServerFactory container = (JettyServletWebServerFactory)configurableServletWebServerFactory;
                    container.addServerCustomizers(new JettyServerCustomizer[]{KeycloakAutoConfiguration.this.jettyKeycloakServerCustomizer()});
                }
            }
        };
    }

    @Bean
    @ConditionalOnClass(name={"org.eclipse.jetty.webapp.WebAppContext"})
    public JettyServerCustomizer jettyKeycloakServerCustomizer() {
        return new KeycloakJettyServerCustomizer(this.keycloakProperties);
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.catalina.startup.Tomcat"})
    public TomcatContextCustomizer tomcatKeycloakContextCustomizer() {
        return new KeycloakTomcatContextCustomizer(this.keycloakProperties);
    }

    @Bean
    @ConditionalOnClass(name={"io.undertow.Undertow"})
    public UndertowDeploymentInfoCustomizer undertowKeycloakContextCustomizer() {
        return new KeycloakUndertowDeploymentInfoCustomizer(this.keycloakProperties);
    }

    static class KeycloakUndertowDeploymentInfoCustomizer
    extends KeycloakBaseSpringBootConfiguration.KeycloakBaseUndertowDeploymentInfoCustomizer
    implements UndertowDeploymentInfoCustomizer {
        public KeycloakUndertowDeploymentInfoCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            super(keycloakProperties);
        }
    }

    static class KeycloakTomcatContextCustomizer
    extends KeycloakBaseSpringBootConfiguration.KeycloakBaseTomcatContextCustomizer
    implements TomcatContextCustomizer {
        public KeycloakTomcatContextCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            super(keycloakProperties);
        }
    }

    static class KeycloakJettyServerCustomizer
    extends KeycloakBaseSpringBootConfiguration.KeycloakBaseJettyServerCustomizer
    implements JettyServerCustomizer {
        public KeycloakJettyServerCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            super(keycloakProperties);
        }
    }
}

