/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.federation.sssd.ReadonlySSSDUserModelDelegate;
import org.keycloak.federation.sssd.SSSDFederationProviderFactory;
import org.keycloak.federation.sssd.api.Sssd;
import org.keycloak.federation.sssd.impl.PAMAuthenticator;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.UserProfileDecorator;
import org.keycloak.userprofile.UserProfileMetadata;

public class SSSDFederationProvider
implements UserStorageProvider,
UserLookupProvider,
CredentialInputUpdater,
CredentialInputValidator,
ImportedUserValidation,
UserProfileDecorator {
    private static final Logger logger = Logger.getLogger(SSSDFederationProvider.class);
    protected static final Set<String> supportedCredentialTypes = new HashSet<String>();
    private final SSSDFederationProviderFactory factory;
    protected KeycloakSession session;
    protected UserStorageProviderModel model;

    public SSSDFederationProvider(KeycloakSession session, UserStorageProviderModel model, SSSDFederationProviderFactory sssdFederationProviderFactory) {
        this.session = session;
        this.model = model;
        this.factory = sssdFederationProviderFactory;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        return this.findOrCreateAuthenticatedUser(realm, username);
    }

    public UserModel validate(RealmModel realm, UserModel user) {
        return this.validateAndProxy(realm, user);
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, username);
        if (user != null) {
            logger.debug((Object)("SSSD authenticated user " + username + " found in Keycloak storage"));
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warn((Object)("User with username " + username + " already exists, but is not linked to provider [" + this.model.getName() + "]"));
                return null;
            }
            UserModel proxied = this.validateAndProxy(realm, user);
            if (proxied != null) {
                return proxied;
            }
            logger.warn((Object)("User with username " + username + " already exists and is linked to provider [" + this.model.getName() + "] but principal is not correct."));
            logger.warn((Object)"Will re-create user");
            new UserManager(this.session).removeUser(realm, user, UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session));
        }
        logger.debug((Object)("SSSD authenticated user " + username + " not in Keycloak storage. Creating..."));
        return this.importUserToKeycloak(realm, username);
    }

    protected UserModel importUserToKeycloak(RealmModel realm, String username) {
        Sssd sssd = new Sssd(username, this.factory.getDbusConnection());
        Sssd.User sssdUser = sssd.getUser();
        if (sssdUser == null) {
            return null;
        }
        logger.debugf("Creating SSSD user: %s to local Keycloak storage", (Object)username);
        UserModel user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).addUser(realm, username);
        user.setEnabled(true);
        user.setEmail(sssdUser.getEmail());
        user.setFirstName(sssdUser.getFirstName());
        user.setLastName(sssdUser.getLastName());
        for (String s : sssd.getGroups()) {
            GroupModel group2 = KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)realm, (String)("/" + s));
            if (group2 == null) {
                group2 = this.session.groups().createGroup(realm, s);
            }
            user.joinGroup(group2);
        }
        user.setFederationLink(this.model.getId());
        return this.validateAndProxy(realm, user);
    }

    public UserModel getUserById(RealmModel realm, String id) {
        return null;
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group2) {
    }

    public boolean isValid(RealmModel realm, UserModel local) {
        Sssd.User user = new Sssd(local.getUsername(), this.factory.getDbusConnection()).getUser();
        return user != null && user.equals(local);
    }

    public boolean supportsCredentialType(String credentialType) {
        return "password".equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return "password".equals(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!this.supportsCredentialType(input.getType()) || !(input instanceof UserCredentialModel)) {
            return false;
        }
        UserCredentialModel cred = (UserCredentialModel)input;
        PAMAuthenticator pam = this.factory.createPAMAuthenticator(user.getUsername(), cred.getChallengeResponse());
        return pam.authenticate() != null;
    }

    public UserModel validateAndProxy(RealmModel realm, UserModel local) {
        if (this.isValid(realm, local)) {
            return new ReadonlySSSDUserModelDelegate(local, this);
        }
        return null;
    }

    public void close() {
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        throw new ReadOnlyException("You can't update your password as your account is read only.");
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        return Stream.empty();
    }

    public void decorateUserProfile(RealmModel realm, UserProfileMetadata metadata) {
        Predicate<AttributeContext> sssdUsersSelector = attributeContext -> attributeContext.getUser() != null && this.model.getId().equals(attributeContext.getUser().getFederationLink());
        Predicate<AttributeContext> onlyAdminCondition = context -> metadata.getContext().isAdminContext();
        int guiOrder = (int)metadata.getAttributes().stream().map(AttributeMetadata::getName).distinct().count();
        for (String attrName : List.of("firstName", "lastName", "email", "username")) {
            List attrMetadatas = metadata.getAttribute(attrName);
            if (attrMetadatas.isEmpty()) {
                logger.debugf("Adding user profile attribute '%s' for sssd provider and context '%s'.", (Object)attrName, (Object)metadata.getContext());
                AttributeMetadata sssdAttrMetadata = metadata.addAttribute(attrName, guiOrder++, Collections.emptyList()).addWriteCondition(AttributeMetadata.ALWAYS_FALSE).addReadCondition(onlyAdminCondition).setRequired(AttributeMetadata.ALWAYS_FALSE);
                sssdAttrMetadata.setSelector(sssdUsersSelector);
                continue;
            }
            for (AttributeMetadata attrMetadata : attrMetadatas) {
                logger.debugf("Cloning attribute '%s' as read-only for sssd provider and context '%s'.", (Object)attrName, (Object)metadata.getContext());
                AttributeMetadata sssdAttrMetadata = metadata.addAttribute(attrMetadata.clone()).addWriteCondition(AttributeMetadata.ALWAYS_FALSE);
                sssdAttrMetadata.setSelector(sssdUsersSelector);
            }
        }
    }

    static {
        supportedCredentialTypes.add("password");
    }
}

