/*
 * Decompiled with CFR 0.152.
 */
package org.drools.statics;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.statics.SimpleInstanceCreator;
import org.kie.api.KieServices;
import org.kie.api.concurrent.KieExecutors;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.assembler.KieAssemblers;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.internal.builder.KnowledgeBuilderFactoryService;
import org.kie.internal.ruleunit.RuleUnitComponentFactory;
import org.kie.kogito.rules.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticServiceRegistry
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(StaticServiceRegistry.class);
    static final StaticServiceRegistry INSTANCE = new StaticServiceRegistry();
    private Map<Class<?>, Object> serviceMap = new HashMap();
    private Map<String, Constructor<?>> constructorMap = new HashMap();

    StaticServiceRegistry() {
        this.wireServices();
    }

    private void wireServices() {
        this.serviceMap.put(KieResources.class, SimpleInstanceCreator.instance("org.drools.core.io.impl.ResourceFactoryServiceImpl"));
        this.serviceMap.put(KieMarshallers.class, SimpleInstanceCreator.instance("org.drools.core.marshalling.impl.MarshallerProviderImpl"));
        this.serviceMap.put(KieExecutors.class, SimpleInstanceCreator.instance("org.drools.core.concurrent.ExecutorProviderImpl"));
        this.serviceMap.put(KieServices.class, SimpleInstanceCreator.instance("org.drools.compiler.kie.builder.impl.KieServicesImpl"));
        this.serviceMap.put(KnowledgeBuilderFactoryService.class, SimpleInstanceCreator.instance("org.drools.compiler.builder.impl.KnowledgeBuilderFactoryServiceImpl"));
        this.serviceMap.put(DataSource.Factory.class, SimpleInstanceCreator.instance("org.kie.kogito.rules.units.impl.DataSourceFactoryImpl"));
        this.serviceMap.put(RuleUnitComponentFactory.class, SimpleInstanceCreator.instance("org.kie.kogito.rules.units.impl.RuleUnitComponentFactoryImpl"));
        this.serviceMap.put(KieAssemblers.class, new StaticKieAssemblers());
        this.registerService("org.drools.compiler.kie.builder.impl.InternalKieModuleProvider", "org.drools.modelcompiler.CanonicalKieModuleProvider", true);
        this.registerService("org.drools.compiler.compiler.DecisionTableProvider", "org.drools.decisiontable.DecisionTableProviderImpl", false);
        this.constructorMap.put("TimerService", SimpleInstanceCreator.constructor("org.kie.services.time.impl.JDKTimerService"));
    }

    private void registerService(String service, String implementation, boolean mandatory) {
        try {
            this.serviceMap.put(Class.forName(service), SimpleInstanceCreator.instance(implementation));
        }
        catch (Exception e) {
            if (mandatory) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
            log.debug("Ignored non-mandatory service load error", (Throwable)e);
        }
    }

    public <T> T get(Class<T> cls) {
        return (T)this.serviceMap.get(cls);
    }

    public <T> T newInstance(String name) {
        try {
            return (T)this.constructorMap.get(name).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static class StaticKieAssemblers
    implements KieAssemblers {
        private Map<ResourceType, KieAssemblerService> assemblers = new HashMap<ResourceType, KieAssemblerService>();

        public void addResource(Object knowledgeBuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
            KieAssemblerService assembler = this.assemblers.get(type);
            if (assembler != null) {
                assembler.addResource(knowledgeBuilder, resource, type, configuration);
            } else {
                log.debug("KieAssemblers: ignored " + type);
            }
        }

        public void addResources(Object knowledgeBuilder, List<ResourceWithConfiguration> resources, ResourceType type) throws Exception {
            KieAssemblerService assembler = this.assemblers.get(type);
            if (assembler != null) {
                assembler.addResources(knowledgeBuilder, resources, type);
            } else {
                log.debug("KieAssemblers: ignored " + type);
            }
        }
    }
}

