/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.defeasible;

import java.util.Arrays;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.defeasible.DefeasibilityStatus;
import org.drools.core.beliefsystem.defeasible.Defeater;
import org.drools.core.beliefsystem.defeasible.Defeats;
import org.drools.core.beliefsystem.jtms.JTMSMode;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.kie.api.internal.runtime.beliefs.Mode;

public class DefeasibleMode<M extends DefeasibleMode<M>>
extends JTMSMode<M> {
    private static final String[] EMPTY_DEFEATS = new String[0];
    public static final String DEFEATS = Defeats.class.getSimpleName();
    public static final String DEFEATER = Defeater.class.getSimpleName();
    private DefeasibilityStatus status;
    private String[] defeats;
    private M rootDefeated;
    private M tailDefeated;
    private DefeasibleMode<M> defeatedBy;
    private boolean isDefeater;
    private BeliefSystem<M> beliefSystem;
    private Mode nextMode;

    @Override
    public Object getBeliefSystem() {
        return this.beliefSystem;
    }

    public DefeasibleMode(String value, BeliefSystem beliefSystem) {
        super(value, beliefSystem);
        this.beliefSystem = beliefSystem;
    }

    public DefeasibleMode(String value, BeliefSystem beliefSystem, Mode nextMode) {
        super(value, beliefSystem);
        this.beliefSystem = beliefSystem;
        this.nextMode = nextMode;
    }

    public void initDefeats() {
        Object o = this.getLogicalDependency().getJustifier().getRule().getMetaData().get(DEFEATER);
        if (o != null && ((Boolean)o).booleanValue()) {
            this.isDefeater = true;
        }
        if ((o = this.getLogicalDependency().getJustifier().getRule().getMetaData().get(DEFEATS)) != null) {
            if (o instanceof String) {
                this.defeats = new String[]{(String)o};
                Arrays.sort(this.defeats);
            } else if (o instanceof Object[]) {
                this.defeats = (String[])Arrays.copyOf((Object[])o, ((Object[])o).length, String[].class);
                Arrays.sort(this.defeats);
            }
        } else {
            this.defeats = EMPTY_DEFEATS;
        }
    }

    public void addDefeated(M defeated) {
        ((DefeasibleMode)defeated).setDefeatedBy(this);
        if (this.rootDefeated == null) {
            this.rootDefeated = defeated;
        } else {
            ((AbstractBaseLinkedListNode)this.tailDefeated).setNext(defeated);
            ((AbstractBaseLinkedListNode)defeated).setPrevious(this.tailDefeated);
        }
        this.tailDefeated = defeated;
    }

    public void removeDefeated(DefeasibleMode<M> defeated) {
        defeated.setDefeatedBy(null);
        if (this.rootDefeated == defeated) {
            this.removeFirst();
        } else if (this.tailDefeated == defeated) {
            this.removeLast();
        } else {
            Object entry;
            for (entry = this.rootDefeated; entry != defeated; entry = (DefeasibleMode)((AbstractBaseLinkedListNode)entry).getNext()) {
            }
            ((DefeasibleMode)((AbstractBaseLinkedListNode)entry).getPrevious()).setNext((DefeasibleMode)((AbstractBaseLinkedListNode)entry).getNext());
            ((DefeasibleMode)((AbstractBaseLinkedListNode)entry).getNext()).setPrevious((DefeasibleMode)((AbstractBaseLinkedListNode)entry).getPrevious());
            ((AbstractBaseLinkedListNode)entry).nullPrevNext();
        }
    }

    public DefeasibleMode<M> removeFirst() {
        if (this.rootDefeated == null) {
            return null;
        }
        M node = this.rootDefeated;
        this.rootDefeated = (DefeasibleMode)((AbstractBaseLinkedListNode)node).getNext();
        ((AbstractBaseLinkedListNode)node).setNext(null);
        if (this.rootDefeated != null) {
            ((AbstractBaseLinkedListNode)this.rootDefeated).setPrevious(null);
        } else {
            this.tailDefeated = null;
        }
        return node;
    }

    public DefeasibleMode<M> removeLast() {
        if (this.tailDefeated == null) {
            return null;
        }
        M node = this.tailDefeated;
        this.tailDefeated = (DefeasibleMode)((AbstractBaseLinkedListNode)node).getPrevious();
        ((AbstractBaseLinkedListNode)node).setPrevious(null);
        if (this.tailDefeated != null) {
            ((AbstractBaseLinkedListNode)this.tailDefeated).setNext(null);
        } else {
            this.rootDefeated = this.tailDefeated;
        }
        return node;
    }

    public M getRootDefeated() {
        return this.rootDefeated;
    }

    public M getTailDefeated() {
        return this.tailDefeated;
    }

    public String[] getDefeats() {
        return this.defeats;
    }

    public DefeasibleMode<M> getDefeatedBy() {
        return this.defeatedBy;
    }

    public void setDefeatedBy(DefeasibleMode<M> defeatedBy) {
        this.defeatedBy = defeatedBy;
    }

    public DefeasibilityStatus getStatus() {
        return this.status;
    }

    public void setStatus(DefeasibilityStatus status) {
        this.status = status;
    }

    public boolean isDefeater() {
        return this.isDefeater;
    }

    public void setDefeater(boolean defeater) {
        this.isDefeater = defeater;
    }

    public void clearDefeated() {
        this.rootDefeated = null;
        this.tailDefeated = null;
    }

    @Override
    public Mode getNextMode() {
        return this.nextMode;
    }

    public String toString() {
        return "DefeasibleMode{status=" + this.status + " Object=" + this.getLogicalDependency().getObject() + "} ";
    }
}

