/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.LinkedList;
import org.kie.services.time.JobHandle;
import org.kie.services.time.TimerService;

public class EventFactHandle
extends DefaultFactHandle
implements Comparable<EventFactHandle> {
    private static final long serialVersionUID = 510L;
    static final String EVENT_FORMAT_VERSION = "5";
    private long startTimestamp;
    private long duration;
    private boolean expired;
    private boolean pendingRemoveFromStore;
    private long activationsCount;
    private int otnCount;
    private EventFactHandle linkedFactHandle;
    private AtomicInteger notExpiredPartitions;
    private final transient LinkedList<JobHandleNode> jobs = new LinkedList();

    public EventFactHandle() {
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(long id, Object object, long recency, long timestamp, long duration, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, object, recency, timestamp, duration, wmEntryPoint, false);
    }

    public EventFactHandle(long id, Object object, long recency, long timestamp, long duration, WorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        super(id, object, recency, wmEntryPoint, isTraitOrTraitable);
        this.startTimestamp = timestamp;
        this.duration = duration;
        if (wmEntryPoint.getKnowledgeBase() != null && wmEntryPoint.getKnowledgeBase().getConfiguration().isMultithreadEvaluation()) {
            this.notExpiredPartitions = new AtomicInteger(RuleBasePartitionId.PARALLEL_PARTITIONS_NUMBER);
        }
    }

    @Override
    protected String getFormatVersion() {
        return EVENT_FORMAT_VERSION;
    }

    @Override
    public String toString() {
        return this.toExternalForm();
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEndTimestamp() {
        return this.startTimestamp + this.duration;
    }

    public EventFactHandle getLinkedFactHandle() {
        return this.linkedFactHandle;
    }

    @Override
    public void invalidate() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.invalidate();
        } else {
            super.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isValid();
        }
        return super.isValid();
    }

    @Override
    public boolean isExpired() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isExpired();
        }
        return this.expired;
    }

    public boolean expirePartition() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.expirePartition();
        }
        return this.notExpiredPartitions == null || this.notExpiredPartitions.decrementAndGet() == 0;
    }

    public void setExpired(boolean expired) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setExpired(expired);
        } else {
            this.expired = expired;
        }
    }

    @Override
    public boolean isPendingRemoveFromStore() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isPendingRemoveFromStore();
        }
        return this.pendingRemoveFromStore;
    }

    public void setPendingRemoveFromStore(boolean pendingRemove) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setPendingRemoveFromStore(pendingRemove);
        } else {
            this.pendingRemoveFromStore = pendingRemove;
        }
    }

    public long getActivationsCount() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.getActivationsCount();
        }
        return this.activationsCount;
    }

    public void setActivationsCount(long activationsCount) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setActivationsCount(activationsCount);
        } else {
            this.activationsCount = activationsCount;
        }
    }

    public void increaseActivationsCount() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.increaseActivationsCount();
        } else {
            ++this.activationsCount;
        }
    }

    public void decreaseActivationsCount() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.decreaseActivationsCount();
        } else {
            --this.activationsCount;
        }
    }

    public void increaseOtnCount() {
        ++this.otnCount;
    }

    public void decreaseOtnCount() {
        --this.otnCount;
    }

    public int getOtnCount() {
        return this.otnCount;
    }

    public void setOtnCount(int otnCount) {
        this.otnCount = otnCount;
    }

    @Override
    public EventFactHandle clone() {
        EventFactHandle clone = new EventFactHandle(this.getId(), this.getObject(), this.getRecency(), this.getStartTimestamp(), this.getDuration(), this.getEntryPoint(), this.isTraitOrTraitable());
        clone.setActivationsCount(this.getActivationsCount());
        clone.setOtnCount(this.getOtnCount());
        clone.setExpired(this.isExpired());
        clone.setEntryPoint(this.getEntryPoint());
        clone.setEqualityKey(this.getEqualityKey());
        clone.linkedTuples = this.linkedTuples.clone();
        clone.setObjectHashCode(this.getObjectHashCode());
        return clone;
    }

    private EventFactHandle cloneWithoutTuples() {
        EventFactHandle clone = new EventFactHandle(this.getId(), this.getObject(), this.getRecency(), this.getStartTimestamp(), this.getDuration(), this.getEntryPoint(), this.isTraitOrTraitable());
        clone.setActivationsCount(this.getActivationsCount());
        clone.setOtnCount(this.getOtnCount());
        clone.setExpired(this.isExpired());
        clone.setEntryPoint(this.getEntryPoint());
        clone.setEqualityKey(this.getEqualityKey());
        clone.setObjectHashCode(this.getObjectHashCode());
        return clone;
    }

    public EventFactHandle cloneAndLink() {
        EventFactHandle clone = this.cloneWithoutTuples();
        clone.linkedFactHandle = this;
        return clone;
    }

    public void quickCloneUpdate(DefaultFactHandle clone) {
        clone.setObject(this.getObject());
        clone.setRecency(this.getRecency());
        clone.setEqualityKey(this.getEqualityKey());
        clone.setObjectHashCode(this.getObjectHashCode());
        clone.setIdentityHashCode(this.getIdentityHashCode());
        clone.setTraitType(this.getTraitType());
        clone.setDisconnected(this.isDisconnected());
        clone.setNegated(this.isNegated());
    }

    @Override
    public int compareTo(EventFactHandle e) {
        return this.getStartTimestamp() < e.getStartTimestamp() ? -1 : (this.getStartTimestamp() == e.getStartTimestamp() ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(JobHandle job) {
        LinkedList<JobHandleNode> linkedList = this.jobs;
        synchronized (linkedList) {
            this.jobs.add(new JobHandleNode(job));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(JobHandle job) {
        LinkedList<JobHandleNode> linkedList = this.jobs;
        synchronized (linkedList) {
            if (this.jobs.contains(new JobHandleNode(job))) {
                this.jobs.remove(new JobHandleNode(job));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleAllJobs(InternalWorkingMemory workingMemory) {
        if (!this.jobs.isEmpty()) {
            LinkedList<JobHandleNode> linkedList = this.jobs;
            synchronized (linkedList) {
                TimerService clock = workingMemory.getTimerService();
                while (!this.jobs.isEmpty()) {
                    JobHandleNode job = this.jobs.removeFirst();
                    clock.removeJob(job.jobHandle);
                }
            }
        }
    }

    private static class JobHandleNode
    extends AbstractBaseLinkedListNode<JobHandleNode> {
        final JobHandle jobHandle;

        JobHandleNode(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public boolean equals(Object obj) {
            return obj instanceof JobHandleNode && ((JobHandleNode)obj).jobHandle.equals(this.jobHandle);
        }

        public int hashCode() {
            return this.jobHandle.hashCode();
        }
    }
}

