/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event;

import java.util.Iterator;
import java.util.List;
import org.drools.core.event.AbstractEventSupport;
import org.drools.core.event.ProcessCompletedEventImpl;
import org.drools.core.event.ProcessNodeLeftEventImpl;
import org.drools.core.event.ProcessNodeTriggeredEventImpl;
import org.drools.core.event.ProcessStartedEventImpl;
import org.drools.core.event.ProcessVariableChangedEventImpl;
import org.drools.core.event.ProcessWorkItemTransitionEventImpl;
import org.drools.core.event.SLAViolatedEventImpl;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.uow.WorkUnit;

public class ProcessEventSupport
extends AbstractEventSupport<ProcessEventListener> {
    private UnitOfWorkManager unitOfWorkManager;

    public ProcessEventSupport(UnitOfWorkManager unitOfWorkManager) {
        this.unitOfWorkManager = unitOfWorkManager;
    }

    public ProcessEventSupport() {
    }

    public void fireBeforeProcessStarted(ProcessInstance instance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessStartedEventImpl event = new ProcessStartedEventImpl(instance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).beforeProcessStarted(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireAfterProcessStarted(ProcessInstance instance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessStartedEventImpl event = new ProcessStartedEventImpl(instance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).afterProcessStarted(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireBeforeProcessCompleted(ProcessInstance instance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessCompletedEventImpl event = new ProcessCompletedEventImpl(instance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).beforeProcessCompleted(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireAfterProcessCompleted(ProcessInstance instance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessCompletedEventImpl event = new ProcessCompletedEventImpl(instance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).afterProcessCompleted(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireBeforeNodeTriggered(NodeInstance nodeInstance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessNodeTriggeredEventImpl event = new ProcessNodeTriggeredEventImpl(nodeInstance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).beforeNodeTriggered(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireAfterNodeTriggered(NodeInstance nodeInstance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessNodeTriggeredEventImpl event = new ProcessNodeTriggeredEventImpl(nodeInstance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).afterNodeTriggered(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireBeforeNodeLeft(NodeInstance nodeInstance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessNodeLeftEventImpl event = new ProcessNodeLeftEventImpl(nodeInstance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).beforeNodeLeft(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireAfterNodeLeft(NodeInstance nodeInstance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessNodeLeftEventImpl event = new ProcessNodeLeftEventImpl(nodeInstance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).afterNodeLeft(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireBeforeVariableChanged(String id, String instanceId, Object oldValue, Object newValue, List<String> tags, ProcessInstance processInstance, NodeInstance nodeInstance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessVariableChangedEventImpl event = new ProcessVariableChangedEventImpl(id, instanceId, oldValue, newValue, tags, processInstance, nodeInstance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).beforeVariableChanged(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireAfterVariableChanged(String name, String id, Object oldValue, Object newValue, List<String> tags, ProcessInstance processInstance, NodeInstance nodeInstance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessVariableChangedEventImpl event = new ProcessVariableChangedEventImpl(name, id, oldValue, newValue, tags, processInstance, nodeInstance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).afterVariableChanged(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireBeforeSLAViolated(ProcessInstance instance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).beforeSLAViolated(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireAfterSLAViolated(ProcessInstance instance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).afterSLAViolated(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireBeforeSLAViolated(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, nodeInstance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).beforeSLAViolated(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireAfterSLAViolated(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, nodeInstance, kruntime);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).afterSLAViolated(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireBeforeWorkItemTransition(ProcessInstance instance, WorkItem workitem, Transition<?> transition, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessWorkItemTransitionEventImpl event = new ProcessWorkItemTransitionEventImpl(instance, workitem, transition, kruntime, false);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).beforeWorkItemTransition(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void fireAfterWorkItemTransition(ProcessInstance instance, WorkItem workitem, Transition<?> transition, KieRuntime kruntime) {
        Iterator iter = this.getEventListenersIterator();
        ProcessWorkItemTransitionEventImpl event = new ProcessWorkItemTransitionEventImpl(instance, workitem, transition, kruntime, true);
        this.unitOfWorkManager.currentUnitOfWork().intercept(WorkUnit.create((Object)event, e -> {
            if (iter.hasNext()) {
                do {
                    ((ProcessEventListener)iter.next()).afterWorkItemTransition(e);
                } while (iter.hasNext());
            }
        }));
    }

    public void reset() {
        this.clear();
    }
}

