/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.builder.dialect.asm;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.addon.TypeResolver;
import org.drools.core.rule.builder.dialect.asm.ClassLevel;
import org.drools.core.util.ClassUtils;
import org.drools.reflective.util.ByteArrayClassLoader;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class ClassGenerator {
    public static final boolean DUMP_GENERATED_CLASSES = false;
    private final String className;
    private final TypeResolver typeResolver;
    private final ClassLoader classLoader;
    private int access = 33;
    private String signature;
    private Class superClass = Object.class;
    private Class<?>[] interfaces;
    private final String classDescriptor;
    private String superDescriptor;
    private List<ClassPartDescr> classParts = new ArrayList<ClassPartDescr>();
    private StaticInitializerDescr staticInitializer = null;
    private byte[] bytecode;
    private Class<?> clazz;
    private Map<Class<?>, String> descriptorsCache = new HashMap();
    private static final MethodBody EMPTY_METHOD_BODY = new MethodBody(){

        @Override
        protected final void body(MethodVisitor mv) {
            mv.visitInsn(177);
        }
    };

    public ClassGenerator(String className, ClassLoader classLoader) {
        this(className, classLoader, null);
    }

    public ClassGenerator(String className, ClassLoader classLoader, TypeResolver typeResolver) {
        this.className = className;
        this.classDescriptor = className.replace('.', '/');
        this.classLoader = classLoader;
        this.typeResolver = typeResolver == null ? new InternalTypeResolver(this.classLoader) : typeResolver;
    }

    public byte[] generateBytecode() {
        if (this.bytecode == null) {
            ClassWriter cw = ClassGenerator.createClassWriter(this.classLoader, this.access, this.getClassDescriptor(), this.signature, this.getSuperClassDescriptor(), this.toInteralNames(this.interfaces));
            for (int i = 0; i < this.classParts.size(); ++i) {
                this.classParts.get(i).write(this, cw);
            }
            if (this.staticInitializer != null) {
                this.staticInitializer.write(this, cw);
            }
            cw.visitEnd();
            this.bytecode = cw.toByteArray();
        }
        return this.bytecode;
    }

    private Class<?> generateClass() {
        if (this.clazz == null) {
            byte[] bytecode = this.generateBytecode();
            if (ClassUtils.isAndroid()) {
                ByteArrayClassLoader cl = (ByteArrayClassLoader)ClassUtils.instantiateObject((String)"org.drools.android.MultiDexClassLoader", null, (Object[])new Object[]{this.classLoader});
                this.clazz = cl.defineClass(this.className, bytecode, null);
            } else {
                try {
                    this.clazz = (Class)DefineMethodInitializer.defineClassMethod.invoke((Object)this.classLoader, this.className, bytecode, 0, bytecode.length);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.clazz;
    }

    public void dumpGeneratedClass() {
        this.dumpGeneratedClass(this.generateBytecode());
    }

    private void dumpGeneratedClass(byte[] bytecode) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.className + ".class");
            fos.write(bytecode);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public <T> T newInstance() {
        try {
            return (T)this.generateClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T newInstance(Class paramType, Object param) {
        try {
            return (T)this.generateClass().getConstructor(paramType).newInstance(param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T newInstance(Class paramType1, Object param1, Class paramType2, Object param2) {
        try {
            return (T)this.generateClass().getConstructor(paramType1, paramType2).newInstance(param1, param2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getClassDescriptor() {
        return this.classDescriptor;
    }

    public String getSuperClassDescriptor() {
        if (this.superDescriptor == null) {
            this.superDescriptor = this.toInteralName(this.superClass);
        }
        return this.superDescriptor;
    }

    public ClassGenerator setAccess(int access) {
        this.access = access;
        return this;
    }

    public ClassGenerator setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public ClassGenerator setSuperClass(Class superClass) {
        this.superClass = superClass;
        return this;
    }

    public ClassGenerator setInterfaces(Class<?> ... interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    private String descriptorOf(Class<?> type) {
        String descriptor = this.descriptorsCache.get(type);
        if (descriptor == null) {
            descriptor = Type.getDescriptor(type);
            this.descriptorsCache.put(type, descriptor);
        }
        return descriptor;
    }

    public String methodDescr(Class<?> type, Class<?> ... args) {
        StringBuilder desc = new StringBuilder("(");
        if (args != null) {
            for (Class<?> arg : args) {
                desc.append(this.descriptorOf(arg));
            }
        }
        desc.append(")").append(type == null ? "V" : this.descriptorOf(type));
        return desc.toString();
    }

    private Type toType(Class<?> clazz) {
        return this.toType(clazz.getName());
    }

    private Type toType(String typeName) {
        return Type.getType((String)this.toTypeDescriptor(typeName));
    }

    public String toTypeDescriptor(Class<?> clazz) {
        return this.descriptorOf(clazz);
    }

    public String toTypeDescriptor(String className) {
        Object typeDescriptor;
        StringBuilder arrayPrefix = new StringBuilder();
        while (className.endsWith("[]")) {
            arrayPrefix.append("[");
            className = className.substring(0, className.length() - 2);
        }
        try {
            typeDescriptor = this.toTypeDescriptor(this.typeResolver.resolveType(className));
        }
        catch (ClassNotFoundException e) {
            typeDescriptor = "L" + className.replace('.', '/') + ";";
        }
        return arrayPrefix.toString() + (String)typeDescriptor;
    }

    public String toInteralName(Class<?> clazz) {
        return clazz.isPrimitive() ? this.descriptorOf(clazz) : Type.getType(clazz).getInternalName();
    }

    public String toInteralName(String className) {
        Object typeDescriptor;
        StringBuilder arrayPrefix = new StringBuilder();
        while (className.endsWith("[]")) {
            arrayPrefix.append("[");
            className = className.substring(0, className.length() - 2);
        }
        boolean isPrimitive = false;
        try {
            Class<?> clazz = this.typeResolver.resolveType(className);
            isPrimitive = clazz.isPrimitive();
            typeDescriptor = this.toInteralName(clazz);
        }
        catch (ClassNotFoundException e) {
            typeDescriptor = className.replace('.', '/');
        }
        if (!isPrimitive && arrayPrefix.length() > 0) {
            typeDescriptor = "L" + (String)typeDescriptor + ";";
        }
        return arrayPrefix.toString() + (String)typeDescriptor;
    }

    public String getClassName() {
        return this.className;
    }

    private String[] toInteralNames(Class<?>[] classes) {
        if (classes == null) {
            return null;
        }
        String[] internals = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            internals[i] = this.toInteralName(classes[i]);
        }
        return internals;
    }

    public ClassGenerator addField(int access, String name, Class<?> type) {
        return this.addField(access, name, type, null, null);
    }

    public ClassGenerator addField(int access, String name, Class<?> type, String signature) {
        return this.addField(access, name, type, signature, null);
    }

    public ClassGenerator addStaticField(int access, String name, Class<?> type, Object value) {
        return this.addField(access + 8, name, type, null, value);
    }

    public ClassGenerator addStaticField(int access, String name, Class<?> type, String signature, Object value) {
        return this.addField(access + 8, name, type, signature, value);
    }

    private ClassGenerator addField(int access, String name, Class<?> type, String signature, Object value) {
        this.classParts.add(new FieldDescr(access, name, this.descriptorOf(type), signature, value));
        return this;
    }

    public ClassGenerator addDefaultConstructor() {
        return this.addDefaultConstructor(EMPTY_METHOD_BODY, new Class[0]);
    }

    public ClassGenerator addDefaultConstructor(final MethodBody body, Class<?> ... args) {
        MethodBody constructorBody = new MethodBody(){

            @Override
            public void body(MethodVisitor mv) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, this.getClassGenerator().getSuperClassDescriptor(), "<init>", "()V");
                body.writeBody(this.getClassGenerator(), mv);
            }
        };
        return this.addMethod(1, "<init>", this.methodDescr(null, args), constructorBody);
    }

    public ClassGenerator addMethod(int access, String name, String desc) {
        return this.addMethod(access, name, desc, null, null, EMPTY_METHOD_BODY);
    }

    public ClassGenerator addMethod(int access, String name, String desc, MethodBody body) {
        return this.addMethod(access, name, desc, null, null, body);
    }

    public ClassGenerator addMethod(int access, String name, String desc, String signature, MethodBody body) {
        return this.addMethod(access, name, desc, signature, null, body);
    }

    public ClassGenerator addMethod(int access, String name, String desc, String[] exceptions, MethodBody body) {
        return this.addMethod(access, name, desc, null, exceptions, body);
    }

    public ClassGenerator addMethod(int access, String name, String desc, String signature, String[] exceptions, MethodBody body) {
        this.classParts.add(new MethodDescr(access, name, desc, signature, exceptions, body));
        return this;
    }

    public ClassGenerator addStaticInitBlock(MethodBody body) {
        if (this.staticInitializer == null) {
            this.staticInitializer = new StaticInitializerDescr();
        }
        this.staticInitializer.addInitializer(body);
        return this;
    }

    public static ClassWriter createClassWriter(ClassLoader classLoader, int access, String name, String signature, String superName, String[] interfaces) {
        InternalClassWriter cw = new InternalClassWriter(classLoader, 3);
        cw.visit(ClassLevel.getJavaVersion(classLoader), access, name, signature, superName, interfaces);
        return cw;
    }

    public static class InternalClassWriter
    extends ClassWriter {
        private ClassLoader classLoader;

        public InternalClassWriter(ClassLoader classLoader, int flags) {
            super(flags);
            this.classLoader = classLoader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            try {
                c = Class.forName(type1.replace('/', '.'), false, this.classLoader);
                d = Class.forName(type2.replace('/', '.'), false, this.classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }

    private static class InternalTypeResolver
    implements TypeResolver {
        public static final Map<String, Class<?>> primitiveClassMap = new HashMap<String, Class<?>>(){
            {
                this.put("int", Integer.TYPE);
                this.put("boolean", Boolean.TYPE);
                this.put("float", Float.TYPE);
                this.put("long", Long.TYPE);
                this.put("short", Short.TYPE);
                this.put("byte", Byte.TYPE);
                this.put("double", Double.TYPE);
                this.put("char", Character.TYPE);
            }
        };
        private final ClassLoader classLoader;

        private InternalTypeResolver(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Set<String> getImports() {
            throw new RuntimeException("Not Implemented");
        }

        @Override
        public void addImport(String importEntry) {
            throw new RuntimeException("Not Implemented");
        }

        @Override
        public void addImplicitImport(String importEntry) {
            throw new RuntimeException("Not Implemented");
        }

        @Override
        public Class<?> resolveType(String className) throws ClassNotFoundException {
            Class<?> primitiveClassName = primitiveClassMap.get(className);
            return primitiveClassName != null ? primitiveClassName : Class.forName(className, true, this.classLoader);
        }

        @Override
        public Class<?> resolveType(String className, TypeResolver.ClassFilter classFilter) throws ClassNotFoundException {
            throw new RuntimeException("Not Implemented");
        }

        @Override
        public String getFullTypeName(String shortName) throws ClassNotFoundException {
            throw new RuntimeException("Not Implemented");
        }

        @Override
        public void registerClass(String className, Class<?> clazz) {
            throw new RuntimeException("Not Implemented");
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }

    private static class StaticInitializerDescr
    implements ClassPartDescr {
        private final List<MethodBody> initializerBodies = new ArrayList<MethodBody>();

        private StaticInitializerDescr() {
        }

        @Override
        public void write(ClassGenerator cg, ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            try {
                for (MethodBody initializerBody : this.initializerBodies) {
                    initializerBody.writeBody(cg, mv);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error writing method static class initializer", e);
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void addInitializer(MethodBody initBlock) {
            this.initializerBodies.add(initBlock);
        }
    }

    private static class MethodDescr
    implements ClassPartDescr {
        private final int access;
        private final String name;
        private final String desc;
        private final String signature;
        private final String[] exceptions;
        private final MethodBody body;

        private MethodDescr(int access, String name, String desc, String signature, String[] exceptions, MethodBody body) {
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.signature = signature;
            this.exceptions = exceptions;
            this.body = body;
        }

        @Override
        public void write(ClassGenerator cg, ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(this.access, this.name, this.desc, this.signature, this.exceptions);
            mv.visitCode();
            try {
                this.body.writeBody(cg, mv);
                mv.visitMaxs(0, 0);
            }
            catch (Exception e) {
                throw new RuntimeException("Error writing method " + this.name, e);
            }
            mv.visitEnd();
        }
    }

    public static abstract class MethodBody {
        private ClassGenerator classGenerator;
        protected MethodVisitor mv;
        private Map<Integer, Type> storedTypes;

        protected abstract void body(MethodVisitor var1);

        public final void writeBody(ClassGenerator classGenerator, MethodVisitor mv) {
            this.classGenerator = classGenerator;
            this.mv = mv;
            try {
                this.body(mv);
            }
            finally {
                this.classGenerator = null;
                this.mv = null;
            }
        }

        protected ClassGenerator getClassGenerator() {
            return this.classGenerator;
        }

        protected final int getCodeForType(Class<?> typeClass, int opcode) {
            return Type.getType(typeClass).getOpcode(opcode);
        }

        protected final int store(int registry, Class<?> typeClass) {
            return this.store(registry, Type.getType(typeClass));
        }

        protected final int store(int registry, String typeName) {
            return this.store(registry, this.classGenerator.toType(typeName));
        }

        protected final int store(int registry, Type t) {
            if (this.storedTypes == null) {
                this.storedTypes = new HashMap<Integer, Type>();
            }
            this.mv.visitVarInsn(t.getOpcode(54), registry);
            this.storedTypes.put(registry, t);
            return t.getSize();
        }

        protected final void load(int registry) {
            this.mv.visitVarInsn(this.storedTypes.get(registry).getOpcode(21), registry);
        }

        protected final void loadAsObject(int registry) {
            Type type = this.storedTypes.get(registry);
            this.mv.visitVarInsn(type.getOpcode(21), registry);
            String typeName = type.getClassName();
            this.convertPrimitiveToObject(typeName);
        }

        protected void convertPrimitiveToObject(Class<?> primitiveClass) {
            this.convertPrimitiveToObject(primitiveClass.getName());
        }

        private void convertPrimitiveToObject(String typeName) {
            if (typeName.equals("int")) {
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            } else if (typeName.equals("boolean")) {
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            } else if (typeName.equals("char")) {
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            } else if (typeName.equals("byte")) {
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            } else if (typeName.equals("short")) {
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            } else if (typeName.equals("float")) {
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            } else if (typeName.equals("long")) {
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            } else if (typeName.equals("double")) {
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
        }

        protected final void print(String msg) {
            this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            this.mv.visitLdcInsn((Object)msg);
            this.mv.visitMethodInsn(182, "java/io/PrintStream", "print", "(Ljava/lang/String;)V");
        }

        protected final void println(String msg) {
            this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            this.mv.visitLdcInsn((Object)msg);
            this.mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        }

        protected final void printRegistryValue(int reg) {
            Type type = this.storedTypes.get(reg);
            if (type == null) {
                this.printRegistryValue(reg, Object.class);
                return;
            }
            this.printRegistryValue(reg, org.drools.reflective.util.ClassUtils.convertPrimitiveNameToType((String)type.getClassName()));
        }

        protected final void printRegistryValue(int reg, Class<?> clazz) {
            this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            this.mv.visitVarInsn(Type.getType(clazz).getOpcode(21), reg);
            this.invokeVirtual(PrintStream.class, "print", null, clazz);
        }

        protected final void printLastRegistry(Class<?> clazz) {
            Type t = Type.getType(clazz);
            this.mv.visitVarInsn(t.getOpcode(54), 100);
            this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
            this.mv.visitVarInsn(t.getOpcode(21), 100);
            this.invokeVirtual(PrintStream.class, "print", null, clazz);
        }

        protected final void printStack() {
            this.mv.visitTypeInsn(187, "java/lang/RuntimeException");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "()V");
            this.mv.visitMethodInsn(182, "java/lang/RuntimeException", "printStackTrace", "()V");
            this.mv.visitInsn(177);
        }

        protected final <T> void returnAsArray(T[] array) {
            this.createArray(array.getClass().getComponentType(), array.length);
            for (int i = 0; i < array.length; ++i) {
                this.mv.visitInsn(89);
                this.push(i);
                this.push(array[i]);
                this.mv.visitInsn(83);
            }
            this.mv.visitInsn(176);
        }

        protected final <T> void returnAsArray(Collection<T> collection, Class<T> clazz) {
            this.createArray(clazz, collection.size());
            int i = 0;
            for (T item : collection) {
                this.mv.visitInsn(89);
                this.push(i++);
                this.push(item);
                this.mv.visitInsn(83);
            }
            this.mv.visitInsn(176);
        }

        protected final void createArray(Class<?> componentType, int size) {
            this.mv.visitLdcInsn((Object)size);
            if (componentType.isPrimitive()) {
                int newPrimitiveArrayType = 4;
                if (componentType == Integer.TYPE) {
                    newPrimitiveArrayType = 10;
                } else if (componentType == Long.TYPE) {
                    newPrimitiveArrayType = 11;
                } else if (componentType == Double.TYPE) {
                    newPrimitiveArrayType = 7;
                } else if (componentType == Float.TYPE) {
                    newPrimitiveArrayType = 6;
                } else if (componentType == Character.TYPE) {
                    newPrimitiveArrayType = 5;
                } else if (componentType == Short.TYPE) {
                    newPrimitiveArrayType = 9;
                } else if (componentType == Byte.TYPE) {
                    newPrimitiveArrayType = 8;
                }
                this.mv.visitIntInsn(188, newPrimitiveArrayType);
            } else {
                this.mv.visitTypeInsn(189, this.internalName(componentType));
            }
        }

        protected final void push(Object obj) {
            if (obj instanceof Boolean) {
                this.mv.visitFieldInsn(178, "java/lang/Boolean", (Boolean)obj != false ? "TRUE" : "FALSE", "Ljava/lang/Boolean;");
            } else {
                this.mv.visitLdcInsn(obj);
            }
        }

        protected final void push(Object obj, Class<?> type) {
            if (obj == null) {
                this.mv.visitInsn(1);
                return;
            }
            if (type == String.class || type == Object.class) {
                this.mv.visitLdcInsn(obj);
            } else if (type == Character.TYPE) {
                this.mv.visitIntInsn(16, (int)((Character)obj).charValue());
            } else if (type.isPrimitive()) {
                obj = obj instanceof String ? this.coerceStringToPrimitive(type, (String)obj) : this.coercePrimitiveToPrimitive(type, obj);
                this.mv.visitLdcInsn(obj);
            } else if (type == Class.class) {
                this.mv.visitLdcInsn((Object)this.classGenerator.toType((Class)obj));
            } else if (type == Character.class) {
                this.invokeConstructor(Character.class, new Object[]{Character.valueOf(obj.toString().charAt(0))}, Character.TYPE);
            } else if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
                this.push(obj, obj.getClass());
            } else {
                this.invokeConstructor(type, new Object[]{obj.toString()}, String.class);
            }
        }

        private Object coercePrimitiveToPrimitive(Class<?> primitiveType, Object value) {
            if (primitiveType == Long.TYPE) {
                return ((Number)value).longValue();
            }
            if (primitiveType == Double.TYPE) {
                return ((Number)value).doubleValue();
            }
            if (primitiveType == Float.TYPE) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return value;
        }

        private Object coerceStringToPrimitive(Class<?> primitiveType, String value) {
            if (primitiveType == Boolean.TYPE) {
                return Boolean.valueOf(value);
            }
            if (primitiveType == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (primitiveType == Long.TYPE) {
                return Long.valueOf(value);
            }
            if (primitiveType == Float.TYPE) {
                return Float.valueOf(value);
            }
            if (primitiveType == Double.TYPE) {
                return Double.valueOf(value);
            }
            if (primitiveType == Character.TYPE) {
                return Character.valueOf(value.charAt(0));
            }
            if (primitiveType == Short.TYPE) {
                return Short.valueOf(value);
            }
            if (primitiveType == Byte.TYPE) {
                return Byte.valueOf(value);
            }
            throw new RuntimeException("Unexpected type: " + primitiveType);
        }

        protected final void cast(Class<?> from, Class<?> to) {
            if (to.isAssignableFrom(from)) {
                return;
            }
            if (from.isPrimitive()) {
                if (to.isPrimitive()) {
                    this.castPrimitiveToPrimitive(from, to);
                } else if (to == Object.class) {
                    this.castFromPrimitive(from);
                } else {
                    Class toPrimitive = org.drools.reflective.util.ClassUtils.convertToPrimitiveType(to);
                    this.castPrimitiveToPrimitive(org.drools.reflective.util.ClassUtils.convertToPrimitiveType(from), toPrimitive);
                    this.castFromPrimitive(toPrimitive);
                }
            } else if (to.isPrimitive()) {
                Class primitiveFrom = org.drools.reflective.util.ClassUtils.convertToPrimitiveType(from);
                this.castToPrimitive(primitiveFrom);
                this.castPrimitiveToPrimitive(primitiveFrom, to);
            } else {
                this.cast(to);
            }
        }

        protected final void cast(Class<?> clazz) {
            this.mv.visitTypeInsn(192, this.internalName(clazz));
        }

        protected final void instanceOf(Class<?> clazz) {
            this.mv.visitTypeInsn(193, this.internalName(clazz));
        }

        protected final void castPrimitiveToPrimitive(Class<?> from, Class<?> to) {
            if (from == to) {
                return;
            }
            if (from == Integer.TYPE) {
                if (to == Long.TYPE) {
                    this.mv.visitInsn(133);
                } else if (to == Float.TYPE) {
                    this.mv.visitInsn(134);
                } else if (to == Double.TYPE) {
                    this.mv.visitInsn(135);
                } else if (to == Byte.TYPE) {
                    this.mv.visitInsn(145);
                } else if (to == Character.TYPE) {
                    this.mv.visitInsn(146);
                } else if (to == Short.TYPE) {
                    this.mv.visitInsn(147);
                }
            } else if (from == Long.TYPE) {
                if (to == Integer.TYPE) {
                    this.mv.visitInsn(136);
                } else if (to == Float.TYPE) {
                    this.mv.visitInsn(137);
                } else if (to == Double.TYPE) {
                    this.mv.visitInsn(138);
                }
            } else if (from == Float.TYPE) {
                if (to == Integer.TYPE) {
                    this.mv.visitInsn(139);
                } else if (to == Long.TYPE) {
                    this.mv.visitInsn(140);
                } else if (to == Double.TYPE) {
                    this.mv.visitInsn(141);
                }
            } else if (from == Double.TYPE) {
                if (to == Integer.TYPE) {
                    this.mv.visitInsn(142);
                } else if (to == Long.TYPE) {
                    this.mv.visitInsn(143);
                } else if (to == Float.TYPE) {
                    this.mv.visitInsn(144);
                }
            }
        }

        protected final void castFromPrimitive(Class<?> clazz) {
            Class boxedType = org.drools.reflective.util.ClassUtils.convertFromPrimitiveType(clazz);
            this.invokeStatic(boxedType, "valueOf", boxedType, clazz);
        }

        protected final void castToPrimitive(Class<?> clazz) {
            if (clazz == Boolean.TYPE) {
                this.cast(Boolean.class);
                this.invokeVirtual(Boolean.class, "booleanValue", Boolean.TYPE, new Class[0]);
            } else if (clazz == Character.TYPE) {
                this.cast(Character.class);
                this.invokeVirtual(Character.class, "charValue", Character.TYPE, new Class[0]);
            } else {
                this.cast(Number.class);
                this.invokeVirtual(Number.class, clazz.getName() + "Value", clazz, new Class[0]);
            }
        }

        protected final void invoke(Method method) {
            if ((method.getModifiers() & 8) > 0) {
                this.invokeStatic(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getParameterTypes());
            } else if (method.getDeclaringClass().isInterface()) {
                this.invokeInterface(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getParameterTypes());
            } else {
                this.invokeVirtual(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getParameterTypes());
            }
        }

        protected final void invokeThis(String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.mv.visitMethodInsn(182, this.classDescriptor(), methodName, this.methodDescr(returnedType, paramsType));
        }

        protected final void invokeStatic(Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.invoke(184, clazz, methodName, returnedType, paramsType);
        }

        protected final void invokeVirtual(Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.invoke(182, clazz, methodName, returnedType, paramsType);
        }

        protected final void invokeInterface(Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.invoke(185, clazz, methodName, returnedType, paramsType);
        }

        protected final void invokeConstructor(Class<?> clazz) {
            this.invokeConstructor(clazz, null, new Class[0]);
        }

        protected final void invokeConstructor(Class<?> clazz, Object[] params, Class<?> ... paramsType) {
            this.mv.visitTypeInsn(187, this.internalName(clazz));
            this.mv.visitInsn(89);
            if (params != null) {
                for (Object param : params) {
                    this.mv.visitLdcInsn(param);
                }
            }
            this.invokeSpecial(clazz, "<init>", null, paramsType);
        }

        protected final void invokeSpecial(Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.invoke(183, clazz, methodName, returnedType, paramsType);
        }

        protected final void invoke(int opCode, Class<?> clazz, String methodName, Class<?> returnedType, Class<?> ... paramsType) {
            this.mv.visitMethodInsn(opCode, this.internalName(clazz), methodName, this.methodDescr(returnedType, paramsType));
        }

        protected final void putStaticField(String name, Class<?> type) {
            this.mv.visitFieldInsn(179, this.classDescriptor(), name, this.classGenerator.descriptorOf(type));
        }

        protected final void getStaticField(String name, Class<?> type) {
            this.mv.visitFieldInsn(178, this.classDescriptor(), name, this.classGenerator.descriptorOf(type));
        }

        protected final void putFieldInThisFromRegistry(String name, Class<?> type, int regNr) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, regNr);
            this.putFieldInThis(name, type);
        }

        protected final void putFieldInThis(String name, Class<?> type) {
            this.mv.visitFieldInsn(181, this.classDescriptor(), name, this.classGenerator.descriptorOf(type));
        }

        protected final void getFieldFromThis(String name, Class<?> type) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.classDescriptor(), name, this.classGenerator.descriptorOf(type));
        }

        protected final void readField(Field field) {
            boolean isStatic = (field.getModifiers() & 8) != 0;
            this.mv.visitFieldInsn(isStatic ? 178 : 180, field.getDeclaringClass().getName().replace('.', '/'), field.getName(), this.classGenerator.descriptorOf(field.getType()));
        }

        public String classDescriptor() {
            return this.classGenerator.getClassDescriptor();
        }

        public String superClassDescriptor() {
            return this.classGenerator.getSuperClassDescriptor();
        }

        public String methodDescr(Class<?> type, Class<?> ... args) {
            return this.classGenerator.methodDescr(type, args);
        }

        private Type type(String typeName) {
            return this.classGenerator.toType(typeName);
        }

        public String typeDescr(Class<?> clazz) {
            return this.classGenerator.toTypeDescriptor(clazz);
        }

        public String typeDescr(String className) {
            return this.classGenerator.toTypeDescriptor(className);
        }

        public String internalName(Class<?> clazz) {
            return this.classGenerator.toInteralName(clazz);
        }

        public String internalName(String className) {
            return this.classGenerator.toInteralName(className);
        }
    }

    private static class FieldDescr
    implements ClassPartDescr {
        private final int access;
        private final String name;
        private final String desc;
        private final String signature;
        private final Object value;

        FieldDescr(int access, String name, String desc, String signature, Object value) {
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.signature = signature;
            this.value = value;
        }

        @Override
        public void write(ClassGenerator cg, ClassWriter cw) {
            cw.visitField(this.access, this.name, this.desc, this.signature, this.value).visitEnd();
        }
    }

    private static interface ClassPartDescr {
        public void write(ClassGenerator var1, ClassWriter var2);
    }

    private static class DefineMethodInitializer {
        private static final String PROPERTY_IMAGE_CODE_KEY = "org.graalvm.nativeimage.imagecode";
        private static final Method defineClassMethod = DefineMethodInitializer.createDefineMethod();

        private DefineMethodInitializer() {
        }

        private static Method createDefineMethod() {
            if (DefineMethodInitializer.inImageCode()) {
                return null;
            }
            try {
                Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClassMethod.setAccessible(true);
                return defineClassMethod;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private static boolean inImageCode() {
            return System.getProperty(PROPERTY_IMAGE_CODE_KEY) != null;
        }
    }
}

