/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.mbean;

import org.dashbuilder.dataprovider.kafka.mbean.ObjectNameBuilder;

public interface ObjectNamePrototype {
    public static ObjectNamePrototype withDomainAndType(String domain, String type) {
        return new ObjectNameWithDomainAndTypePrototype(domain, type);
    }

    public static ObjectNamePrototype withDomainTypeAndName(String domain, String type, String name) {
        return new ObjectNameWithDomainTypeAndNamePrototype(domain, type, name);
    }

    public ObjectNameBuilder copy();

    public static class ObjectNameWithDomainTypeAndNamePrototype
    extends ObjectNameWithDomainAndTypePrototype {
        private String name;

        public ObjectNameWithDomainTypeAndNamePrototype(String domain, String type, String name) {
            super(domain, type);
            this.name = name;
        }

        @Override
        public ObjectNameBuilder copy() {
            return super.copy().name(this.name);
        }
    }

    public static class ObjectNameWithDomainAndTypePrototype
    implements ObjectNamePrototype {
        private String domain;
        private String type;

        public ObjectNameWithDomainAndTypePrototype(String domain, String type) {
            this.domain = domain;
            this.type = type;
        }

        @Override
        public ObjectNameBuilder copy() {
            return ObjectNameBuilder.create(this.domain).type(this.type);
        }
    }
}

