/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.appformer.maven.integration.AbstractFilesArtifactResolver;
import org.appformer.maven.support.AFReleaseId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplodedJarArtifactResolver
extends AbstractFilesArtifactResolver {
    private static final String EXPLODED_JAR_FOLDER = System.getProperty("org.kie.maven.resolver.folder", "/workspace");
    private static final Logger log = LoggerFactory.getLogger(ExplodedJarArtifactResolver.class);

    ExplodedJarArtifactResolver(ClassLoader classLoader, AFReleaseId releaseId) {
        super(classLoader, releaseId);
    }

    @Override
    protected List<URL> buildResources(Predicate<String> predicate) {
        ArrayList<URL> arrayList;
        block12: {
            Path base = Paths.get(EXPLODED_JAR_FOLDER, new String[0]);
            if (!Files.isDirectory(base, new LinkOption[0])) {
                log.error("Exploded jar autoscan folder failed. {} does not exist or it is not a folder", (Object)base);
                return Collections.emptyList();
            }
            Stream<Path> files = Files.walk(base, new FileVisitOption[0]);
            try {
                List candidates = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Path candidate : candidates) {
                    if (!predicate.test(candidate.toString())) continue;
                    try {
                        urls.add(candidate.toUri().toURL());
                        log.debug("Found resource in exploded jar {}", (Object)candidate);
                    }
                    catch (MalformedURLException e) {
                        log.warn("Failed to convert candidate to proper URL resource {}", (Object)candidate, (Object)e);
                    }
                }
                arrayList = urls;
                if (files == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Error trying to scan for resources in exploded jar {}", (Object)EXPLODED_JAR_FOLDER, (Object)e);
                    return Collections.emptyList();
                }
            }
            files.close();
        }
        return arrayList;
    }

    @Override
    protected URL getURL(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

