/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.workitem;

import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.workitem.CustomTask;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistry;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.builder.Builder;
import org.kie.workbench.common.stunner.core.factory.definition.DefinitionFactory;

@ApplicationScoped
public class CustomTaskFactory
implements DefinitionFactory<CustomTask> {
    private static final String PREFIX = BindableAdapterUtils.getGenericClassName(CustomTask.class);
    private final Supplier<WorkItemDefinitionRegistry> registry;

    protected CustomTaskFactory() {
        this.registry = null;
    }

    @Inject
    public CustomTaskFactory(Instance<WorkItemDefinitionRegistry> registry) {
        this.registry = () -> registry.get();
    }

    public CustomTaskFactory(Supplier<WorkItemDefinitionRegistry> registry) {
        this.registry = registry;
    }

    public boolean accepts(String identifier) {
        return identifier.startsWith(PREFIX);
    }

    public CustomTask build(String identifier) {
        String name = BindableAdapterUtils.getDynamicId(CustomTask.class, (String)identifier);
        return null != name ? this.buildItem(name) : CustomTaskBuilder.newInstance();
    }

    public CustomTask buildItem(String workItemName) {
        WorkItemDefinition workItemDefinition = this.getRegistry().get(workItemName);
        return new CustomTaskBuilder(workItemDefinition).build();
    }

    private WorkItemDefinitionRegistry getRegistry() {
        return this.registry.get();
    }

    public static class CustomTaskBuilder
    implements Builder<CustomTask> {
        private final WorkItemDefinition workItemDefinition;

        public CustomTaskBuilder(WorkItemDefinition workItemDefinition) {
            this.workItemDefinition = workItemDefinition;
        }

        public static CustomTask newInstance() {
            return new CustomTask();
        }

        public CustomTask build() {
            CustomTask customTask = CustomTaskBuilder.newInstance();
            if (null != this.workItemDefinition) {
                String name = this.workItemDefinition.getName();
                CustomTaskBuilder.setProperties(this.workItemDefinition, customTask);
                customTask.getExecutionSet().getTaskName().setValue(name);
                customTask.getGeneral().getName().setValue(this.workItemDefinition.getDisplayName());
                customTask.getGeneral().getDocumentation().setValue(this.workItemDefinition.getDocumentation());
                customTask.setDescription(this.workItemDefinition.getDescription());
                customTask.getDataIOSet().getAssignmentsinfo().setValue(this.workItemDefinition.getParameters() + this.workItemDefinition.getResults());
            }
            return customTask;
        }

        public static CustomTask setProperties(WorkItemDefinition workItemDefinition, CustomTask customTask) {
            String name = workItemDefinition.getName();
            customTask.setName(name);
            customTask.getTaskType().setRawType(name);
            customTask.setCategory(workItemDefinition.getCategory());
            customTask.setDefaultHandler(workItemDefinition.getDefaultHandler());
            return customTask;
        }
    }
}

