/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser;

import java.text.MessageFormat;
import org.kie.workbench.common.services.datamodeller.util.StringEscapeUtils;
import org.kie.workbench.common.stunner.bpmn.forms.conditions.Condition;
import org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser.FunctionsRegistry;
import org.kie.workbench.common.stunner.bpmn.project.backend.forms.conditions.parser.GenerateConditionException;

public class ConditionGenerator {
    private static final String PARAMETER_NULL_EMPTY = "Parameter can not be null nor empty";
    private static final String MISSING_CONDITION_ERROR = "A condition must be provided";
    private static final String FUNCTION_NOT_FOUND_ERROR = "Function {0} was not found in current functions definitions";

    public String generateScript(Condition condition) throws GenerateConditionException {
        if (condition == null) {
            throw new GenerateConditionException(MISSING_CONDITION_ERROR);
        }
        if (!this.isValidFunction(condition.getFunction())) {
            throw new GenerateConditionException(MessageFormat.format(FUNCTION_NOT_FOUND_ERROR, condition.getFunction()));
        }
        String function = condition.getFunction().trim();
        StringBuilder script = new StringBuilder();
        script.append("return ");
        script.append("KieFunctions.");
        script.append(function);
        script.append("(");
        boolean first = true;
        for (String param : condition.getParams()) {
            if (param == null || param.isEmpty()) {
                throw new GenerateConditionException(PARAMETER_NULL_EMPTY);
            }
            if (first) {
                script.append(param);
                first = false;
                continue;
            }
            script.append(", ");
            script.append("\"");
            script.append(StringEscapeUtils.escapeJavaNonUTFChars((String)param));
            script.append("\"");
        }
        script.append(");");
        return script.toString();
    }

    private boolean isValidFunction(String function) {
        return !FunctionsRegistry.getInstance().getFunctions(function).isEmpty();
    }
}

