/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Preview;
import org.kohsuke.github.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Preview
@Deprecated
public class GHCommitSearchBuilder
extends GHSearchBuilder<GHCommit> {
    GHCommitSearchBuilder(GitHub root) {
        super(root, CommitSearchResult.class);
        this.req.withPreview("application/vnd.github.cloak-preview");
    }

    public GHCommitSearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    public GHCommitSearchBuilder author(String v) {
        return this.q("author:" + v);
    }

    public GHCommitSearchBuilder committer(String v) {
        return this.q("committer:" + v);
    }

    public GHCommitSearchBuilder authorName(String v) {
        return this.q("author-name:" + v);
    }

    public GHCommitSearchBuilder committerName(String v) {
        return this.q("committer-name:" + v);
    }

    public GHCommitSearchBuilder authorEmail(String v) {
        return this.q("author-email:" + v);
    }

    public GHCommitSearchBuilder committerEmail(String v) {
        return this.q("committer-email:" + v);
    }

    public GHCommitSearchBuilder authorDate(String v) {
        return this.q("author-date:" + v);
    }

    public GHCommitSearchBuilder committerDate(String v) {
        return this.q("committer-date:" + v);
    }

    public GHCommitSearchBuilder merge(boolean merge) {
        return this.q("merge:" + Boolean.valueOf(merge).toString().toLowerCase());
    }

    public GHCommitSearchBuilder hash(String v) {
        return this.q("hash:" + v);
    }

    public GHCommitSearchBuilder parent(String v) {
        return this.q("parent:" + v);
    }

    public GHCommitSearchBuilder tree(String v) {
        return this.q("tree:" + v);
    }

    public GHCommitSearchBuilder is(String v) {
        return this.q("is:" + v);
    }

    public GHCommitSearchBuilder user(String v) {
        return this.q("user:" + v);
    }

    public GHCommitSearchBuilder org(String v) {
        return this.q("org:" + v);
    }

    public GHCommitSearchBuilder repo(String v) {
        return this.q("repo:" + v);
    }

    public GHCommitSearchBuilder order(GHDirection v) {
        this.req.with("order", v);
        return this;
    }

    public GHCommitSearchBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    private static String getRepoName(String commitUrl) {
        if (StringUtils.isBlank((CharSequence)commitUrl)) {
            return null;
        }
        int indexOfUsername = "https://api.github.com/repos/".length();
        String[] tokens = commitUrl.substring(indexOfUsername).split("/", 3);
        return tokens[0] + '/' + tokens[1];
    }

    @Override
    protected String getApiUrl() {
        return "/search/commits";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommitSearchResult
    extends SearchResult<GHCommit> {
        private GHCommit[] items;

        private CommitSearchResult() {
        }

        GHCommit[] getItems(GitHub root) {
            for (GHCommit commit : this.items) {
                String repoName = GHCommitSearchBuilder.getRepoName(commit.url);
                try {
                    GHRepository repo = root.getRepository(repoName);
                    commit.wrapUp(repo);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.items;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        AUTHOR_DATE,
        COMMITTER_DATE;

    }
}

