/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHCreateRepositoryBuilder {
    private final GitHub root;
    protected final Requester builder;
    private final String apiUrlTail;

    GHCreateRepositoryBuilder(GitHub root, String apiUrlTail, String name) {
        this.root = root;
        this.apiUrlTail = apiUrlTail;
        this.builder = new Requester(root);
        this.builder.with("name", name);
    }

    public GHCreateRepositoryBuilder description(String description) {
        this.builder.with("description", description);
        return this;
    }

    public GHCreateRepositoryBuilder homepage(URL homepage) {
        return this.homepage(homepage.toExternalForm());
    }

    public GHCreateRepositoryBuilder homepage(String homepage) {
        this.builder.with("homepage", homepage);
        return this;
    }

    public GHCreateRepositoryBuilder private_(boolean b) {
        this.builder.with("private", b);
        return this;
    }

    public GHCreateRepositoryBuilder issues(boolean b) {
        this.builder.with("has_issues", b);
        return this;
    }

    public GHCreateRepositoryBuilder wiki(boolean b) {
        this.builder.with("has_wiki", b);
        return this;
    }

    public GHCreateRepositoryBuilder downloads(boolean b) {
        this.builder.with("has_downloads", b);
        return this;
    }

    public GHCreateRepositoryBuilder autoInit(boolean b) {
        this.builder.with("auto_init", b);
        return this;
    }

    public GHCreateRepositoryBuilder allowSquashMerge(boolean b) {
        this.builder.with("allow_squash_merge", b);
        return this;
    }

    public GHCreateRepositoryBuilder allowMergeCommit(boolean b) {
        this.builder.with("allow_merge_commit", b);
        return this;
    }

    public GHCreateRepositoryBuilder allowRebaseMerge(boolean b) {
        this.builder.with("allow_rebase_merge", b);
        return this;
    }

    public GHCreateRepositoryBuilder gitignoreTemplate(String language) {
        this.builder.with("gitignore_template", language);
        return this;
    }

    public GHCreateRepositoryBuilder licenseTemplate(String license) {
        this.builder.with("license_template", license);
        return this;
    }

    public GHCreateRepositoryBuilder team(GHTeam team) {
        if (team != null) {
            this.builder.with("team_id", team.getId());
        }
        return this;
    }

    public GHRepository create() throws IOException {
        return ((GHRepository)((Object)this.builder.method("POST").to(this.apiUrlTail, GHRepository.class))).wrap(this.root);
    }
}

