/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import ndr.NetworkDataRepresentation;

final class JISecurityBinding
implements Serializable {
    private static final long serialVersionUID = 2100264431889577123L;
    public static final int COM_C_AUTHZ_NONE = 65535;
    private int authnSvc = 0;
    private int authzSvc = 0;
    private String princName = null;
    private int length = -1;

    private JISecurityBinding() {
    }

    public int getLength() {
        return this.length;
    }

    JISecurityBinding(int authnSvc, int authzSvc, String princName) {
        this.authnSvc = authnSvc;
        this.authzSvc = authzSvc;
        this.princName = princName;
        this.length = princName.equals("") ? 6 : 4 + princName.length() * 2 + 2;
    }

    static JISecurityBinding decode(NetworkDataRepresentation ndr) {
        JISecurityBinding securityBinding = new JISecurityBinding();
        securityBinding.authnSvc = ndr.readUnsignedShort();
        if (securityBinding.authnSvc == 0) {
            return null;
        }
        securityBinding.authzSvc = ndr.readUnsignedShort();
        int retVal = -1;
        StringBuffer buffer = new StringBuffer();
        while ((retVal = ndr.readUnsignedShort()) != 0) {
            buffer.append(new String(new byte[]{(byte)retVal}));
        }
        securityBinding.princName = buffer.toString();
        securityBinding.length = 4 + securityBinding.princName.length() * 2 + 2;
        return securityBinding;
    }

    public void encode(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedShort(this.authnSvc);
        ndr.writeUnsignedShort(this.authzSvc);
        int i = 0;
        while (i < this.princName.length()) {
            ndr.writeUnsignedShort((int)this.princName.charAt(i));
            ++i;
        }
        ndr.writeUnsignedShort(0);
    }
}

