/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.Relation;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtil;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class UniqueConstraintSnapshotGenerator
extends HibernateSnapshotGenerator {
    public UniqueConstraintSnapshotGenerator() {
        super(UniqueConstraint.class, new Class[]{liquibase.structure.core.Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(UniqueConstraint.class)) {
            return;
        }
        if (foundObject instanceof liquibase.structure.core.Table) {
            Index index;
            liquibase.structure.core.Table table = (liquibase.structure.core.Table)foundObject;
            Table hibernateTable = this.findHibernateTable((DatabaseObject)table, snapshot);
            if (hibernateTable == null) {
                return;
            }
            Iterator uniqueIterator = hibernateTable.getUniqueKeyIterator();
            while (uniqueIterator.hasNext()) {
                UniqueKey hibernateUnique = (UniqueKey)uniqueIterator.next();
                UniqueConstraint uniqueConstraint = new UniqueConstraint();
                uniqueConstraint.setName(hibernateUnique.getName());
                uniqueConstraint.setRelation((Relation)table);
                uniqueConstraint.setClustered(false);
                Iterator columnIterator = hibernateUnique.getColumnIterator();
                int i = 0;
                while (columnIterator.hasNext()) {
                    Column hibernateColumn = (Column)columnIterator.next();
                    uniqueConstraint.addColumn(i, new liquibase.structure.core.Column(hibernateColumn.getName()).setRelation((Relation)table));
                    ++i;
                }
                index = this.getBackingIndex(uniqueConstraint, hibernateTable, snapshot);
                uniqueConstraint.setBackingIndex(index);
                Scope.getCurrentScope().getLog(this.getClass()).info("Found unique constraint " + uniqueConstraint.toString());
                table.getUniqueConstraints().add(uniqueConstraint);
            }
            Iterator columnIterator = hibernateTable.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                if (!column.isUnique()) continue;
                UniqueConstraint uniqueConstraint = new UniqueConstraint();
                uniqueConstraint.setRelation((Relation)table);
                uniqueConstraint.setClustered(false);
                String name = "UC_" + table.getName().toUpperCase() + column.getName().toUpperCase() + "_COL";
                if (name.length() > 64) {
                    name = name.substring(0, 63);
                }
                uniqueConstraint.addColumn(0, new liquibase.structure.core.Column(column.getName()).setRelation((Relation)table));
                uniqueConstraint.setName(name);
                Scope.getCurrentScope().getLog(this.getClass()).info("Found unique constraint " + uniqueConstraint.toString());
                table.getUniqueConstraints().add(uniqueConstraint);
                index = this.getBackingIndex(uniqueConstraint, hibernateTable, snapshot);
                uniqueConstraint.setBackingIndex(index);
            }
            for (UniqueConstraint uc : table.getUniqueConstraints()) {
                if (uc.getName() != null && !uc.getName().isEmpty()) continue;
                String name = table.getName() + uc.getColumnNames();
                name = "UCIDX" + this.hashedName(name);
                uc.setName(name);
            }
        }
    }

    private String hashedName(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(s.getBytes());
            byte[] digest = md.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            return bigInt.toString(35);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HibernateException("Unable to generate a hashed name!", (Throwable)e);
        }
    }

    protected Index getBackingIndex(UniqueConstraint uniqueConstraint, Table hibernateTable, DatabaseSnapshot snapshot) {
        Index index = new Index();
        index.setRelation(uniqueConstraint.getRelation());
        index.setColumns(uniqueConstraint.getColumns());
        index.setUnique(Boolean.valueOf(true));
        if (StringUtil.isNotEmpty((String)uniqueConstraint.getName())) {
            index.setName(uniqueConstraint.getName() + "_IX");
        } else {
            index.setName(String.format("%s_%s_IX", hibernateTable.getName(), StringUtil.randomIdentifer((int)4)));
        }
        return index;
    }
}

