/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.math.BigInteger;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import org.hibernate.boot.model.relational.Namespace;

public class SequenceSnapshotGenerator
extends HibernateSnapshotGenerator {
    public SequenceSnapshotGenerator() {
        super(Sequence.class, new Class[]{Schema.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Sequence.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
            for (Namespace namespace : database.getMetadata().getDatabase().getNamespaces()) {
                for (org.hibernate.boot.model.relational.Sequence sequence : namespace.getSequences()) {
                    schema.addDatabaseObject((DatabaseObject)new Sequence().setName(sequence.getName().getSequenceName().getText()).setSchema(schema).setStartValue(BigInteger.valueOf(sequence.getInitialValue())).setIncrementBy(BigInteger.valueOf(sequence.getIncrementSize())));
                }
            }
        }
    }
}

