/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.ext.hibernate.snapshot.extension.ExtendedSnapshotGenerator;
import liquibase.ext.hibernate.snapshot.extension.TableGeneratorSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;

public class TableSnapshotGenerator
extends HibernateSnapshotGenerator {
    private List<ExtendedSnapshotGenerator<Generator, liquibase.structure.core.Table>> tableIdGenerators = new ArrayList<ExtendedSnapshotGenerator<Generator, liquibase.structure.core.Table>>();

    public TableSnapshotGenerator() {
        super(liquibase.structure.core.Table.class, new Class[]{Schema.class});
        this.tableIdGenerators.add(new TableGeneratorSnapshotGenerator());
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (example.getSnapshotId() != null) {
            return example;
        }
        Table hibernateTable = this.findHibernateTable(example, snapshot);
        if (hibernateTable == null) {
            return example;
        }
        liquibase.structure.core.Table table = new liquibase.structure.core.Table().setName(hibernateTable.getName());
        Scope.getCurrentScope().getLog(this.getClass()).info("Found table " + table.getName());
        table.setSchema(example.getSchema());
        if (hibernateTable.getComment() != null && !hibernateTable.getComment().isEmpty()) {
            table.setRemarks(hibernateTable.getComment());
        }
        return table;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(liquibase.structure.core.Table.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
            MetadataImplementor metadata = (MetadataImplementor)database.getMetadata();
            Collection entityBindings = metadata.getEntityBindings();
            for (PersistentClass pc : entityBindings) {
                Table hibernateTable = pc.getTable();
                if (!hibernateTable.isPhysicalTable()) continue;
                this.addDatabaseObjectToSchema(hibernateTable, schema, snapshot);
                List joins = pc.getJoins();
                for (Object join : joins) {
                    this.addDatabaseObjectToSchema(join.getTable(), schema, snapshot);
                }
            }
            block2: for (PersistentClass persistentClass : entityBindings) {
                if (persistentClass.isInherited() || !(persistentClass.getIdentifier() instanceof SimpleValue)) continue;
                SimpleValue simpleValue = (SimpleValue)persistentClass.getIdentifier();
                Generator ig = simpleValue.createGenerator(metadata.getMetadataBuildingOptions().getIdentifierGeneratorFactory(), database.getDialect(), (RootClass)persistentClass);
                for (ExtendedSnapshotGenerator extendedSnapshotGenerator : this.tableIdGenerators) {
                    if (!extendedSnapshotGenerator.supports(ig)) continue;
                    liquibase.structure.core.Table idTable = (liquibase.structure.core.Table)extendedSnapshotGenerator.snapshot(ig);
                    idTable.setSchema(schema);
                    schema.addDatabaseObject(this.snapshotObject((DatabaseObject)idTable, snapshot));
                    continue block2;
                }
            }
            Collection collectionBindings = metadata.getCollectionBindings();
            for (org.hibernate.mapping.Collection coll : collectionBindings) {
                Table hTable = coll.getCollectionTable();
                if (!hTable.isPhysicalTable()) continue;
                this.addDatabaseObjectToSchema(hTable, schema, snapshot);
            }
        }
    }

    private void addDatabaseObjectToSchema(Table join, Schema schema, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        liquibase.structure.core.Table joinTable = new liquibase.structure.core.Table().setName(join.getName());
        joinTable.setSchema(schema);
        Scope.getCurrentScope().getLog(this.getClass()).info("Found table " + joinTable.getName());
        schema.addDatabaseObject(this.snapshotObject((DatabaseObject)joinTable, snapshot));
    }
}

