/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym.change;

import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymStatement;
import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropSynonym", description="Drops a synonym", priority=101, appliesTo={"synonym"})
public class DropSynonymChange
extends LicenseValidationChange {
    private Boolean isPrivate;
    private String synonymCatalogName;
    private String synonymSchemaName;
    private String synonymName;
    private String objectType;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    public Boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(Boolean bl2) {
        this.isPrivate = bl2;
    }

    public String getSynonymCatalogName() {
        return this.synonymCatalogName;
    }

    public void setSynonymCatalogName(String string) {
        this.synonymCatalogName = string;
    }

    public String getSynonymSchemaName() {
        return this.synonymSchemaName;
    }

    public void setSynonymSchemaName(String string) {
        this.synonymSchemaName = string;
    }

    public String getSynonymName() {
        return this.synonymName;
    }

    public void setSynonymName(String string) {
        this.synonymName = string;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public String getConfirmationMessage() {
        return "Synonym " + this.getSynonymName() + " dropped";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropSynonymStatement(this.getSynonymCatalogName(), this.getSynonymSchemaName(), this.getSynonymName()).setPrivate(this.isPrivate()).setObjectType(this.getObjectType())};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

