/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColDataType;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class ColumnDefinition
implements Serializable {
    private String columnName;
    private ColDataType colDataType;
    private List<String> columnSpecs;

    public ColumnDefinition() {
    }

    public ColumnDefinition(String string, ColDataType colDataType) {
        this.columnName = string;
        this.colDataType = colDataType;
    }

    public ColumnDefinition(String string, ColDataType colDataType, List<String> list) {
        this(string, colDataType);
        this.columnSpecs = list;
    }

    public List<String> getColumnSpecs() {
        return this.columnSpecs;
    }

    public void setColumnSpecs(List<String> list) {
        this.columnSpecs = list;
    }

    public ColDataType getColDataType() {
        return this.colDataType;
    }

    public void setColDataType(ColDataType colDataType) {
        this.colDataType = colDataType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String toString() {
        return this.columnName + " " + this.toStringDataTypeAndSpec();
    }

    public String toStringDataTypeAndSpec() {
        return this.colDataType + (this.columnSpecs != null && !this.columnSpecs.isEmpty() ? " " + PlainSelect.getStringList(this.columnSpecs, false, false) : "");
    }

    public ColumnDefinition withColumnName(String string) {
        this.setColumnName(string);
        return this;
    }

    public ColumnDefinition withColDataType(ColDataType colDataType) {
        this.setColDataType(colDataType);
        return this;
    }

    public ColumnDefinition withColumnSpecs(List<String> list) {
        this.setColumnSpecs(list);
        return this;
    }

    public ColumnDefinition addColumnSpecs(String ... stringArray) {
        List list = Optional.ofNullable(this.getColumnSpecs()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withColumnSpecs(list);
    }

    public ColumnDefinition addColumnSpecs(Collection<String> collection) {
        List list = Optional.ofNullable(this.getColumnSpecs()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumnSpecs(list);
    }

    public void accept(ExpressionVisitorAdapter expressionVisitorAdapter) {
        expressionVisitorAdapter.visit(this);
    }
}

