/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import liquibase.pro.packaged.oN;
import liquibase.pro.packaged.oP$1;
import liquibase.pro.packaged.oQ;
import liquibase.pro.packaged.oR;
import liquibase.pro.packaged.oS;
import liquibase.pro.packaged.oU;
import liquibase.pro.packaged.oW;
import liquibase.pro.packaged.oX;
import liquibase.pro.packaged.oY;
import liquibase.pro.packaged.oZ;
import liquibase.pro.packaged.pa;
import liquibase.pro.packaged.pc;
import liquibase.pro.packaged.pd;

public final class oP<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = Math.min(4, oP.ceilingNextPowerOfTwo(NCPU));
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 4;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 8;
    static final int READ_BUFFER_SIZE = 16;
    static final int READ_BUFFER_INDEX_MASK = 15;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    final ConcurrentMap<K, oX<K, V>> data;
    final int concurrencyLevel;
    final long[] readBufferReadCount;
    final oN<oX<K, V>> evictionDeque;
    final AtomicLong weightedSize;
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLongArray readBufferWriteCount;
    final AtomicLongArray readBufferDrainAtWriteCount;
    final AtomicReferenceArray<oX<K, V>> readBuffers;
    final AtomicReference<oS> drainStatus;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private static int readBufferIndex(int n2, int n3) {
        return (n2 << 4) + n3;
    }

    private oP(oR<K, V> oR2) {
        this.concurrencyLevel = oR2.concurrencyLevel;
        this.capacity = new AtomicLong(Math.min(oR2.capacity, 9223372034707292160L));
        this.data = new ConcurrentHashMap<K, oX<K, V>>(oR2.initialCapacity, 0.75f, this.concurrencyLevel);
        this.evictionLock = new ReentrantLock();
        this.weightedSize = new AtomicLong();
        this.evictionDeque = new oN();
        this.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        this.drainStatus = new AtomicReference<oS>(oS.IDLE);
        this.readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
        this.readBufferWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBufferDrainAtWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBuffers = new AtomicReferenceArray(NUMBER_OF_READ_BUFFERS << 4);
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public final long capacity() {
        return this.capacity.get();
    }

    public final void setCapacity(long l2) {
        oP.checkArgument(l2 >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            this.drainBuffers();
            this.evict();
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    final boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    final void evict() {
        while (this.hasOverflowed()) {
            oX oX2 = (oX)this.evictionDeque.poll();
            if (oX2 == null) {
                return;
            }
            this.data.remove(oX2.key, oX2);
            this.makeDead(oX2);
        }
    }

    final void afterRead(oX<K, V> oX2) {
        int n2 = oP.readBufferIndex();
        long l2 = this.recordRead(n2, oX2);
        this.drainOnReadIfNeeded(n2, l2);
    }

    static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    final long recordRead(int n2, oX<K, V> oX2) {
        long l2 = this.readBufferWriteCount.get(n2);
        this.readBufferWriteCount.lazySet(n2, l2 + 1L);
        int n3 = (int)(l2 & 0xFL);
        this.readBuffers.lazySet(oP.readBufferIndex(n2, n3), oX2);
        return l2;
    }

    final void drainOnReadIfNeeded(int n2, long l2) {
        int n3 = n2 = l2 - this.readBufferDrainAtWriteCount.get(n2) < 4L ? 1 : 0;
        if (this.drainStatus.get().shouldDrainBuffers(n2 != 0)) {
            this.tryToDrainBuffers();
        }
    }

    final void afterWrite(Runnable runnable) {
        this.writeBuffer.add(runnable);
        this.drainStatus.lazySet(oS.REQUIRED);
        this.tryToDrainBuffers();
    }

    final void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(oS.PROCESSING);
                this.drainBuffers();
                return;
            }
            finally {
                this.drainStatus.compareAndSet(oS.PROCESSING, oS.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    final void drainBuffers() {
        this.drainReadBuffers();
        this.drainWriteBuffer();
    }

    final void drainReadBuffers() {
        int n2;
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        for (n2 = (int)Thread.currentThread().getId(); n2 < n3; ++n2) {
            this.drainReadBuffer(n2 & READ_BUFFERS_MASK);
        }
    }

    final void drainReadBuffer(int n2) {
        long l2 = this.readBufferWriteCount.get(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = (int)(this.readBufferReadCount[n2] & 0xFL);
            oX<K, V> oX2 = this.readBuffers.get(n3 = oP.readBufferIndex(n2, n3));
            if (oX2 == null) break;
            this.readBuffers.lazySet(n3, null);
            this.applyRead(oX2);
            int n4 = n2;
            this.readBufferReadCount[n4] = this.readBufferReadCount[n4] + 1L;
        }
        this.readBufferDrainAtWriteCount.lazySet(n2, l2);
    }

    final void applyRead(oX<K, V> oX2) {
        if (this.evictionDeque.contains(oX2)) {
            this.evictionDeque.moveToBack(oX2);
        }
    }

    final void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    final boolean tryToRetire(oX<K, V> oX2, pd<V> pd2) {
        if (pd2.isAlive()) {
            pd pd3 = new pd(pd2.value, -pd2.weight);
            return oX2.compareAndSet(pd2, pd3);
        }
        return false;
    }

    final void makeRetired(oX<K, V> oX2) {
        pd pd2;
        pd pd3;
        do {
            if ((pd3 = (pd)oX2.get()).isAlive()) continue;
            return;
        } while (!oX2.compareAndSet(pd3, pd2 = new pd(pd3.value, -pd3.weight)));
    }

    final void makeDead(oX<K, V> oX2) {
        pd pd2;
        pd pd3;
        while (!oX2.compareAndSet(pd3 = (pd)oX2.get(), pd2 = new pd(pd3.value, 0))) {
        }
        this.weightedSize.lazySet(this.weightedSize.get() - (long)Math.abs(pd3.weight));
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final void clear() {
        this.evictionLock.lock();
        try {
            Runnable runnable;
            oX oX2;
            while ((oX2 = (oX)this.evictionDeque.poll()) != null) {
                this.data.remove(oX2.key, oX2);
                this.makeDead(oX2);
            }
            for (int i2 = 0; i2 < this.readBuffers.length(); ++i2) {
                this.readBuffers.lazySet(i2, null);
            }
            while ((runnable = this.writeBuffer.poll()) != null) {
                runnable.run();
            }
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        oP.checkNotNull(object);
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            if (!((oX)iterator.next()).getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object object) {
        if ((object = (oX)this.data.get(object)) == null) {
            return null;
        }
        this.afterRead((oX<K, V>)object);
        return ((oX)object).getValue();
    }

    @Override
    public final V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public final V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    final V put(K object, V object2, boolean bl2) {
        pd pd2;
        oX<K, pd> oX2;
        oP.checkNotNull(object);
        oP.checkNotNull(object2);
        object2 = new pd<V>(object2, 1);
        object = new oX(object, object2);
        block0: while (true) {
            if ((oX2 = this.data.putIfAbsent(((oX)object).key, object)) == null) {
                this.afterWrite(new oQ(this, (oX)object, 1));
                return null;
            }
            if (bl2) {
                this.afterRead(oX2);
                return oX2.getValue();
            }
            do {
                if (!(pd2 = (pd)oX2.get()).isAlive()) continue block0;
            } while (!oX2.compareAndSet(pd2, (pd)object2));
            break;
        }
        int n2 = 1 - pd2.weight;
        if (n2 == 0) {
            this.afterRead(oX2);
        } else {
            this.afterWrite(new pa(this, oX2, n2));
        }
        return pd2.value;
    }

    @Override
    public final V remove(Object object) {
        if ((object = (oX)this.data.remove(object)) == null) {
            return null;
        }
        this.makeRetired((oX<K, V>)object);
        this.afterWrite(new oY(this, (oX)object));
        return ((oX)object).getValue();
    }

    @Override
    public final boolean remove(Object object, Object object2) {
        oX oX2 = (oX)this.data.get(object);
        if (oX2 == null || object2 == null) {
            return false;
        }
        pd pd2 = (pd)oX2.get();
        while (pd2.contains(object2)) {
            if (this.tryToRetire(oX2, pd2)) {
                if (!this.data.remove(object, oX2)) break;
                this.afterWrite(new oY(this, oX2));
                return true;
            }
            pd2 = (pd)oX2.get();
            if (pd2.isAlive()) continue;
        }
        return false;
    }

    @Override
    public final V replace(K object, V object2) {
        pd pd2;
        oP.checkNotNull(object);
        oP.checkNotNull(object2);
        object2 = new pd<V>(object2, 1);
        object = (oX)this.data.get(object);
        if (object == null) {
            return null;
        }
        do {
            if ((pd2 = (pd)((AtomicReference)object).get()).isAlive()) continue;
            return null;
        } while (!((AtomicReference)object).compareAndSet(pd2, object2));
        int n2 = 1 - pd2.weight;
        if (n2 == 0) {
            this.afterRead((oX<K, V>)object);
        } else {
            this.afterWrite(new pa(this, (oX)object, n2));
        }
        return pd2.value;
    }

    @Override
    public final boolean replace(K object, V v2, V object2) {
        pd pd2;
        oP.checkNotNull(object);
        oP.checkNotNull(v2);
        oP.checkNotNull(object2);
        object2 = new pd<V>(object2, 1);
        object = (oX)this.data.get(object);
        if (object == null) {
            return false;
        }
        do {
            if ((pd2 = (pd)((AtomicReference)object).get()).isAlive() && pd2.contains(v2)) continue;
            return false;
        } while (!((AtomicReference)object).compareAndSet(pd2, object2));
        int n2 = 1 - pd2.weight;
        if (n2 == 0) {
            this.afterRead((oX<K, V>)object);
        } else {
            this.afterWrite(new pa(this, (oX)object, n2));
        }
        return true;
    }

    @Override
    public final Set<K> keySet() {
        Set<K> set = this.keySet;
        if (set == null) {
            this.keySet = new oW(this);
            return this.keySet;
        }
        return set;
    }

    @Override
    public final Collection<V> values() {
        Collection<V> collection = this.values;
        if (collection == null) {
            this.values = new pc(this);
            return this.values;
        }
        return collection;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            this.entrySet = new oU(this);
            return this.entrySet;
        }
        return set;
    }

    final Object writeReplace() {
        return new oZ(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Proxy required");
    }

    /* synthetic */ oP(oR oR2, oP$1 oP$1) {
        this(oR2);
    }
}

