/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ExpressionListItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FunctionItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectExpressionItem;

public class Pivot
implements Serializable {
    private List<FunctionItem> functionItems;
    private List<Column> forColumns;
    private List<SelectExpressionItem> singleInItems;
    private List<ExpressionListItem> multiInItems;
    private Alias alias;

    public void accept(PivotVisitor pivotVisitor) {
        pivotVisitor.visit(this);
    }

    public List<SelectExpressionItem> getSingleInItems() {
        return this.singleInItems;
    }

    public void setSingleInItems(List<SelectExpressionItem> list) {
        this.singleInItems = list;
    }

    public List<ExpressionListItem> getMultiInItems() {
        return this.multiInItems;
    }

    public void setMultiInItems(List<ExpressionListItem> list) {
        this.multiInItems = list;
    }

    public List<FunctionItem> getFunctionItems() {
        return this.functionItems;
    }

    public void setFunctionItems(List<FunctionItem> list) {
        this.functionItems = list;
    }

    public List<Column> getForColumns() {
        return this.forColumns;
    }

    public void setForColumns(List<Column> list) {
        this.forColumns = list;
    }

    public List<?> getInItems() {
        if (this.singleInItems == null) {
            return this.multiInItems;
        }
        return this.singleInItems;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public String toString() {
        return "PIVOT (" + PlainSelect.getStringList(this.functionItems) + " FOR " + PlainSelect.getStringList(this.forColumns, true, this.forColumns != null && this.forColumns.size() > 1) + " IN " + PlainSelect.getStringList(this.getInItems(), true, true) + ")" + (this.alias != null ? this.alias.toString() : "");
    }

    public Pivot withFunctionItems(List<FunctionItem> list) {
        this.setFunctionItems(list);
        return this;
    }

    public Pivot withForColumns(List<Column> list) {
        this.setForColumns(list);
        return this;
    }

    public Pivot withSingleInItems(List<SelectExpressionItem> list) {
        this.setSingleInItems(list);
        return this;
    }

    public Pivot withMultiInItems(List<ExpressionListItem> list) {
        this.setMultiInItems(list);
        return this;
    }

    public Pivot withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    public Pivot addFunctionItems(FunctionItem ... functionItemArray) {
        List list = Optional.ofNullable(this.getFunctionItems()).orElseGet(ArrayList::new);
        Collections.addAll(list, functionItemArray);
        return this.withFunctionItems(list);
    }

    public Pivot addFunctionItems(Collection<? extends FunctionItem> collection) {
        List list = Optional.ofNullable(this.getFunctionItems()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withFunctionItems(list);
    }

    public Pivot addForColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getForColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withForColumns(list);
    }

    public Pivot addForColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getForColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withForColumns(list);
    }

    public Pivot addSingleInItems(SelectExpressionItem ... selectExpressionItemArray) {
        List list = Optional.ofNullable(this.getSingleInItems()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectExpressionItemArray);
        return this.withSingleInItems(list);
    }

    public Pivot addSingleInItems(Collection<? extends SelectExpressionItem> collection) {
        List list = Optional.ofNullable(this.getSingleInItems()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSingleInItems(list);
    }

    public Pivot addMultiInItems(ExpressionListItem ... expressionListItemArray) {
        List list = Optional.ofNullable(this.getMultiInItems()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionListItemArray);
        return this.withMultiInItems(list);
    }

    public Pivot addMultiInItems(Collection<? extends ExpressionListItem> collection) {
        List list = Optional.ofNullable(this.getMultiInItems()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withMultiInItems(list);
    }
}

