/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowDefinition;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccess;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllTableColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Fetch;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.First;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralSubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Offset;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OptimizeFor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Pivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotXml;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Skip;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubJoin;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.TableFunction;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Top;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnPivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ValuesList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.values.ValuesStatement;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionListDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.GroupByDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.LimitDeparser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.OrderByDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ValuesStatementDeParser;

public class SelectDeParser
extends AbstractDeParser<PlainSelect>
implements ItemsListVisitor,
FromItemVisitor,
PivotVisitor,
SelectItemVisitor,
SelectVisitor {
    private ExpressionVisitor expressionVisitor;

    public SelectDeParser() {
        this(new StringBuilder());
    }

    public SelectDeParser(StringBuilder stringBuilder) {
        this(new ExpressionVisitorAdapter(), stringBuilder);
    }

    public SelectDeParser(ExpressionVisitor expressionVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        Top top;
        First first;
        Skip skip;
        OracleHint object2;
        if (plainSelect.isUseBrackets()) {
            this.buffer.append("(");
        }
        this.buffer.append("SELECT ");
        if (plainSelect.getMySqlHintStraightJoin()) {
            this.buffer.append("STRAIGHT_JOIN ");
        }
        if ((object2 = plainSelect.getOracleHint()) != null) {
            this.buffer.append(object2).append(" ");
        }
        if ((skip = plainSelect.getSkip()) != null) {
            this.buffer.append(skip).append(" ");
        }
        if ((first = plainSelect.getFirst()) != null) {
            this.buffer.append(first).append(" ");
        }
        if (plainSelect.getDistinct() != null) {
            if (plainSelect.getDistinct().isUseUnique()) {
                this.buffer.append("UNIQUE ");
            } else {
                this.buffer.append("DISTINCT ");
            }
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.buffer.append("ON (");
                Iterator<SelectItem> iterator = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (iterator.hasNext()) {
                    iterator.next().accept(this);
                    if (!iterator.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
        if ((top = plainSelect.getTop()) != null) {
            this.buffer.append(top).append(" ");
        }
        if (plainSelect.getMySqlSqlCacheFlag() != null) {
            this.buffer.append(plainSelect.getMySqlSqlCacheFlag().name()).append(" ");
        }
        if (plainSelect.getMySqlSqlCalcFoundRows()) {
            this.buffer.append("SQL_CALC_FOUND_ROWS ");
        }
        Iterator<ASTNodeAccess> iterator = plainSelect.getSelectItems().iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (plainSelect.getIntoTables() != null) {
            this.buffer.append(" INTO ");
            iterator = plainSelect.getIntoTables().iterator();
            while (iterator.hasNext()) {
                this.visit((Table)iterator.next());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            this.buffer.append(" FROM ");
            plainSelect.getFromItem().accept(this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.getKsqlWindow() != null) {
            this.buffer.append(" WINDOW ");
            this.buffer.append(plainSelect.getKsqlWindow().toString());
        }
        if (plainSelect.getWhere() != null) {
            this.buffer.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupBy() != null) {
            this.buffer.append(" ");
            new GroupByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.getGroupBy());
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getWindowDefinitions() != null) {
            this.buffer.append(" WINDOW ");
            this.buffer.append(plainSelect.getWindowDefinitions().stream().map(WindowDefinition::toString).collect(Collectors.joining(", ")));
        }
        if (plainSelect.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.isEmitChanges()) {
            this.buffer.append(" EMIT CHANGES");
        }
        if (plainSelect.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.deparseOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.deparseFetch(plainSelect.getFetch());
        }
        if (plainSelect.getWithIsolation() != null) {
            this.buffer.append(plainSelect.getWithIsolation().toString());
        }
        if (plainSelect.isForUpdate()) {
            this.buffer.append(" FOR UPDATE");
            if (plainSelect.getForUpdateTable() != null) {
                this.buffer.append(" OF ").append(plainSelect.getForUpdateTable());
            }
            if (plainSelect.getWait() != null) {
                this.buffer.append(plainSelect.getWait());
            }
            if (plainSelect.isNoWait()) {
                this.buffer.append(" NOWAIT");
            } else if (plainSelect.isSkipLocked()) {
                this.buffer.append(" SKIP LOCKED");
            }
        }
        if (plainSelect.getOptimizeFor() != null) {
            this.deparseOptimizeFor(plainSelect.getOptimizeFor());
        }
        if (plainSelect.getForXmlPath() != null) {
            this.buffer.append(" FOR XML PATH(").append(plainSelect.getForXmlPath()).append(")");
        }
        if (plainSelect.isUseBrackets()) {
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
        this.buffer.append(allTableColumns.getTable().getFullyQualifiedName()).append(".*");
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.expressionVisitor);
        if (selectExpressionItem.getAlias() != null) {
            this.buffer.append(selectExpressionItem.getAlias().toString());
        }
    }

    @Override
    public void visit(SubSelect serializable) {
        Object object;
        this.buffer.append(((SubSelect)serializable).isUseBrackets() ? "(" : "");
        if (((SubSelect)serializable).getWithItemsList() != null && !((SubSelect)serializable).getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            object = ((SubSelect)serializable).getWithItemsList().iterator();
            while (object.hasNext()) {
                ((WithItem)object.next()).accept(this);
                if (object.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        ((SubSelect)serializable).getSelectBody().accept(this);
        this.buffer.append(((SubSelect)serializable).isUseBrackets() ? ")" : "");
        object = ((SubSelect)serializable).getAlias();
        if (object != null) {
            this.buffer.append(object);
        }
        if ((object = ((SubSelect)serializable).getPivot()) != null) {
            ((Pivot)object).accept(this);
        }
        if ((serializable = ((SubSelect)serializable).getUnPivot()) != null) {
            ((UnPivot)serializable).accept(this);
        }
    }

    @Override
    public void visit(Table serializable) {
        this.buffer.append(serializable.getFullyQualifiedName());
        Serializable serializable2 = serializable.getAlias();
        if (serializable2 != null) {
            this.buffer.append(serializable2);
        }
        if ((serializable2 = serializable.getPivot()) != null) {
            ((Pivot)serializable2).accept(this);
        }
        if ((serializable2 = serializable.getUnPivot()) != null) {
            ((UnPivot)serializable2).accept(this);
        }
        if ((serializable2 = serializable.getIndexHint()) != null) {
            this.buffer.append(serializable2);
        }
        if ((serializable = serializable.getSqlServerHints()) != null) {
            this.buffer.append(serializable);
        }
    }

    @Override
    public void visit(Pivot pivot) {
        List<Column> list = pivot.getForColumns();
        this.buffer.append(" PIVOT (").append(PlainSelect.getStringList(pivot.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(list, true, list != null && list.size() > 1)).append(" IN ").append(PlainSelect.getStringList(pivot.getInItems(), true, true)).append(")");
        if (pivot.getAlias() != null) {
            this.buffer.append(pivot.getAlias().toString());
        }
    }

    @Override
    public void visit(UnPivot unPivot) {
        boolean bl2 = unPivot.getIncludeNullsSpecified();
        boolean bl3 = unPivot.getIncludeNulls();
        List<Column> list = unPivot.getUnPivotClause();
        List<Column> list2 = unPivot.getUnPivotForClause();
        this.buffer.append(" UNPIVOT").append(bl2 && bl3 ? " INCLUDE NULLS" : "").append(bl2 && !bl3 ? " EXCLUDE NULLS" : "").append(" (").append(PlainSelect.getStringList(list, true, list != null && list.size() > 1)).append(" FOR ").append(PlainSelect.getStringList(list2, true, list2 != null && list2.size() > 1)).append(" IN ").append(PlainSelect.getStringList(unPivot.getUnPivotInClause(), true, true)).append(")");
        if (unPivot.getAlias() != null) {
            this.buffer.append(unPivot.getAlias().toString());
        }
    }

    @Override
    public void visit(PivotXml pivotXml) {
        List<Column> list = pivotXml.getForColumns();
        this.buffer.append(" PIVOT XML (").append(PlainSelect.getStringList(pivotXml.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(list, true, list != null && list.size() > 1)).append(" IN (");
        if (pivotXml.isInAny()) {
            this.buffer.append("ANY");
        } else if (pivotXml.getInSelect() != null) {
            this.buffer.append(pivotXml.getInSelect());
        } else {
            this.buffer.append(PlainSelect.getStringList(pivotXml.getInItems()));
        }
        this.buffer.append("))");
    }

    public void deparseOffset(Offset offset) {
        this.buffer.append(" OFFSET ");
        this.buffer.append(offset.getOffset());
        if (offset.getOffsetParam() != null) {
            this.buffer.append(" ").append(offset.getOffsetParam());
        }
    }

    public void deparseFetch(Fetch fetch) {
        this.buffer.append(" FETCH ");
        if (fetch.isFetchParamFirst()) {
            this.buffer.append("FIRST ");
        } else {
            this.buffer.append("NEXT ");
        }
        if (fetch.getFetchJdbcParameter() != null) {
            this.buffer.append(fetch.getFetchJdbcParameter().toString());
        } else {
            this.buffer.append(fetch.getRowCount());
        }
        this.buffer.append(" ").append(fetch.getFetchParam()).append(" ONLY");
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(SubJoin subJoin) {
        this.buffer.append("(");
        subJoin.getLeft().accept(this);
        for (Join join : subJoin.getJoinList()) {
            this.deparseJoin(join);
        }
        this.buffer.append(")");
        if (subJoin.getPivot() != null) {
            subJoin.getPivot().accept(this);
        }
    }

    public void deparseJoin(Join join) {
        if (join.isGlobal()) {
            this.buffer.append(" GLOBAL ");
        }
        if (join.isSimple() && join.isOuter()) {
            this.buffer.append(", OUTER ");
        } else if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            if (join.isNatural()) {
                this.buffer.append(" NATURAL");
            }
            if (join.isRight()) {
                this.buffer.append(" RIGHT");
            } else if (join.isFull()) {
                this.buffer.append(" FULL");
            } else if (join.isLeft()) {
                this.buffer.append(" LEFT");
            } else if (join.isCross()) {
                this.buffer.append(" CROSS");
            }
            if (join.isOuter()) {
                this.buffer.append(" OUTER");
            } else if (join.isInner()) {
                this.buffer.append(" INNER");
            } else if (join.isSemi()) {
                this.buffer.append(" SEMI");
            }
            if (join.isStraight()) {
                this.buffer.append(" STRAIGHT_JOIN ");
            } else if (join.isApply()) {
                this.buffer.append(" APPLY ");
            } else {
                this.buffer.append(" JOIN ");
            }
        }
        join.getRightItem().accept(this);
        if (join.isWindowJoin()) {
            this.buffer.append(" WITHIN ");
            this.buffer.append(join.getJoinWindow().toString());
        }
        for (Expression expression : join.getOnExpressions()) {
            this.buffer.append(" ON ");
            expression.accept(this.expressionVisitor);
        }
        if (join.getUsingColumns().size() > 0) {
            this.buffer.append(" USING (");
            Iterator<Expression> iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Expression expression;
                expression = (Column)iterator.next();
                this.buffer.append(((Column)expression).toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(SetOperationList setOperationList) {
        for (int i2 = 0; i2 < setOperationList.getSelects().size(); ++i2) {
            boolean bl2;
            if (i2 != 0) {
                this.buffer.append(' ').append(setOperationList.getOperations().get(i2 - 1)).append(' ');
            }
            if (bl2 = setOperationList.getBrackets() == null || setOperationList.getBrackets().get(i2) != false) {
                this.buffer.append("(");
            }
            setOperationList.getSelects().get(i2).accept(this);
            if (!bl2) continue;
            this.buffer.append(")");
        }
        if (setOperationList.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(setOperationList.getOrderByElements());
        }
        if (setOperationList.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(setOperationList.getLimit());
        }
        if (setOperationList.getOffset() != null) {
            this.deparseOffset(setOperationList.getOffset());
        }
        if (setOperationList.getFetch() != null) {
            this.deparseFetch(setOperationList.getFetch());
        }
        if (setOperationList.getWithIsolation() != null) {
            this.buffer.append(setOperationList.getWithIsolation().toString());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        if (withItem.isRecursive()) {
            this.buffer.append("RECURSIVE ");
        }
        this.buffer.append(withItem.getName());
        if (withItem.getWithItemList() != null) {
            this.buffer.append(" ").append(PlainSelect.getStringList(withItem.getWithItemList(), true, true));
        }
        this.buffer.append(" AS ");
        if (withItem.isUseValues()) {
            ItemsList itemsList = withItem.getItemsList();
            boolean bl2 = withItem.isUsingBracketsForValues();
            this.buffer.append("(VALUES ");
            itemsList = (ExpressionList)itemsList;
            this.buffer.append(PlainSelect.getStringList(((ExpressionList)itemsList).getExpressions(), true, bl2));
            this.buffer.append(")");
            return;
        }
        SubSelect subSelect = withItem.getSubSelect();
        if (!subSelect.isUseBrackets()) {
            this.buffer.append("(");
        }
        subSelect.accept(this);
        if (!subSelect.isUseBrackets()) {
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.buffer.append(lateralSubSelect.toString());
    }

    @Override
    public void visit(ValuesList valuesList) {
        this.buffer.append("(VALUES ");
        Iterator<String> iterator = valuesList.getMultiExpressionList().getExpressionLists();
        int n2 = iterator.size() - 1;
        int n3 = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ExpressionList expressionList = (ExpressionList)iterator.next();
            new ExpressionListDeParser(this.expressionVisitor, this.buffer, !valuesList.isNoBrackets(), true).deParse((Collection<Expression>)expressionList.getExpressions());
            if (n3 < n2) {
                this.buffer.append(", ");
            }
            ++n3;
        }
        this.buffer.append(")");
        if (valuesList.getAlias() != null) {
            this.buffer.append(valuesList.getAlias());
            if (valuesList.getColumnNames() != null) {
                this.buffer.append("(");
                iterator = valuesList.getColumnNames().iterator();
                while (iterator.hasNext()) {
                    this.buffer.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(")");
            }
        }
    }

    @Override
    public void visit(AllColumns allColumns) {
        this.buffer.append('*');
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.buffer.append(tableFunction.toString());
    }

    @Override
    public void visit(ParenthesisFromItem parenthesisFromItem) {
        this.buffer.append("(");
        parenthesisFromItem.getFromItem().accept(this);
        this.buffer.append(")");
        if (parenthesisFromItem.getAlias() != null) {
            this.buffer.append(parenthesisFromItem.getAlias().toString());
        }
    }

    @Override
    public void visit(ValuesStatement valuesStatement) {
        SelectDeParser selectDeParser = this;
        new ValuesStatementDeParser(selectDeParser, selectDeParser.buffer).deParse(valuesStatement);
    }

    private void deparseOptimizeFor(OptimizeFor optimizeFor) {
        this.buffer.append(" OPTIMIZE FOR ");
        this.buffer.append(optimizeFor.getRowCount());
        this.buffer.append(" ROWS");
    }

    @Override
    void deParse(PlainSelect plainSelect) {
        plainSelect.accept(this);
    }

    @Override
    public void visit(ExpressionList expressionList) {
        new ExpressionListDeParser(this.expressionVisitor, this.buffer, expressionList.isUsingBrackets(), true).deParse((Collection<Expression>)expressionList.getExpressions());
    }

    @Override
    public void visit(NamedExpressionList object) {
        this.buffer.append(((NamedExpressionList)object).toString());
        this.buffer.append("(");
        List<Expression> list = ((NamedExpressionList)object).getExpressions();
        object = ((NamedExpressionList)object).getNames();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Expression expression = list.get(i2);
            String string = (String)object.get(i2);
            if (i2 > 0) {
                this.buffer.append(" ");
            }
            if (!string.equals("")) {
                this.buffer.append(string).append(" ");
            }
            expression.accept(this.expressionVisitor);
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(MultiExpressionList iterator) {
        iterator = ((MultiExpressionList)((Object)iterator)).getExpressionLists();
        int n2 = iterator.size() - 1;
        int n3 = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ExpressionList expressionList = (ExpressionList)iterator.next();
            new ExpressionListDeParser(this.expressionVisitor, this.buffer, expressionList.isUsingBrackets(), true).deParse((Collection<Expression>)expressionList.getExpressions());
            if (n3 < n2) {
                this.buffer.append(", ");
            }
            ++n3;
        }
    }
}

