/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.snapshot.DatabaseSnapshotHelper;
import com.datical.liquibase.ext.reports.ChecksRunReportParameters;
import java.io.Closeable;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.EmptyDatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.core.DatabaseObjectFactory;

public class LazyDatabaseSnapshot
implements Closeable {
    private final String url;
    private final String username;
    private final String password;
    private final String defaultSchemaName;
    private final String defaultCatalogName;
    private final String schemas;
    private final String driver;
    private final String driverPropertiesFile;
    private DatabaseSnapshot snapshot = null;
    private boolean attempted = false;
    private Database database = null;
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private CommandExecutionException exception;
    private ChecksRunReportParameters checksRunReportParameters;

    public LazyDatabaseSnapshot(String url, String username, String password, String defaultSchemaName, String defaultCatalogName, String schemas, String driver, String driverPropertiesFile, ChecksRunReportParameters checksRunReportParameters) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.defaultSchemaName = defaultSchemaName;
        this.defaultCatalogName = defaultCatalogName;
        this.schemas = schemas;
        this.driver = driver;
        this.driverPropertiesFile = driverPropertiesFile;
        this.checksRunReportParameters = checksRunReportParameters;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public String getSchemas() {
        return this.schemas;
    }

    public DatabaseSnapshot getSnapshot() throws CommandExecutionException {
        if (this.snapshot == null && !this.attempted) {
            this.attempted = true;
            try {
                this.database = LazyDatabaseSnapshot.createDatabaseObject(this.url, this.username, this.password, this.defaultSchemaName, this.defaultCatalogName, this.driver, this.driverPropertiesFile);
                if (this.checksRunReportParameters != null) {
                    this.checksRunReportParameters.getDatabaseInfo().setDatabaseType(this.database.getDatabaseProductName());
                    this.checksRunReportParameters.getDatabaseInfo().setVersion(this.database.getDatabaseProductVersion());
                }
                this.snapshot = DatabaseSnapshotHelper.takeSnapshot(this.url, this.database, this.schemas);
                return this.snapshot;
            }
            catch (DatabaseException dbe) {
                String message = dbe.getMessage();
                String suffix = "' cannot be accessed. Database-scoped checks cannot be completed.\nPlease check all database properties and credentials and try again.";
                if (this.database == null) {
                    if (message != null && message.contains("Cannot parse snapshot")) {
                        message = "The snapshot specified in the URL property '" + this.url + suffix;
                    }
                } else {
                    message = this.database.getConnection() instanceof OfflineConnection ? "The snapshot specified in the URL property '" + this.url + suffix : "The database target specified in the URL property '" + JdbcConnection.sanitizeUrl((String)this.url) + suffix;
                }
                this.exception = new CommandExecutionException(message, (Throwable)dbe);
                throw this.exception;
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.snapshot;
    }

    public Database getDatabase() {
        if (this.attempted) {
            return this.database;
        }
        return null;
    }

    public boolean isAttempted() {
        return this.attempted;
    }

    public static Database createDatabaseObject(String url, String username, String password, String defaultSchemaName, String defaultCatalogName, String driver, String driverPropertiesFile) throws DatabaseException {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        String databaseClassName = null;
        Class databaseClass = (Class)LiquibaseCommandLineConfiguration.DATABASE_CLASS.getCurrentValue();
        if (databaseClass != null) {
            databaseClassName = databaseClass.getCanonicalName();
        }
        String propertyProviderClass = null;
        Class clazz = (Class)LiquibaseCommandLineConfiguration.PROPERTY_PROVIDER_CLASS.getCurrentValue();
        if (clazz != null) {
            propertyProviderClass = clazz.getName();
        }
        String liquibaseCatalogName = (String)GlobalConfiguration.LIQUIBASE_CATALOG_NAME.getCurrentValue();
        String liquibaseSchemaName = (String)GlobalConfiguration.LIQUIBASE_SCHEMA_NAME.getCurrentValue();
        String databaseChangeLogTablespaceName = (String)GlobalConfiguration.LIQUIBASE_TABLESPACE_NAME.getCurrentValue();
        String databaseChangeLogLockTableName = (String)GlobalConfiguration.DATABASECHANGELOGLOCK_TABLE_NAME.getCurrentValue();
        String databaseChangeLogTableName = (String)GlobalConfiguration.DATABASECHANGELOG_TABLE_NAME.getCurrentValue();
        Database database = CommandLineUtils.createDatabaseObject((ResourceAccessor)resourceAccessor, (String)url, (String)username, (String)password, (String)driver, (String)defaultCatalogName, (String)defaultSchemaName, (boolean)false, (boolean)false, (String)databaseClassName, (String)driverPropertiesFile, (String)propertyProviderClass, (String)liquibaseCatalogName, (String)liquibaseSchemaName, (String)databaseChangeLogTableName, (String)databaseChangeLogLockTableName);
        database.setLiquibaseTablespaceName(databaseChangeLogTablespaceName);
        return database;
    }

    public DiffResult createDiffResult() throws DatabaseException, InvalidExampleException, CommandExecutionException {
        DatabaseSnapshot databaseSnapshot = this.getSnapshot();
        CompareControl.ComputedSchemas computedSchemas = CompareControl.computeSchemas((String)this.getSchemas(), (String)this.getSchemas(), null, (String)this.getDefaultCatalogName(), (String)this.getDefaultSchemaName(), (String)this.getDefaultCatalogName(), (String)this.getDefaultSchemaName(), (Database)this.getDatabase());
        CatalogAndSchema[] finalTargetSchemas = computedSchemas.finalTargetSchemas;
        CompareControl.SchemaComparison[] comparisons = new CompareControl.SchemaComparison[finalTargetSchemas.length];
        int i = 0;
        for (CatalogAndSchema catalogAndSchema : finalTargetSchemas) {
            comparisons[i] = new CompareControl.SchemaComparison(catalogAndSchema, catalogAndSchema);
            ++i;
        }
        Set typesSet = DatabaseObjectFactory.getInstance().getStandardTypes();
        CompareControl compareControl = new CompareControl(comparisons, typesSet);
        return DiffGeneratorFactory.getInstance().compare(databaseSnapshot, (DatabaseSnapshot)new EmptyDatabaseSnapshot(this.getDatabase()), compareControl);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.database != null) {
                this.database.rollback();
                this.database.close();
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(coreBundle.getString("problem.closing.connection"), (Throwable)e);
        }
    }
}

