/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.parser;

import java.util.HashSet;
import java.util.Set;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.util.StandardSqlParser;
import liquibase.util.StringClauses;

public class ExceptionSwallowingSqlParser
extends StandardSqlParser {
    public static final String CHANGESET_SCOPE_KEY = "changeset";
    private static final Set<ChangeSet> changeSetsWithLoggedWarning = new HashSet<ChangeSet>();
    private boolean printedCommentRemovalWarning = false;
    private int priority = -1;

    public StringClauses parse(String sqlBlock) {
        try {
            return super.parse(sqlBlock);
        }
        catch (Throwable e) {
            return this.handleException(e, sqlBlock);
        }
    }

    public StringClauses parse(String sqlBlock, boolean preserveWhitespace, boolean preserveComments) {
        try {
            return super.parse(sqlBlock, preserveWhitespace, preserveComments);
        }
        catch (Throwable e) {
            return this.handleException(e, sqlBlock);
        }
    }

    private StringClauses handleException(Throwable e, String sql) {
        String logMessage;
        ChangeSet changeSet = (ChangeSet)Scope.getCurrentScope().get(CHANGESET_SCOPE_KEY, ChangeSet.class);
        if (changeSet != null) {
            if (changeSetsWithLoggedWarning.contains(changeSet)) {
                logMessage = null;
            } else {
                logMessage = "WARNING: Liquibase was unable to remove comments from " + changeSet + "; quality checks will be run without removing comments.";
                changeSetsWithLoggedWarning.add(changeSet);
            }
        } else {
            logMessage = "WARNING: Liquibase was unable to remove comments from a changeset; quality checks will be run without removing comments.";
        }
        if (!this.printedCommentRemovalWarning) {
            Scope.getCurrentScope().getUI().sendMessage("WARNING: Liquibase was unable to remove comments from a changeset; quality checks will be run without removing comments.");
            this.printedCommentRemovalWarning = true;
        }
        if (logMessage != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(logMessage, e);
        }
        StringClauses stringClauses = new StringClauses();
        stringClauses.append(sql);
        return stringClauses;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

