/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.model;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfigFileInfo;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract class AbstractConfigurableRule {
    private boolean enabled;
    private SeverityEnum severity;
    private UUID id;
    private String shortName;
    private String name;
    private String description;
    private CheckSettingsConfigFileInfo fileInfo;

    public boolean isConfigurable() {
        return this instanceof DynamicRule;
    }

    public Optional<AbstractLiquibaseRule> findParentRule(List<AbstractLiquibaseRule> rules) {
        DynamicRule dr;
        UUID idToMatch = this.isConfigurable() ? ((dr = (DynamicRule)this).isCopy() ? dr.getParentRuleId() : dr.getId()) : this.getId();
        return rules.stream().filter(r -> r.getId().equals(idToMatch)).findFirst();
    }

    public String getShortName(List<AbstractLiquibaseRule> rules) {
        if (this.isConfigurable()) {
            return ((DynamicRule)this).getShortName();
        }
        Optional<AbstractLiquibaseRule> parentRule = this.findParentRule(rules);
        return parentRule.map(AbstractLiquibaseRule::getShortName).orElse(null);
    }

    public boolean checkSettingsConfigFilenameMatches(String filename) {
        CheckSettingsConfigFileInfo fileInfo = this.getFileInfo();
        if (fileInfo != null) {
            return filename.equals(fileInfo.getFilename());
        }
        return false;
    }

    public static AbstractConfigurableRule fromRuleImplementation(AbstractLiquibaseRule rule, CheckSettingsConfigFileInfo fileInfo) {
        if (rule.isConfigurable()) {
            ArrayList<DynamicRuleParameter> parameters = new ArrayList<DynamicRuleParameter>(rule.getParameters().size());
            for (RuleParameter<?> parameter : rule.getParameters()) {
                parameters.add(new DynamicRuleParameter(parameter.getParameter(), parameter.getDefaultValue()));
            }
            return new DynamicRule(rule.isEnabledByDefault(), rule.getSeverity(), rule.getId(), rule.getShortName(), rule.getName(), rule.getDescription(), null, parameters, fileInfo);
        }
        return new BasicRule(rule.isEnabledByDefault(), rule.getSeverity(), rule.getId(), rule.getShortName(), rule.getName(), rule.getDescription(), fileInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConfigurableRule that = (AbstractConfigurableRule)o;
        return this.enabled == that.enabled && Objects.equals((Object)this.severity, (Object)that.severity) && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.severity, this.id});
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SeverityEnum getSeverity() {
        return this.severity;
    }

    public UUID getId() {
        return this.id;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public CheckSettingsConfigFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSeverity(SeverityEnum severity) {
        this.severity = severity;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFileInfo(CheckSettingsConfigFileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public AbstractConfigurableRule(boolean enabled, SeverityEnum severity, UUID id, String shortName, String name, String description, CheckSettingsConfigFileInfo fileInfo) {
        this.enabled = enabled;
        this.severity = severity;
        this.id = id;
        this.shortName = shortName;
        this.name = name;
        this.description = description;
        this.fileInfo = fileInfo;
    }

    public AbstractConfigurableRule() {
    }

    public static final class Fields {
        public static final String enabled = "enabled";
        public static final String severity = "severity";
        public static final String id = "id";
        public static final String shortName = "shortName";
        public static final String name = "name";
        public static final String description = "description";
        public static final String fileInfo = "fileInfo";

        private Fields() {
        }
    }
}

