/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.checks;

import com.datical.liquibase.ext.reports.checks.TriggeredCheck;
import com.datical.liquibase.ext.reports.checks.TriggeredCheckCount;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class DatabaseChecksRunInfo {
    private int checksTriggered;
    private Integer sqlParserFailSeverity;
    private List<String> checksRun = new ArrayList<String>();
    private List<TriggeredCheck> triggeredChecks = new ArrayList<TriggeredCheck>();
    private List<String> databaseObjectsValidated = new ArrayList<String>();
    private List<VerboseDatabaseObject> verboseObjectsValidated = new ArrayList<VerboseDatabaseObject>();
    private Set<DatabaseCheckResults> databaseCheckResults = new LinkedHashSet<DatabaseCheckResults>();
    private TriggeredCheckCount triggeredCheckCount = new TriggeredCheckCount();

    public boolean getShowChecksRun() {
        return !this.checksRun.isEmpty();
    }

    public boolean getShowVerboseObjectsValidated() {
        return !this.verboseObjectsValidated.isEmpty();
    }

    public void addDatabaseResults(LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> databaseResults, String checkSettingsFile) {
        ArrayList checkResultsList = new ArrayList();
        databaseResults.forEach((databaseObject, liquibaseQualityCheckResult) -> {
            List<Rule> executedRules = liquibaseQualityCheckResult.getExecutedRules(checkSettingsFile).stream().map(RuleCombination::getRule).collect(Collectors.toList());
            DatabaseCheckResults databaseCheckResults = new DatabaseCheckResults();
            databaseCheckResults.setObject(databaseObject.getName());
            databaseCheckResults.setType(Arrays.stream(StringUtil.splitCamelCase((String)databaseObject.getObjectTypeName())).map(StringUtil::upperCaseFirst).collect(Collectors.joining(" ")));
            databaseCheckResults.getTriggeredChecks().addAll(TriggeredCheck.buildTriggeredChecks(liquibaseQualityCheckResult.getRuleResults(), executedRules, this.getSqlParserFailSeverity(), checkSettingsFile));
            if (!databaseCheckResults.getTriggeredChecks().isEmpty()) {
                databaseCheckResults.setTriggeredCheckCount(TriggeredCheckCount.buildTriggeredCheckCount(databaseCheckResults.getTriggeredChecks()));
                checkResultsList.add(databaseCheckResults);
            }
        });
        checkResultsList.forEach(checkResults -> {
            this.databaseCheckResults.stream().filter(existingResults -> existingResults.equals(checkResults)).findFirst().ifPresent(existingResult -> {
                if (existingResult.getTriggeredChecks().addAll(checkResults.getTriggeredChecks())) {
                    existingResult.setTriggeredCheckCount(TriggeredCheckCount.buildTriggeredCheckCount(existingResult.getTriggeredChecks()));
                    this.triggeredCheckCount = TriggeredCheckCount.add(this.triggeredCheckCount, TriggeredCheckCount.buildTriggeredCheckCount(checkResults.getTriggeredChecks()));
                }
            });
            if (this.databaseCheckResults.add((DatabaseCheckResults)checkResults)) {
                this.triggeredCheckCount = TriggeredCheckCount.add(this.triggeredCheckCount, TriggeredCheckCount.buildTriggeredCheckCount(checkResults.getTriggeredChecks()));
            }
        });
    }

    public int getChecksTriggered() {
        return this.checksTriggered;
    }

    public Integer getSqlParserFailSeverity() {
        return this.sqlParserFailSeverity;
    }

    public List<String> getChecksRun() {
        return this.checksRun;
    }

    public List<TriggeredCheck> getTriggeredChecks() {
        return this.triggeredChecks;
    }

    public List<String> getDatabaseObjectsValidated() {
        return this.databaseObjectsValidated;
    }

    public List<VerboseDatabaseObject> getVerboseObjectsValidated() {
        return this.verboseObjectsValidated;
    }

    public Set<DatabaseCheckResults> getDatabaseCheckResults() {
        return this.databaseCheckResults;
    }

    public TriggeredCheckCount getTriggeredCheckCount() {
        return this.triggeredCheckCount;
    }

    public void setChecksTriggered(int checksTriggered) {
        this.checksTriggered = checksTriggered;
    }

    public void setSqlParserFailSeverity(Integer sqlParserFailSeverity) {
        this.sqlParserFailSeverity = sqlParserFailSeverity;
    }

    public void setChecksRun(List<String> checksRun) {
        this.checksRun = checksRun;
    }

    public void setTriggeredChecks(List<TriggeredCheck> triggeredChecks) {
        this.triggeredChecks = triggeredChecks;
    }

    public void setDatabaseObjectsValidated(List<String> databaseObjectsValidated) {
        this.databaseObjectsValidated = databaseObjectsValidated;
    }

    public void setVerboseObjectsValidated(List<VerboseDatabaseObject> verboseObjectsValidated) {
        this.verboseObjectsValidated = verboseObjectsValidated;
    }

    public void setDatabaseCheckResults(Set<DatabaseCheckResults> databaseCheckResults) {
        this.databaseCheckResults = databaseCheckResults;
    }

    public void setTriggeredCheckCount(TriggeredCheckCount triggeredCheckCount) {
        this.triggeredCheckCount = triggeredCheckCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseChecksRunInfo)) {
            return false;
        }
        DatabaseChecksRunInfo other = (DatabaseChecksRunInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChecksTriggered() != other.getChecksTriggered()) {
            return false;
        }
        Integer this$sqlParserFailSeverity = this.getSqlParserFailSeverity();
        Integer other$sqlParserFailSeverity = other.getSqlParserFailSeverity();
        if (this$sqlParserFailSeverity == null ? other$sqlParserFailSeverity != null : !((Object)this$sqlParserFailSeverity).equals(other$sqlParserFailSeverity)) {
            return false;
        }
        List<String> this$checksRun = this.getChecksRun();
        List<String> other$checksRun = other.getChecksRun();
        if (this$checksRun == null ? other$checksRun != null : !((Object)this$checksRun).equals(other$checksRun)) {
            return false;
        }
        List<TriggeredCheck> this$triggeredChecks = this.getTriggeredChecks();
        List<TriggeredCheck> other$triggeredChecks = other.getTriggeredChecks();
        if (this$triggeredChecks == null ? other$triggeredChecks != null : !((Object)this$triggeredChecks).equals(other$triggeredChecks)) {
            return false;
        }
        List<String> this$databaseObjectsValidated = this.getDatabaseObjectsValidated();
        List<String> other$databaseObjectsValidated = other.getDatabaseObjectsValidated();
        if (this$databaseObjectsValidated == null ? other$databaseObjectsValidated != null : !((Object)this$databaseObjectsValidated).equals(other$databaseObjectsValidated)) {
            return false;
        }
        List<VerboseDatabaseObject> this$verboseObjectsValidated = this.getVerboseObjectsValidated();
        List<VerboseDatabaseObject> other$verboseObjectsValidated = other.getVerboseObjectsValidated();
        if (this$verboseObjectsValidated == null ? other$verboseObjectsValidated != null : !((Object)this$verboseObjectsValidated).equals(other$verboseObjectsValidated)) {
            return false;
        }
        Set<DatabaseCheckResults> this$databaseCheckResults = this.getDatabaseCheckResults();
        Set<DatabaseCheckResults> other$databaseCheckResults = other.getDatabaseCheckResults();
        if (this$databaseCheckResults == null ? other$databaseCheckResults != null : !((Object)this$databaseCheckResults).equals(other$databaseCheckResults)) {
            return false;
        }
        TriggeredCheckCount this$triggeredCheckCount = this.getTriggeredCheckCount();
        TriggeredCheckCount other$triggeredCheckCount = other.getTriggeredCheckCount();
        return !(this$triggeredCheckCount == null ? other$triggeredCheckCount != null : !((Object)this$triggeredCheckCount).equals(other$triggeredCheckCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseChecksRunInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChecksTriggered();
        Integer $sqlParserFailSeverity = this.getSqlParserFailSeverity();
        result = result * 59 + ($sqlParserFailSeverity == null ? 43 : ((Object)$sqlParserFailSeverity).hashCode());
        List<String> $checksRun = this.getChecksRun();
        result = result * 59 + ($checksRun == null ? 43 : ((Object)$checksRun).hashCode());
        List<TriggeredCheck> $triggeredChecks = this.getTriggeredChecks();
        result = result * 59 + ($triggeredChecks == null ? 43 : ((Object)$triggeredChecks).hashCode());
        List<String> $databaseObjectsValidated = this.getDatabaseObjectsValidated();
        result = result * 59 + ($databaseObjectsValidated == null ? 43 : ((Object)$databaseObjectsValidated).hashCode());
        List<VerboseDatabaseObject> $verboseObjectsValidated = this.getVerboseObjectsValidated();
        result = result * 59 + ($verboseObjectsValidated == null ? 43 : ((Object)$verboseObjectsValidated).hashCode());
        Set<DatabaseCheckResults> $databaseCheckResults = this.getDatabaseCheckResults();
        result = result * 59 + ($databaseCheckResults == null ? 43 : ((Object)$databaseCheckResults).hashCode());
        TriggeredCheckCount $triggeredCheckCount = this.getTriggeredCheckCount();
        result = result * 59 + ($triggeredCheckCount == null ? 43 : ((Object)$triggeredCheckCount).hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseChecksRunInfo(checksTriggered=" + this.getChecksTriggered() + ", sqlParserFailSeverity=" + this.getSqlParserFailSeverity() + ", checksRun=" + this.getChecksRun() + ", triggeredChecks=" + this.getTriggeredChecks() + ", databaseObjectsValidated=" + this.getDatabaseObjectsValidated() + ", verboseObjectsValidated=" + this.getVerboseObjectsValidated() + ", databaseCheckResults=" + this.getDatabaseCheckResults() + ", triggeredCheckCount=" + this.getTriggeredCheckCount() + ")";
    }

    public static class DatabaseCheckResults {
        private String type;
        private String object;
        private TriggeredCheckCount triggeredCheckCount = new TriggeredCheckCount();
        private Set<TriggeredCheck> triggeredChecks = new HashSet<TriggeredCheck>();

        public String getType() {
            return this.type;
        }

        public String getObject() {
            return this.object;
        }

        public TriggeredCheckCount getTriggeredCheckCount() {
            return this.triggeredCheckCount;
        }

        public Set<TriggeredCheck> getTriggeredChecks() {
            return this.triggeredChecks;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setObject(String object) {
            this.object = object;
        }

        public void setTriggeredCheckCount(TriggeredCheckCount triggeredCheckCount) {
            this.triggeredCheckCount = triggeredCheckCount;
        }

        public void setTriggeredChecks(Set<TriggeredCheck> triggeredChecks) {
            this.triggeredChecks = triggeredChecks;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatabaseCheckResults)) {
                return false;
            }
            DatabaseCheckResults other = (DatabaseCheckResults)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$object = this.getObject();
            String other$object = other.getObject();
            return !(this$object == null ? other$object != null : !this$object.equals(other$object));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DatabaseCheckResults;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            return result;
        }

        public String toString() {
            return "DatabaseChecksRunInfo.DatabaseCheckResults(type=" + this.getType() + ", object=" + this.getObject() + ", triggeredCheckCount=" + this.getTriggeredCheckCount() + ", triggeredChecks=" + this.getTriggeredChecks() + ")";
        }
    }

    public static class VerboseDatabaseObject {
        private final String type;
        private final int count;
        private final List<String> objects;

        public VerboseDatabaseObject(String type, int count, List<String> objects) {
            this.type = type;
            this.count = count;
            this.objects = objects;
        }

        public String getType() {
            return this.type;
        }

        public int getCount() {
            return this.count;
        }

        public List<String> getObjects() {
            return this.objects;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerboseDatabaseObject)) {
                return false;
            }
            VerboseDatabaseObject other = (VerboseDatabaseObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<String> this$objects = this.getObjects();
            List<String> other$objects = other.getObjects();
            return !(this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VerboseDatabaseObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<String> $objects = this.getObjects();
            result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
            return result;
        }

        public String toString() {
            return "DatabaseChecksRunInfo.VerboseDatabaseObject(type=" + this.getType() + ", count=" + this.getCount() + ", objects=" + this.getObjects() + ")";
        }
    }
}

