/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class TriggeredCheck {
    private UUID id;
    private String checkName;
    private String checkSettingsFile;
    private Boolean info = false;
    private Boolean minor = false;
    private Boolean major = false;
    private Boolean critical = false;
    private Boolean blocker = false;
    private String description;
    private List<DynamicRuleParameter> parameters = new ArrayList<DynamicRuleParameter>();

    public static Set<TriggeredCheck> buildTriggeredChecks(List<LiquibaseRuleResult> liquibaseRuleResults, List<Rule> executedRules, Integer sqlParserSeverity, String checkSettingsFile) {
        return liquibaseRuleResults.stream().filter(liquibaseRuleResult -> !liquibaseRuleResult.hasRuleSucceeded() && executedRules.contains(liquibaseRuleResult.getRule()) && !liquibaseRuleResult.hasInvalidChangelogFileTypeFailures()).map(liquibaseRuleResult -> {
            DynamicRule dynamicRule;
            TriggeredCheck triggeredCheck = new TriggeredCheck();
            triggeredCheck.setCheckName(liquibaseRuleResult.getRuleShortName(false));
            triggeredCheck.setId(liquibaseRuleResult.getRule().getId());
            triggeredCheck.setDescription(liquibaseRuleResult.getRule().getDescription());
            triggeredCheck.setCheckSettingsFile(checkSettingsFile);
            SeverityEnum severity = liquibaseRuleResult.getRuleSeverity(sqlParserSeverity);
            switch (severity) {
                case INFO: {
                    triggeredCheck.setInfo(true);
                    break;
                }
                case MINOR: {
                    triggeredCheck.setMinor(true);
                    break;
                }
                case MAJOR: {
                    triggeredCheck.setMajor(true);
                    break;
                }
                case CRITICAL: {
                    triggeredCheck.setCritical(true);
                    break;
                }
                case BLOCKER: {
                    triggeredCheck.setBlocker(true);
                }
            }
            AbstractConfigurableRule rule = liquibaseRuleResult.getConfigurableRule();
            if (rule instanceof DynamicRule && (dynamicRule = (DynamicRule)rule).getParameters() != null) {
                triggeredCheck.getParameters().addAll(dynamicRule.getParameters());
            }
            return triggeredCheck;
        }).collect(Collectors.toSet());
    }

    public UUID getId() {
        return this.id;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public String getCheckSettingsFile() {
        return this.checkSettingsFile;
    }

    public Boolean getInfo() {
        return this.info;
    }

    public Boolean getMinor() {
        return this.minor;
    }

    public Boolean getMajor() {
        return this.major;
    }

    public Boolean getCritical() {
        return this.critical;
    }

    public Boolean getBlocker() {
        return this.blocker;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DynamicRuleParameter> getParameters() {
        return this.parameters;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }

    public void setCheckSettingsFile(String checkSettingsFile) {
        this.checkSettingsFile = checkSettingsFile;
    }

    public void setInfo(Boolean info) {
        this.info = info;
    }

    public void setMinor(Boolean minor) {
        this.minor = minor;
    }

    public void setMajor(Boolean major) {
        this.major = major;
    }

    public void setCritical(Boolean critical) {
        this.critical = critical;
    }

    public void setBlocker(Boolean blocker) {
        this.blocker = blocker;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParameters(List<DynamicRuleParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TriggeredCheck)) {
            return false;
        }
        TriggeredCheck other = (TriggeredCheck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$info = this.getInfo();
        Boolean other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        Boolean this$minor = this.getMinor();
        Boolean other$minor = other.getMinor();
        if (this$minor == null ? other$minor != null : !((Object)this$minor).equals(other$minor)) {
            return false;
        }
        Boolean this$major = this.getMajor();
        Boolean other$major = other.getMajor();
        if (this$major == null ? other$major != null : !((Object)this$major).equals(other$major)) {
            return false;
        }
        Boolean this$critical = this.getCritical();
        Boolean other$critical = other.getCritical();
        if (this$critical == null ? other$critical != null : !((Object)this$critical).equals(other$critical)) {
            return false;
        }
        Boolean this$blocker = this.getBlocker();
        Boolean other$blocker = other.getBlocker();
        if (this$blocker == null ? other$blocker != null : !((Object)this$blocker).equals(other$blocker)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$checkName = this.getCheckName();
        String other$checkName = other.getCheckName();
        if (this$checkName == null ? other$checkName != null : !this$checkName.equals(other$checkName)) {
            return false;
        }
        String this$checkSettingsFile = this.getCheckSettingsFile();
        String other$checkSettingsFile = other.getCheckSettingsFile();
        if (this$checkSettingsFile == null ? other$checkSettingsFile != null : !this$checkSettingsFile.equals(other$checkSettingsFile)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<DynamicRuleParameter> this$parameters = this.getParameters();
        List<DynamicRuleParameter> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TriggeredCheck;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        Boolean $minor = this.getMinor();
        result = result * 59 + ($minor == null ? 43 : ((Object)$minor).hashCode());
        Boolean $major = this.getMajor();
        result = result * 59 + ($major == null ? 43 : ((Object)$major).hashCode());
        Boolean $critical = this.getCritical();
        result = result * 59 + ($critical == null ? 43 : ((Object)$critical).hashCode());
        Boolean $blocker = this.getBlocker();
        result = result * 59 + ($blocker == null ? 43 : ((Object)$blocker).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $checkName = this.getCheckName();
        result = result * 59 + ($checkName == null ? 43 : $checkName.hashCode());
        String $checkSettingsFile = this.getCheckSettingsFile();
        result = result * 59 + ($checkSettingsFile == null ? 43 : $checkSettingsFile.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<DynamicRuleParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "TriggeredCheck(id=" + this.getId() + ", checkName=" + this.getCheckName() + ", checkSettingsFile=" + this.getCheckSettingsFile() + ", info=" + this.getInfo() + ", minor=" + this.getMinor() + ", major=" + this.getMajor() + ", critical=" + this.getCritical() + ", blocker=" + this.getBlocker() + ", description=" + this.getDescription() + ", parameters=" + this.getParameters() + ")";
    }
}

