/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.checks;

import com.datical.liquibase.ext.reports.checks.TriggeredCheck;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Predicate;
import liquibase.util.StringUtil;
import lombok.Generated;

public class TriggeredCheckCount {
    private long infoCount;
    private long minorCount;
    private long majorCount;
    private long criticalCount;
    private long blockerCount;
    private Boolean hasInfo = false;
    private Boolean hasMinor = false;
    private Boolean hasMajor = false;
    private Boolean hasCritical = false;
    private Boolean hasBlocker = false;

    private static long getCount(Set<TriggeredCheck> changeSetCheckResults, Predicate<TriggeredCheck> predicate) {
        return changeSetCheckResults.stream().filter(predicate).count();
    }

    public static TriggeredCheckCount buildTriggeredCheckCount(Set<TriggeredCheck> changeSetCheckResults) {
        TriggeredCheckCount checkCount = new TriggeredCheckCount();
        checkCount.setInfoCount(TriggeredCheckCount.getCount(changeSetCheckResults, TriggeredCheck::getInfo));
        checkCount.setMinorCount(TriggeredCheckCount.getCount(changeSetCheckResults, TriggeredCheck::getMinor));
        checkCount.setMajorCount(TriggeredCheckCount.getCount(changeSetCheckResults, TriggeredCheck::getMajor));
        checkCount.setCriticalCount(TriggeredCheckCount.getCount(changeSetCheckResults, TriggeredCheck::getCritical));
        checkCount.setBlockerCount(TriggeredCheckCount.getCount(changeSetCheckResults, TriggeredCheck::getBlocker));
        checkCount.setHasInfo(checkCount.getInfoCount() > 0L);
        checkCount.setHasMinor(checkCount.getMinorCount() > 0L);
        checkCount.setHasMajor(checkCount.getMajorCount() > 0L);
        checkCount.setHasCritical(checkCount.getCriticalCount() > 0L);
        checkCount.setHasBlocker(checkCount.getBlockerCount() > 0L);
        return checkCount;
    }

    public String getStatus() {
        LinkedList<String> response = new LinkedList<String>();
        if (this.getHasBlocker().booleanValue()) {
            response.add(String.format("%d BLOCKER", this.getBlockerCount()));
        }
        if (this.getHasCritical().booleanValue()) {
            response.add(String.format("%d CRITICAL", this.getCriticalCount()));
        }
        if (this.getHasMajor().booleanValue()) {
            response.add(String.format("%d MAJOR", this.getMajorCount()));
        }
        if (this.getHasMinor().booleanValue()) {
            response.add(String.format("%d MINOR", this.getMinorCount()));
        }
        if (this.getHasInfo().booleanValue()) {
            response.add(String.format("%d INFO", this.getInfoCount()));
        }
        return StringUtil.join(response, (String)" - ");
    }

    public String getAlertBackground() {
        if (this.getHasBlocker().booleanValue()) {
            return "red";
        }
        if (this.getHasCritical().booleanValue()) {
            return "crimson";
        }
        if (this.getHasMajor().booleanValue()) {
            return "crimson";
        }
        if (this.getHasMinor().booleanValue()) {
            return "orange";
        }
        return "rgb(65, 105, 225)";
    }

    public String getAlertSecondaryBackground() {
        if (this.getHasBlocker().booleanValue()) {
            return "rgb(250,175,180)";
        }
        if (this.getHasCritical().booleanValue()) {
            return "rgb(250,175,180)";
        }
        if (this.getHasMajor().booleanValue()) {
            return "rgb(250,175,180)";
        }
        if (this.getHasMinor().booleanValue()) {
            return "rgb(250, 207, 175)";
        }
        return "rgb(197, 227, 232)";
    }

    public String getAlertTitle() {
        if (this.getHasBlocker().booleanValue()) {
            return String.format("%d BLOCKERS DETECTED!", this.getBlockerCount());
        }
        if (this.getHasCritical().booleanValue()) {
            return String.format("%d CRITICAL DETECTED!", this.getCriticalCount());
        }
        if (this.getHasMajor().booleanValue()) {
            return String.format("%d MAJOR DETECTED!", this.getMajorCount());
        }
        if (this.getHasMinor().booleanValue()) {
            return String.format("%d MINOR DETECTED!", this.getMinorCount());
        }
        return String.format("%d INFO DETECTED!", this.getInfoCount());
    }

    public static TriggeredCheckCount add(TriggeredCheckCount count1, TriggeredCheckCount count2) {
        TriggeredCheckCount newCount = new TriggeredCheckCount();
        newCount.setBlockerCount(count1.getBlockerCount() + count2.getBlockerCount());
        newCount.setCriticalCount(count1.getCriticalCount() + count2.getCriticalCount());
        newCount.setMajorCount(count1.getMajorCount() + count2.getMajorCount());
        newCount.setMinorCount(count1.getMinorCount() + count2.getMinorCount());
        newCount.setInfoCount(count1.getInfoCount() + count2.getInfoCount());
        newCount.setHasBlocker(count1.getHasBlocker() != false || count2.getHasBlocker() != false);
        newCount.setHasCritical(count1.getHasCritical() != false || count2.getHasCritical() != false);
        newCount.setHasMajor(count1.getHasMajor() != false || count2.getHasMajor() != false);
        newCount.setHasMinor(count1.getHasMinor() != false || count2.getHasMinor() != false);
        newCount.setHasInfo(count1.getHasInfo() != false || count2.getHasInfo() != false);
        return newCount;
    }

    @Generated
    public TriggeredCheckCount() {
    }

    @Generated
    public long getInfoCount() {
        return this.infoCount;
    }

    @Generated
    public long getMinorCount() {
        return this.minorCount;
    }

    @Generated
    public long getMajorCount() {
        return this.majorCount;
    }

    @Generated
    public long getCriticalCount() {
        return this.criticalCount;
    }

    @Generated
    public long getBlockerCount() {
        return this.blockerCount;
    }

    @Generated
    public Boolean getHasInfo() {
        return this.hasInfo;
    }

    @Generated
    public Boolean getHasMinor() {
        return this.hasMinor;
    }

    @Generated
    public Boolean getHasMajor() {
        return this.hasMajor;
    }

    @Generated
    public Boolean getHasCritical() {
        return this.hasCritical;
    }

    @Generated
    public Boolean getHasBlocker() {
        return this.hasBlocker;
    }

    @Generated
    public void setInfoCount(long infoCount) {
        this.infoCount = infoCount;
    }

    @Generated
    public void setMinorCount(long minorCount) {
        this.minorCount = minorCount;
    }

    @Generated
    public void setMajorCount(long majorCount) {
        this.majorCount = majorCount;
    }

    @Generated
    public void setCriticalCount(long criticalCount) {
        this.criticalCount = criticalCount;
    }

    @Generated
    public void setBlockerCount(long blockerCount) {
        this.blockerCount = blockerCount;
    }

    @Generated
    public void setHasInfo(Boolean hasInfo) {
        this.hasInfo = hasInfo;
    }

    @Generated
    public void setHasMinor(Boolean hasMinor) {
        this.hasMinor = hasMinor;
    }

    @Generated
    public void setHasMajor(Boolean hasMajor) {
        this.hasMajor = hasMajor;
    }

    @Generated
    public void setHasCritical(Boolean hasCritical) {
        this.hasCritical = hasCritical;
    }

    @Generated
    public void setHasBlocker(Boolean hasBlocker) {
        this.hasBlocker = hasBlocker;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TriggeredCheckCount)) {
            return false;
        }
        TriggeredCheckCount other = (TriggeredCheckCount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInfoCount() != other.getInfoCount()) {
            return false;
        }
        if (this.getMinorCount() != other.getMinorCount()) {
            return false;
        }
        if (this.getMajorCount() != other.getMajorCount()) {
            return false;
        }
        if (this.getCriticalCount() != other.getCriticalCount()) {
            return false;
        }
        if (this.getBlockerCount() != other.getBlockerCount()) {
            return false;
        }
        Boolean this$hasInfo = this.getHasInfo();
        Boolean other$hasInfo = other.getHasInfo();
        if (this$hasInfo == null ? other$hasInfo != null : !((Object)this$hasInfo).equals(other$hasInfo)) {
            return false;
        }
        Boolean this$hasMinor = this.getHasMinor();
        Boolean other$hasMinor = other.getHasMinor();
        if (this$hasMinor == null ? other$hasMinor != null : !((Object)this$hasMinor).equals(other$hasMinor)) {
            return false;
        }
        Boolean this$hasMajor = this.getHasMajor();
        Boolean other$hasMajor = other.getHasMajor();
        if (this$hasMajor == null ? other$hasMajor != null : !((Object)this$hasMajor).equals(other$hasMajor)) {
            return false;
        }
        Boolean this$hasCritical = this.getHasCritical();
        Boolean other$hasCritical = other.getHasCritical();
        if (this$hasCritical == null ? other$hasCritical != null : !((Object)this$hasCritical).equals(other$hasCritical)) {
            return false;
        }
        Boolean this$hasBlocker = this.getHasBlocker();
        Boolean other$hasBlocker = other.getHasBlocker();
        return !(this$hasBlocker == null ? other$hasBlocker != null : !((Object)this$hasBlocker).equals(other$hasBlocker));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TriggeredCheckCount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $infoCount = this.getInfoCount();
        result = result * 59 + (int)($infoCount >>> 32 ^ $infoCount);
        long $minorCount = this.getMinorCount();
        result = result * 59 + (int)($minorCount >>> 32 ^ $minorCount);
        long $majorCount = this.getMajorCount();
        result = result * 59 + (int)($majorCount >>> 32 ^ $majorCount);
        long $criticalCount = this.getCriticalCount();
        result = result * 59 + (int)($criticalCount >>> 32 ^ $criticalCount);
        long $blockerCount = this.getBlockerCount();
        result = result * 59 + (int)($blockerCount >>> 32 ^ $blockerCount);
        Boolean $hasInfo = this.getHasInfo();
        result = result * 59 + ($hasInfo == null ? 43 : ((Object)$hasInfo).hashCode());
        Boolean $hasMinor = this.getHasMinor();
        result = result * 59 + ($hasMinor == null ? 43 : ((Object)$hasMinor).hashCode());
        Boolean $hasMajor = this.getHasMajor();
        result = result * 59 + ($hasMajor == null ? 43 : ((Object)$hasMajor).hashCode());
        Boolean $hasCritical = this.getHasCritical();
        result = result * 59 + ($hasCritical == null ? 43 : ((Object)$hasCritical).hashCode());
        Boolean $hasBlocker = this.getHasBlocker();
        result = result * 59 + ($hasBlocker == null ? 43 : ((Object)$hasBlocker).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TriggeredCheckCount(infoCount=" + this.getInfoCount() + ", minorCount=" + this.getMinorCount() + ", majorCount=" + this.getMajorCount() + ", criticalCount=" + this.getCriticalCount() + ", blockerCount=" + this.getBlockerCount() + ", hasInfo=" + this.getHasInfo() + ", hasMinor=" + this.getHasMinor() + ", hasMajor=" + this.getHasMajor() + ", hasCritical=" + this.getHasCritical() + ", hasBlocker=" + this.getHasBlocker() + ")";
    }
}

