/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.checks.config.model.MatcherContext;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public abstract class AbstractNotAllowedToContainRule
extends AbstractLiquibaseBasicForecastRule {
    public abstract List<Pattern> getReservedPhrase();

    public abstract String getFailureMessage();

    public List<Class<? extends Change>> getOtherCompatibleChangeTypes() {
        return Collections.emptyList();
    }

    private boolean doEvaluate(ChangeSet changeSet, List<Change> changes, boolean isRollback, BasicRule basicRule) {
        for (Change change : changes) {
            if (change instanceof AbstractSQLChange) {
                MatcherContext matcherContext = this.doCheck((AbstractSQLChange)change);
                if (matcherContext.matchResult) {
                    this.addFailureRuleIteration(changeSet, change, this.getFailureMessage(), (AbstractConfigurableRule)basicRule, isRollback, matcherContext);
                    return this.returnAtEndOfRule(changeSet, basicRule, isRollback);
                }
            }
            boolean applicable = false;
            if (this.getOtherCompatibleChangeTypes() != null) {
                for (Class<? extends Change> otherCompatibleChangeType : this.getOtherCompatibleChangeTypes()) {
                    if (!otherCompatibleChangeType.isAssignableFrom(change.getClass())) continue;
                    applicable = true;
                    MatcherContext matcherContext = this.doCheck(change);
                    if (!matcherContext.matchResult) continue;
                    this.addFailureRuleIteration(changeSet, this.getFailureMessage(), basicRule, isRollback);
                    return this.returnAtEndOfRule(changeSet, basicRule, isRollback);
                }
            }
            if (applicable) continue;
            this.addNonApplicableRuleIteration(changeSet, String.format("Changeset '%s' not applicable for rule '%s'", changeSet.toString(), basicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)basicRule);
        }
        return this.returnAtEndOfRule(changeSet, basicRule, isRollback);
    }

    @Override
    public final boolean internalEvaluate(ChangeSet changeSet, BasicRule basicRule) {
        return this.doEvaluate(changeSet, changeSet.getChanges(), false, basicRule);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, BasicRule basicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, BasicRule basicRule) {
        return this.doEvaluate(changeSet, changes, true, basicRule);
    }

    public MatcherContext doCheck(Change change) {
        return new MatcherContext();
    }

    public MatcherContext doCheck(AbstractSQLChange change) {
        MatcherContext matcherContext = new MatcherContext();
        String sql = AbstractNotAllowedToContainRule.getSql(change);
        if (StringUtil.isNotEmpty((String)sql) && StringUtil.isNotEmpty((String)(sql = StringUtil.stripComments((String)sql, (ChangeSet)change.getChangeSet()).toLowerCase()))) {
            for (Pattern reservedPhrase : this.getReservedPhrase()) {
                char ch = '\u0000';
                Matcher matcher = reservedPhrase.matcher(sql);
                boolean contains = matcher.find();
                if (!contains) continue;
                int reservedPhraseIndex = matcher.start();
                if (reservedPhraseIndex != 0) {
                    ch = sql.charAt(reservedPhraseIndex - 1);
                }
                if (reservedPhraseIndex != 0 && Character.isDefined(ch) && !Character.isWhitespace(ch)) continue;
                matcherContext.matchResult = true;
                matcherContext.start = matcher.start();
                matcherContext.end = matcher.end();
                matcherContext.sqlText = sql;
                return matcherContext;
            }
        }
        matcherContext.matchResult = false;
        return matcherContext;
    }
}

