/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.config.model.MatcherContext;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class SqlNotAllowedToGrantOfSpecificPrivileges
extends AbstractLiquibaseDynamicForecastRule {
    private static final Pattern GRANT_PATTERN = Pattern.compile("grant\\s+(.*?)\\s+(?:on .* )?to\\s+", 32);

    @Override
    public String getName() {
        return "Warn on Grant of Specific Privileges";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "SqlGrantSpecificPrivsWarn";
    }

    private boolean doExecute(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, boolean isRollback) {
        DynamicRuleParameter privilegeList = dynamicRule.getParameter(DynamicRuleParameterEnum.PRIVILEGE_LIST);
        DynamicRuleParameter stripCommentsParam = dynamicRule.getParameter(DynamicRuleParameterEnum.STRIP_COMMENTS);
        Objects.requireNonNull(privilegeList);
        boolean stripComments = false;
        if (stripCommentsParam != null) {
            stripComments = (Boolean)stripCommentsParam.getValue();
        }
        boolean applicable = false;
        String[] privileges = ((String)privilegeList.getValue()).split(",");
        for (Change change : changes) {
            if (!(change instanceof AbstractSQLChange)) continue;
            applicable = true;
            ArrayList<String> forbiddenPrivileges = new ArrayList<String>();
            MatcherContext matcherContext = new MatcherContext();
            for (String privilege : privileges) {
                matcherContext = this.doCheck((AbstractSQLChange)change, privilege, stripComments);
                if (!matcherContext.matchResult) continue;
                forbiddenPrivileges.add("'" + privilege + "'");
            }
            if (forbiddenPrivileges.isEmpty()) continue;
            matcherContext.matchResult = true;
            this.addFailureRuleIteration(changeSet, change, this.getFailureMessage(" contains ", forbiddenPrivileges, changeSet), (AbstractConfigurableRule)dynamicRule, isRollback, matcherContext);
        }
        if (!applicable) {
            this.addNonApplicableRuleIteration(changeSet, String.format("Changeset '%s' not applicable for rule '%s'", changeSet.toString(), dynamicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doExecute(changeSet.getChanges(), changeSet, dynamicRule, false);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dynamicRule) {
        return this.doExecute(changes, changeSet, dynamicRule, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    private MatcherContext doCheck(AbstractSQLChange change, String privilege, boolean stripComments) {
        String capture;
        boolean result;
        MatcherContext matcherContext = new MatcherContext();
        String sql = SqlNotAllowedToGrantOfSpecificPrivileges.getSql(change).toLowerCase();
        if (stripComments) {
            sql = StringUtil.stripComments((String)sql);
        }
        Matcher matcher = GRANT_PATTERN.matcher(sql);
        matcherContext.matchResult = result = matcher.find();
        if (result && (capture = matcher.group(1)) != null) {
            String[] privileges = capture.split(",");
            List foundPrivilege = Arrays.stream(privileges).filter(p -> p.trim().toLowerCase().equals(privilege.toLowerCase().trim().replace("\"", ""))).collect(Collectors.toList());
            boolean bl = matcherContext.matchResult = !foundPrivilege.isEmpty();
            if (matcherContext.matchResult) {
                matcherContext.start = matcher.start();
                matcherContext.end = matcher.end();
                matcherContext.sqlText = sql;
            }
        }
        return matcherContext;
    }

    private String getFailureMessage(String prefix, List<String> privilegeList, ChangeSet changeSet) {
        String message = StringUtil.join(privilegeList, (String)",");
        return "Changeset " + changeSet.getId() + prefix + message;
    }

    @Override
    public String getDescription() {
        return "This check warns a user when changeset includes or generates sql that grants specific privileges to a user or role";
    }

    @Override
    public int getPriority() {
        return 90;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.PRIVILEGE_LIST), new RuleParameter(DynamicRuleParameterEnum.STRIP_COMMENTS, null, null, null, false, true));
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule.SupportedChangesetFormats.UNMODELED;
    }
}

