/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.QuadConsumer;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.dynamic.CustomCheck;
import com.datical.liquibase.ext.checks.output.ChecksOutputUtil;
import com.datical.liquibase.ext.command.checks.ChecksOutput;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksRunJsonOutputHelper;
import com.datical.liquibase.ext.command.checks.EngineResults;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.reports.checks.ChecksRunReportParameters;
import com.datical.liquibase.ext.reports.checks.DatabaseChecksRunInfo;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.command.CommandResultsBuilder;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.plugin.Plugin;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class ChecksRunConsoleOutputHelper {
    private static final String BREAK_STRING = "\n                    ";

    private ChecksRunConsoleOutputHelper() {
    }

    public static SeverityEnum outputChecksResults(CommandResultsBuilder resultsBuilder, EngineResults<ChangeSet> results, EngineResults<DatabaseObject> databaseResults, LazyDatabaseSnapshot lazyDatabaseSnapshot, String url, boolean verbose, List<AbstractLiquibaseRule> rulesInSystem, boolean scopeContainsDatabase, LinkedHashSet<ChecksOutput> checksOutputs, Integer sqlParserFailSeverity, ChecksRunReportParameters checksRunReportParameters, List<String> checksInChain, CheckSettingsConfig checkSettingsConfig) throws IOException {
        AtomicReference<SeverityEnum> maxSeverityEnum = new AtomicReference<SeverityEnum>(SeverityEnum.INFO);
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        int daysTilExpiration = licenseService.daysTilExpiration();
        int totalTriggerCount = 0;
        LinkedHashSet<String> checksSettingsConfigFilenames = results == null ? new LinkedHashSet<String>() : results.getAllChecksSettingsConfigFilenames();
        checksSettingsConfigFilenames.addAll(databaseResults == null ? new LinkedHashSet<String>() : databaseResults.getAllChecksSettingsConfigFilenames());
        checksRunReportParameters.getOperationInfo().setChecksSettingsFiles(new ArrayList<String>(checksSettingsConfigFilenames));
        for (String checkSettingsConfigFilename : checksSettingsConfigFilenames) {
            String headerMessage;
            ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, "Checks-settings File:      " + checkSettingsConfigFilename + System.lineSeparator() + "=====================================================================================" + System.lineSeparator());
            if (results != null && results.getExecutedRules(checkSettingsConfigFilename).isEmpty() && databaseResults != null && databaseResults.getExecutedRules(checkSettingsConfigFilename).isEmpty() && databaseResults.getSkippedBecauseOfLicenceRules(checkSettingsConfigFilename).isEmpty() && results.getSkippedMissingScriptChecks().isEmpty() && databaseResults.getSkippedMissingScriptChecks().isEmpty() && results.getSkippedDisabledCustomChecks().isEmpty() && databaseResults.getSkippedDisabledCustomChecks().isEmpty() && LicenseServiceUtils.isProLicenseValid()) {
                String message = "\nWarning:  No checks were executed\nChangesets Validated:  None\nChecks run against each changeset:  None\n\n";
                Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe(message);
                ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, message);
                resultsBuilder.addResult("statusCode", (Object)0);
                continue;
            }
            if (results != null && ChecksOutput.shouldDisplayIssues(checksOutputs)) {
                totalTriggerCount += ChecksRunConsoleOutputHelper.outputChangelogChecksResultsSummary(results.getResults(), resultsBuilder, maxSeverityEnum, checksOutputs, sqlParserFailSeverity, checksRunReportParameters, checkSettingsConfigFilename, checksInChain, checkSettingsConfig);
            }
            if (databaseResults != null && ChecksOutput.shouldDisplayIssues(checksOutputs)) {
                totalTriggerCount += ChecksRunConsoleOutputHelper.outputDatabaseChecksResultsSummary(databaseResults.getResults(), resultsBuilder, maxSeverityEnum, checksOutputs, sqlParserFailSeverity, checksRunReportParameters, checkSettingsConfigFilename, checksInChain, checkSettingsConfig);
            }
            checksRunReportParameters.getOperationInfo().setChecksTriggered(totalTriggerCount);
            boolean proLicenseValid = LicenseServiceUtils.isProLicenseValid();
            if (proLicenseValid && results != null && (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.validated))) {
                ChecksRunConsoleOutputHelper.outputChangesetsValidatedList(results.getResults(), resultsBuilder);
            }
            if (scopeContainsDatabase && (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.validated))) {
                ChecksRunConsoleOutputHelper.outputDatabaseObjectsValidatedList(lazyDatabaseSnapshot, verbose, resultsBuilder, checksRunReportParameters);
            }
            if (results != null && (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.checksrun))) {
                ChecksRunConsoleOutputHelper.printListOfChecksWithInlineShortNames(new ArrayList<RuleCombination>(results.getExecutedRules()), resultsBuilder, "Checks run against each changeset:", checksInChain, rulesInSystem, msg -> checksRunReportParameters.getChangelogChecksRunInfo().getChecksRun().add((String)msg), checkSettingsConfigFilename, ScopeEnum.CHANGELOG);
            }
            if (databaseResults != null && scopeContainsDatabase && (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.checksrun))) {
                ChecksRunConsoleOutputHelper.printListOfChecksWithInlineShortNames(new ArrayList<RuleCombination>(databaseResults.getExecutedRules()), resultsBuilder, String.format("Checks run against database %s:", url), checksInChain, rulesInSystem, msg -> checksRunReportParameters.getDatabaseChecksRunInfo().getChecksRun().add((String)msg), checkSettingsConfigFilename, ScopeEnum.DATABASE);
            }
            if (results != null && !results.getResults().isEmpty() && (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.sqlparserfails))) {
                ChecksRunConsoleOutputHelper.printChangeSetsWithSkippedChecks(resultsBuilder, results.getResults(), msg -> checksRunReportParameters.getChangelogChecksRunInfo().getChecksSkippedSqlParse().add((String)msg), checkSettingsConfigFilename);
            }
            if (results != null) {
                ChecksRunConsoleOutputHelper.printListOfChecksWithInlineShortNames(results.getSkippedBecauseOfLicenceRules(), resultsBuilder, "Changelog Checks Skipped, No Pro License Found:", checksInChain, rulesInSystem, null, checkSettingsConfigFilename, ScopeEnum.CHANGELOG);
            }
            if (databaseResults != null) {
                ChecksRunConsoleOutputHelper.printListOfChecksWithInlineShortNames(databaseResults.getSkippedBecauseOfLicenceRules(), resultsBuilder, "Database Checks Skipped Due to Missing License:", checksInChain, rulesInSystem, null, checkSettingsConfigFilename, ScopeEnum.DATABASE);
            }
            if (results != null && (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.skippedchecks))) {
                ChecksRunConsoleOutputHelper.printChangeSetsWithInvalidChangesetTypeFailures(resultsBuilder, results.getResults(), verbose, msg -> checksRunReportParameters.getChangelogChecksRunInfo().getChecksSkippedUnsupportedType().add((String)msg), checkSettingsConfigFilename);
            }
            if (results != null && (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.nonapplicablechecks))) {
                ChecksRunConsoleOutputHelper.printChangeSetsWithNonApplicableChangesetTypeFailures(resultsBuilder, results.getResults(), verbose, msg -> checksRunReportParameters.getChangelogChecksRunInfo().getChecksSkippedUnsupportedType().add((String)msg), checkSettingsConfigFilename);
                ChecksRunConsoleOutputHelper.printChangesetsWithDisabledCustomChecks(resultsBuilder, results.getResults(), verbose, checkSettingsConfigFilename);
            }
            if (results != null) {
                ChecksRunConsoleOutputHelper.printChangesetsWithoutScript(resultsBuilder, results.getResults(), verbose, checkSettingsConfigFilename);
                ChecksRunConsoleOutputHelper.printChangelogScriptsWithErrors(resultsBuilder, results.getResults(), verbose, checkSettingsConfigFilename);
            }
            if (databaseResults != null && scopeContainsDatabase && (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.nonapplicablechecks))) {
                ChecksRunConsoleOutputHelper.printDatabaseObjectsWithNonApplicableChangesetTypeFailures(resultsBuilder, databaseResults.getResults(), verbose, msg -> checksRunReportParameters.getChangelogChecksRunInfo().getChecksSkippedUnsupportedType().add((String)msg), checkSettingsConfigFilename);
                ChecksRunConsoleOutputHelper.printDatabaseObjectsDisabledCustomChecks(resultsBuilder, databaseResults.getResults(), verbose, checkSettingsConfigFilename);
                ChecksRunConsoleOutputHelper.printDatabaseObjectsWithoutScript(resultsBuilder, databaseResults.getResults(), verbose, checkSettingsConfigFilename);
                ChecksRunConsoleOutputHelper.printDatabaseScriptsWithErrors(resultsBuilder, databaseResults.getResults(), verbose, checkSettingsConfigFilename);
            }
            if (results != null && !results.getSkippedBecauseOfScope().isEmpty()) {
                headerMessage = "Changelog Chained checks skipped because one or more checks was not in scope";
                ChecksRunConsoleOutputHelper.printListOfChecksSkippedBecauseOfScope(results.getSkippedBecauseOfScope(), resultsBuilder, headerMessage);
            }
            if (databaseResults == null || databaseResults.getSkippedBecauseOfScope().isEmpty()) continue;
            headerMessage = "Database Chained checks skipped because one or more checks was not in scope";
            ChecksRunConsoleOutputHelper.printListOfChecksSkippedBecauseOfScope(databaseResults.getSkippedBecauseOfScope(), resultsBuilder, headerMessage);
        }
        if (checksSettingsConfigFilenames.isEmpty()) {
            if (results != null) {
                ChecksRunConsoleOutputHelper.calculateMaxSeverity(results.getResults(), maxSeverityEnum, sqlParserFailSeverity, checksInChain);
            }
            if (databaseResults != null) {
                ChecksRunConsoleOutputHelper.calculateMaxSeverity(databaseResults.getResults(), maxSeverityEnum, sqlParserFailSeverity, checksInChain);
            }
        }
        if (daysTilExpiration < 0) {
            ChecksRunConsoleOutputHelper.sendMessageToUi(licenseService.getLicenseInfo());
        }
        ChecksRunConsoleOutputHelper.sendMessageToUi("INFO: Customize this output with the 'checks-output' property. See list of options with 'liquibase checks run --help' or https://docs.liquibase.com/policy-checks");
        ChecksRunConsoleOutputHelper.sendMessageToUi("INFO: The return code of all SQL Parser failures can be customized by setting the --sql-parser-fail-severity/LIQUIBASE_COMMAND_CHECKS_RUN_SQL_PARSER_FAIL_SEVERITY property, including setting it to '0' to prevent job interruptions. Learn more at https://docs.liquibase.com/policy-checks");
        return maxSeverityEnum.get();
    }

    private static <T> void calculateMaxSeverity(LinkedHashMap<T, LiquibaseQualityCheckResult> results, AtomicReference<SeverityEnum> maxSeverityEnum, Integer sqlParserFailSeverity, List<String> checksInChain) {
        for (Map.Entry<T, LiquibaseQualityCheckResult> resultEntry : results.entrySet()) {
            List<LiquibaseRuleResult> ruleResults = resultEntry.getValue().getRuleResults();
            for (LiquibaseRuleResult ruleResult : ruleResults) {
                if (ruleResult.hasRuleSucceeded() || ChecksRunJsonOutputHelper.isPartOfAChain(ruleResult.getRuleShortName(false), checksInChain)) continue;
                for (RuleIteration ruleIteration : ruleResult.getExecutions()) {
                    SeverityEnum severityEnum;
                    if (ChecksRunConsoleOutputHelper.isSkippable(ruleIteration) || (severityEnum = ruleResult.getRuleSeverity(sqlParserFailSeverity)).getValue() <= maxSeverityEnum.get().getValue()) continue;
                    maxSeverityEnum.set(severityEnum);
                }
            }
        }
    }

    private static boolean isSkippable(RuleIteration ruleIteration) {
        return ruleIteration.isSuccess() || ruleIteration.getMessages().isEmpty() || ruleIteration.getFailureReason() == RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE;
    }

    private static void printListOfChecksSkippedBecauseOfScope(Map<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedBecauseOfScope, CommandResultsBuilder resultsBuilder, String headerMessage) throws IOException {
        if (skippedBecauseOfScope.isEmpty()) {
            return;
        }
        StringBuilder checksSkippedMessage = new StringBuilder(headerMessage);
        checksSkippedMessage.append(System.lineSeparator());
        for (Map.Entry<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedRule : skippedBecauseOfScope.entrySet()) {
            StringBuilder skippedRuleMessage = new StringBuilder();
            skippedRuleMessage.append("  ");
            skippedRuleMessage.append(skippedRule.getKey().getName());
            skippedRuleMessage.append(" (Short names: ");
            skippedRuleMessage.append(skippedRule.getKey().getShortName());
            skippedRuleMessage.append(")");
            skippedRuleMessage.append(System.lineSeparator());
            skippedRuleMessage.append("    Logic conditional:  ");
            skippedRuleMessage.append(((DynamicRule)skippedRule.getKey()).getParameter(DynamicRuleParameterEnum.LOGIC_CONDITIONAL).getValue());
            skippedRuleMessage.append(System.lineSeparator());
            skippedRuleMessage.append("    Skipped checks:  ");
            List skippedRuleNames = skippedRule.getValue().stream().map(AbstractConfigurableRule::getShortName).collect(Collectors.toList());
            skippedRuleMessage.append(StringUtils.join(skippedRuleNames, (String)","));
            checksSkippedMessage.append((CharSequence)skippedRuleMessage);
        }
        checksSkippedMessage.append(System.lineSeparator());
        ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, checksSkippedMessage + System.lineSeparator());
    }

    private static void printListOfChecksWithInlineShortNames(List<RuleCombination> executedRules, CommandResultsBuilder resultsBuilder, String headerMessage, List<String> checksInChains, List<AbstractLiquibaseRule> rulesInSystem, Consumer<String> messageCallback, String checkSettingsConfigFilename, ScopeEnum scope) throws IOException {
        if (!executedRules.isEmpty()) {
            Map collectedRules = executedRules.stream().filter(rc -> rc.configurableRule.getFileInfo().getFilename().equals(checkSettingsConfigFilename)).filter(rc -> !ChecksRunJsonOutputHelper.isPartOfAChain(rc.configurableRule.getShortName(), checksInChains)).filter(rc -> ChecksRunConsoleOutputHelper.hasCustomCheckFailures(scope, rc)).collect(Collectors.groupingBy(ruleCombination -> ruleCombination.rule.getName(), TreeMap::new, Collectors.mapping(ruleCombination -> ruleCombination.configurableRule.getShortName(rulesInSystem), Collectors.toList())));
            StringBuilder checksRanMessage = new StringBuilder(headerMessage);
            checksRanMessage.append(System.lineSeparator());
            for (Map.Entry executedRule : collectedRules.entrySet()) {
                StringBuilder ranMessage = new StringBuilder();
                ranMessage.append("  ");
                ranMessage.append((String)executedRule.getKey());
                ranMessage.append(" (Short names: ");
                ranMessage.append(StringUtil.join((Collection)((Collection)executedRule.getValue()), (String)", "));
                ranMessage.append(")");
                ranMessage.append(System.lineSeparator());
                if (messageCallback != null) {
                    messageCallback.accept(ranMessage.toString());
                }
                checksRanMessage.append((CharSequence)ranMessage);
            }
            ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, checksRanMessage + System.lineSeparator());
        }
    }

    private static boolean hasCustomCheckFailures(ScopeEnum scope, RuleCombination ruleCombination) {
        if (ruleCombination.getRule() instanceof CustomCheck) {
            boolean correctScope = CustomCheck.isCorrectChecksScope((DynamicRule)ruleCombination.getConfigurableRule(), scope);
            boolean actuallyRan = true;
            if (scope == ScopeEnum.DATABASE) {
                actuallyRan = ruleCombination.getRule().getDatabaseResults().values().stream().noneMatch(liquibaseRuleResult -> liquibaseRuleResult.hasScriptMissingFailures() || liquibaseRuleResult.hasCustomScriptsDisabledFailures());
            }
            return correctScope && actuallyRan;
        }
        return true;
    }

    private static void outputChangesetsValidatedList(LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> results, CommandResultsBuilder resultsBuilder) throws IOException {
        if (results != null && !results.isEmpty()) {
            Map changeSetResultsGroupedByFilepath = results.entrySet().stream().collect(Collectors.groupingBy(changeSet -> ((ChangeSet)changeSet.getKey()).getFilePath(), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
            for (Map.Entry changeSetResults : changeSetResultsGroupedByFilepath.entrySet()) {
                String changeSetFilepath = changeSetResults.getKey();
                StringBuilder changeSetsValidatedMessage = new StringBuilder("Changesets Validated: in " + changeSetFilepath + System.lineSeparator());
                for (ChangeSet changeSet2 : changeSetResults.getValue()) {
                    changeSetsValidatedMessage.append("  ID: ");
                    changeSetsValidatedMessage.append(changeSet2.getId());
                    changeSetsValidatedMessage.append("; Author: ");
                    changeSetsValidatedMessage.append(changeSet2.getAuthor());
                    changeSetsValidatedMessage.append(System.lineSeparator());
                }
                ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, changeSetsValidatedMessage + System.lineSeparator());
            }
        }
    }

    private static void printChangeSetsWithSkippedChecks(CommandResultsBuilder resultsBuilder, LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> results, Consumer<String> messageCallback, String checkSettingsConfigFilename) throws IOException {
        if (results != null && !results.isEmpty()) {
            Map<String, List<Map.Entry>> unparseableChangesetsGroupedByFilePath = results.entrySet().stream().filter(e -> !((LiquibaseQualityCheckResult)e.getValue()).getRuleNamesSkippedDueToUnparseableSql().isEmpty()).collect(Collectors.groupingBy(changeSet -> ((ChangeSet)changeSet.getKey()).getFilePath()));
            for (Map.Entry<String, List<Map.Entry>> unparseableChangesetGroupedByFilepath : unparseableChangesetsGroupedByFilePath.entrySet()) {
                String changeSetFilepath = unparseableChangesetGroupedByFilepath.getKey();
                StringBuilder changeSetsValidatedMessage = new StringBuilder("Changeset SQL not parsed in " + changeSetFilepath + " (please review them directly):" + System.lineSeparator());
                for (Map.Entry changeSetResult : unparseableChangesetGroupedByFilepath.getValue()) {
                    String changeSetId = ((ChangeSet)changeSetResult.getKey()).getId();
                    String changeSetAuthor = ((ChangeSet)changeSetResult.getKey()).getAuthor();
                    List skippedRules = ((LiquibaseQualityCheckResult)changeSetResult.getValue()).getRulesSkippedDueToUnparseableSql().stream().filter(lrr -> lrr.getConfigurableRule().getFileInfo().getFilename().equals(checkSettingsConfigFilename)).map(liquibaseRuleResult -> liquibaseRuleResult.getRuleShortName(false)).collect(Collectors.toList());
                    StringBuilder message = new StringBuilder();
                    message.append("  ID: ");
                    message.append(changeSetId);
                    message.append("; Author: ");
                    message.append(changeSetAuthor);
                    message.append(" - Skipped by: ");
                    message.append(StringUtil.join(skippedRules, (String)", "));
                    message.append(System.lineSeparator());
                    changeSetsValidatedMessage.append((CharSequence)message);
                    if (messageCallback == null) continue;
                    messageCallback.accept(message.toString());
                }
                ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, changeSetsValidatedMessage + System.lineSeparator());
            }
        }
    }

    private static void printChangeSetsWithInvalidChangesetTypeFailures(CommandResultsBuilder resultsBuilder, LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> results, boolean verbose, Consumer<String> messageCallback, String checkSettingsConfigFilename) throws IOException {
        if (results != null && !results.isEmpty()) {
            TreeMap<String, CompiledResult<ChangeSet>> compiledResults = new TreeMap<String, CompiledResult<ChangeSet>>();
            for (Map.Entry<ChangeSet, LiquibaseQualityCheckResult> changeSetEntry : results.entrySet()) {
                ChangeSet changeSet = changeSetEntry.getKey();
                LiquibaseQualityCheckResult liquibaseQualityCheckResult = changeSetEntry.getValue();
                List<LiquibaseRuleResult> invalidChangelogFileTypeFailures = liquibaseQualityCheckResult.getInvalidChangesetFileTypeFailures();
                for (LiquibaseRuleResult invalidChangelogFileTypeFailure : invalidChangelogFileTypeFailures) {
                    try {
                        if (!invalidChangelogFileTypeFailure.getConfigurableRule().getFileInfo().getFilename().equals(checkSettingsConfigFilename)) {
                            continue;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (!invalidChangelogFileTypeFailure.hasInvalidChangelogFileTypeFailures()) continue;
                    ChecksRunConsoleOutputHelper.compileResult(invalidChangelogFileTypeFailure, compiledResults, changeSet);
                }
            }
            if (compiledResults.isEmpty()) {
                return;
            }
            int maxNumberOfChangesetsToPrint = verbose ? Integer.MAX_VALUE : 3;
            StringBuilder sb = new StringBuilder("Changelog Checks Skipped Due to unsupported changeset type for this check:" + System.lineSeparator());
            ChecksRunConsoleOutputHelper.createSkippedMessage(resultsBuilder, messageCallback, compiledResults, maxNumberOfChangesetsToPrint, sb);
        }
    }

    private static void compileResult(LiquibaseRuleResult ruleResult, Map<String, CompiledResult<ChangeSet>> compiledResults, ChangeSet changeSet) {
        String ruleName = ruleResult.getRule().getName();
        String ruleShortName = ruleResult.getRuleShortName(false);
        if (compiledResults.containsKey(ruleName)) {
            CompiledResult<ChangeSet> compiledResult = compiledResults.get(ruleName);
            compiledResult.shortnames.add(ruleShortName);
            compiledResult.entities.add(changeSet);
        } else {
            LinkedHashSet<String> shortnames = new LinkedHashSet<String>();
            shortnames.add(ruleShortName);
            LinkedHashSet<ChangeSet> changeSets = new LinkedHashSet<ChangeSet>();
            changeSets.add(changeSet);
            compiledResults.put(ruleName, new CompiledResult(shortnames, changeSets));
        }
    }

    private static void compileResult(LiquibaseRuleResult ruleResult, Map<String, CompiledResult<DatabaseObject>> compiledResults, DatabaseObject databaseObject) {
        String ruleName = ruleResult.getRule().getName();
        String ruleShortName = ruleResult.getRuleShortName(false);
        if (compiledResults.containsKey(ruleName)) {
            CompiledResult<DatabaseObject> compiledResult = compiledResults.get(ruleName);
            compiledResult.entities.add(databaseObject);
            compiledResult.shortnames.add(ruleShortName);
        } else {
            LinkedHashSet<String> shortnames = new LinkedHashSet<String>();
            shortnames.add(ruleShortName);
            LinkedHashSet<DatabaseObject> changeSets = new LinkedHashSet<DatabaseObject>();
            changeSets.add(databaseObject);
            compiledResults.put(ruleName, new CompiledResult(shortnames, changeSets));
        }
    }

    private static void printChangeSetsWithNonApplicableChangesetTypeFailures(CommandResultsBuilder resultsBuilder, LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> results, boolean verbose, Consumer<String> messageCallback, String checkSettingsConfigFilename) throws IOException {
        if (results == null || results.isEmpty()) {
            return;
        }
        TreeMap<String, CompiledResult<ChangeSet>> compiledResults = new TreeMap<String, CompiledResult<ChangeSet>>();
        for (Map.Entry<ChangeSet, LiquibaseQualityCheckResult> changeSetEntry : results.entrySet()) {
            ChangeSet changeSet = changeSetEntry.getKey();
            LiquibaseQualityCheckResult liquibaseQualityCheckResult = changeSetEntry.getValue();
            List nonApplicables = liquibaseQualityCheckResult.getRuleResults().stream().filter(rr -> rr.getConfigurableRule() instanceof DynamicRule && ChecksRunConsoleOutputHelper.isInSameFile(rr, checkSettingsConfigFilename) && ((DynamicRule)rr.getConfigurableRule()).isChained() && rr.getExecutions().get(0).getFailureReason() == RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE).collect(Collectors.toList());
            if (nonApplicables.isEmpty()) continue;
            LiquibaseRuleResult nonApplicable = (LiquibaseRuleResult)nonApplicables.get(0);
            ChecksRunConsoleOutputHelper.compileResult(nonApplicable, compiledResults, changeSet);
        }
        if (compiledResults.isEmpty()) {
            return;
        }
        int maxNumberOfChangesetsToPrint = verbose ? Integer.MAX_VALUE : 3;
        StringBuilder sb = new StringBuilder("Changelog Checks Skipped Due to unsupported changeset type(s) for this check:" + System.lineSeparator());
        ChecksRunConsoleOutputHelper.createSkippedMessage(resultsBuilder, messageCallback, compiledResults, maxNumberOfChangesetsToPrint, sb);
    }

    private static void printChangesetsWithoutScript(CommandResultsBuilder resultsBuilder, LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> results, boolean verbose, String checkSettingsConfigFilename) throws IOException {
        if (results != null && !results.isEmpty()) {
            TreeMap<String, CompiledResult<ChangeSet>> compiledResults = new TreeMap<String, CompiledResult<ChangeSet>>();
            for (Map.Entry<ChangeSet, LiquibaseQualityCheckResult> entry : results.entrySet()) {
                entry.getValue().getRuleResults().stream().filter(ruleResult -> ruleResult.getConfigurableRule() instanceof DynamicRule && ChecksRunConsoleOutputHelper.isInSameFile(ruleResult, checkSettingsConfigFilename) && ruleResult.getExecutions().stream().anyMatch(execution -> execution.getFailureReason() == RuleIteration.FailureReason.SCRIPT_NOT_FOUND)).forEach(nonApplicable -> ChecksRunConsoleOutputHelper.compileResult(nonApplicable, compiledResults, (ChangeSet)entry.getKey()));
            }
            if (!compiledResults.isEmpty()) {
                StringBuilder sb = new StringBuilder(String.format("WARNING: The following enabled custom changelog checks were not run because the script could not be found or they contain SCRIPT_PATH not valid to 'checks-scripts-path' property: %n", new Object[0]));
                ChecksRunConsoleOutputHelper.createSkippedMessage(resultsBuilder, null, compiledResults, verbose ? Integer.MAX_VALUE : 3, sb);
            }
        }
    }

    private static void printChangelogScriptsWithErrors(CommandResultsBuilder resultsBuilder, LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> results, boolean verbose, String checkSettingsConfigFilename) throws IOException {
        if (results != null && !results.isEmpty()) {
            TreeMap<String, CompiledResult<ChangeSet>> compiledResults = new TreeMap<String, CompiledResult<ChangeSet>>();
            for (Map.Entry<ChangeSet, LiquibaseQualityCheckResult> entry : results.entrySet()) {
                entry.getValue().getRuleResults().stream().filter(ruleResult -> ruleResult.getConfigurableRule() instanceof DynamicRule && ChecksRunConsoleOutputHelper.isInSameFile(ruleResult, checkSettingsConfigFilename) && ruleResult.getExecutions().stream().anyMatch(execution -> execution.getFailureReason() == RuleIteration.FailureReason.SCRIPT_HAS_ERROR)).forEach(nonApplicable -> ChecksRunConsoleOutputHelper.compileResult(nonApplicable, compiledResults, (ChangeSet)entry.getKey()));
            }
            if (!compiledResults.isEmpty()) {
                StringBuilder sb = new StringBuilder(String.format("WARNING: The following enabled custom changelog checks were not run because the script had errors:%n", new Object[0]));
                ChecksRunConsoleOutputHelper.createSkippedMessage(resultsBuilder, null, compiledResults, verbose ? Integer.MAX_VALUE : 3, sb);
            }
        }
    }

    private static void printChangesetsWithDisabledCustomChecks(CommandResultsBuilder resultsBuilder, LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> results, boolean verbose, String checkSettingsConfigFilename) throws IOException {
        if (results != null && !results.isEmpty()) {
            TreeMap<String, CompiledResult<ChangeSet>> compiledResults = new TreeMap<String, CompiledResult<ChangeSet>>();
            for (Map.Entry<ChangeSet, LiquibaseQualityCheckResult> entry : results.entrySet()) {
                entry.getValue().getRuleResults().stream().filter(ruleResult -> ruleResult.getConfigurableRule() instanceof DynamicRule && ChecksRunConsoleOutputHelper.isInSameFile(ruleResult, checkSettingsConfigFilename) && ruleResult.getExecutions().stream().anyMatch(execution -> execution.getFailureReason() == RuleIteration.FailureReason.CUSTOM_CHECKS_DISABLED)).forEach(nonApplicable -> ChecksRunConsoleOutputHelper.compileResult(nonApplicable, compiledResults, (ChangeSet)entry.getKey()));
            }
            if (!compiledResults.isEmpty()) {
                StringBuilder sb = new StringBuilder("WARNING: The following enabled custom checks were not run because --checks-scripts-enabled must be set to 'true':\n");
                ChecksRunConsoleOutputHelper.createSkippedMessage(resultsBuilder, null, compiledResults, verbose ? Integer.MAX_VALUE : 3, sb);
            }
        }
    }

    private static void printDatabaseObjectsWithoutScript(CommandResultsBuilder resultsBuilder, LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> results, boolean verbose, String checkSettingsConfigFilename) throws IOException {
        if (results != null && !results.isEmpty()) {
            TreeMap<String, CompiledResult<DatabaseObject>> compiledResults = new TreeMap<String, CompiledResult<DatabaseObject>>();
            for (Map.Entry<DatabaseObject, LiquibaseQualityCheckResult> entry : results.entrySet()) {
                entry.getValue().getRuleResults().stream().filter(ruleResult -> ruleResult.getConfigurableRule() instanceof DynamicRule && ChecksRunConsoleOutputHelper.isInSameFile(ruleResult, checkSettingsConfigFilename) && ruleResult.getExecutions().stream().anyMatch(execution -> execution.getFailureReason() == RuleIteration.FailureReason.SCRIPT_NOT_FOUND)).forEach(nonApplicable -> ChecksRunConsoleOutputHelper.compileResult(nonApplicable, compiledResults, (DatabaseObject)entry.getKey()));
            }
            if (!compiledResults.isEmpty()) {
                StringBuilder sb = new StringBuilder("WARNING: The following enabled custom database checks were not run because the script could not be found or they contain SCRIPT_PATH not valid to 'checks-scripts-path' property: \n");
                ChecksRunConsoleOutputHelper.createDatabaseSkippedMessage(resultsBuilder, null, compiledResults, verbose ? Integer.MAX_VALUE : 3, sb);
            }
        }
    }

    private static void printDatabaseScriptsWithErrors(CommandResultsBuilder resultsBuilder, LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> results, boolean verbose, String checkSettingsConfigFilename) throws IOException {
        if (results != null && !results.isEmpty()) {
            TreeMap<String, CompiledResult<DatabaseObject>> compiledResults = new TreeMap<String, CompiledResult<DatabaseObject>>();
            for (Map.Entry<DatabaseObject, LiquibaseQualityCheckResult> entry : results.entrySet()) {
                entry.getValue().getRuleResults().stream().filter(ruleResult -> ruleResult.getConfigurableRule() instanceof DynamicRule && ChecksRunConsoleOutputHelper.isInSameFile(ruleResult, checkSettingsConfigFilename) && ruleResult.getExecutions().stream().anyMatch(execution -> execution.getFailureReason() == RuleIteration.FailureReason.SCRIPT_HAS_ERROR)).forEach(nonApplicable -> ChecksRunConsoleOutputHelper.compileResult(nonApplicable, compiledResults, (DatabaseObject)entry.getKey()));
            }
            if (!compiledResults.isEmpty()) {
                StringBuilder sb = new StringBuilder(String.format("WARNING: The following enabled custom database checks were not run because the script had errors:%n", new Object[0]));
                ChecksRunConsoleOutputHelper.createDatabaseSkippedMessage(resultsBuilder, null, compiledResults, verbose ? Integer.MAX_VALUE : 3, sb);
            }
        }
    }

    private static void printDatabaseObjectsDisabledCustomChecks(CommandResultsBuilder resultsBuilder, LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> results, boolean verbose, String checkSettingsConfigFilename) throws IOException {
        if (results != null && !results.isEmpty()) {
            TreeMap<String, CompiledResult<DatabaseObject>> compiledResults = new TreeMap<String, CompiledResult<DatabaseObject>>();
            for (Map.Entry<DatabaseObject, LiquibaseQualityCheckResult> entry : results.entrySet()) {
                entry.getValue().getRuleResults().stream().filter(ruleResult -> ruleResult.getConfigurableRule() instanceof DynamicRule && ChecksRunConsoleOutputHelper.isInSameFile(ruleResult, checkSettingsConfigFilename) && ruleResult.getExecutions().stream().anyMatch(execution -> execution.getFailureReason() == RuleIteration.FailureReason.CUSTOM_CHECKS_DISABLED)).forEach(nonApplicable -> ChecksRunConsoleOutputHelper.compileResult(nonApplicable, compiledResults, (DatabaseObject)entry.getKey()));
            }
            if (!compiledResults.isEmpty()) {
                StringBuilder sb = new StringBuilder("WARNING: The following enabled custom checks were not run because --checks-scripts-enabled must be set to 'true':\n");
                ChecksRunConsoleOutputHelper.createDatabaseSkippedMessage(resultsBuilder, null, compiledResults, verbose ? Integer.MAX_VALUE : 3, sb);
            }
        }
    }

    private static void printDatabaseObjectsWithNonApplicableChangesetTypeFailures(CommandResultsBuilder resultsBuilder, LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> results, boolean verbose, Consumer<String> messageCallback, String checkSettingsConfigFilename) throws IOException {
        if (results == null || results.isEmpty()) {
            return;
        }
        TreeMap<String, CompiledResult<DatabaseObject>> compiledResults = new TreeMap<String, CompiledResult<DatabaseObject>>();
        for (Map.Entry<DatabaseObject, LiquibaseQualityCheckResult> databaseObjectEntry : results.entrySet()) {
            DatabaseObject databaseObject = databaseObjectEntry.getKey();
            LiquibaseQualityCheckResult liquibaseQualityCheckResult = databaseObjectEntry.getValue();
            List nonApplicables = liquibaseQualityCheckResult.getRuleResults().stream().filter(rr -> rr.getConfigurableRule() instanceof DynamicRule && ChecksRunConsoleOutputHelper.isInSameFile(rr, checkSettingsConfigFilename) && ((DynamicRule)rr.getConfigurableRule()).isChained() && rr.getExecutions().get(0).getFailureReason() == RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE).collect(Collectors.toList());
            if (nonApplicables.isEmpty()) continue;
            LiquibaseRuleResult nonApplicable = (LiquibaseRuleResult)nonApplicables.get(0);
            ChecksRunConsoleOutputHelper.compileResult(nonApplicable, compiledResults, databaseObject);
        }
        if (compiledResults.isEmpty()) {
            return;
        }
        int maxNumberOfEntitiesToPrint = verbose ? Integer.MAX_VALUE : 3;
        StringBuilder sb = new StringBuilder("Database Checks Skipped Due to non-applicable object(s) for this check:" + System.lineSeparator());
        ChecksRunConsoleOutputHelper.createDatabaseSkippedMessage(resultsBuilder, messageCallback, compiledResults, maxNumberOfEntitiesToPrint, sb);
    }

    private static void createDatabaseSkippedMessage(CommandResultsBuilder resultsBuilder, Consumer<String> messageCallback, Map<String, CompiledResult<DatabaseObject>> compiledResults, int maxNumberOfChangesetsToPrint, StringBuilder sb) throws IOException {
        for (Map.Entry<String, CompiledResult<DatabaseObject>> stringMyObjectEntry : compiledResults.entrySet()) {
            StringBuilder message = new StringBuilder();
            message.append("  ");
            message.append(stringMyObjectEntry.getKey());
            message.append(" (Short names: ");
            CompiledResult<DatabaseObject> value = stringMyObjectEntry.getValue();
            message.append(StringUtil.join(value.shortnames, (String)", "));
            message.append(") skipped for:");
            message.append(System.lineSeparator());
            if (messageCallback != null) {
                messageCallback.accept(message + StringUtil.join(value.entities, (String)", ", obj -> {
                    DatabaseObject databaseObject = (DatabaseObject)obj;
                    return databaseObject.getName() + ":" + databaseObject.getObjectTypeName();
                }));
            }
            message.append(StringUtil.join((Collection)value.entities.stream().limit(maxNumberOfChangesetsToPrint).collect(Collectors.toList()), (String)("," + System.lineSeparator()), obj -> {
                DatabaseObject databaseObject = (DatabaseObject)obj;
                return "    " + databaseObject.getName() + ":" + databaseObject.getObjectTypeName();
            }));
            message.append(System.lineSeparator());
            if (value.entities.size() > maxNumberOfChangesetsToPrint) {
                int numSkippedDatabaseObjects = value.entities.size() - maxNumberOfChangesetsToPrint;
                boolean pluralized = numSkippedDatabaseObjects > 1;
                message.append("    (See ").append(numSkippedDatabaseObjects).append(" more object").append(pluralized ? "s" : "").append(" by setting command argument --verbose)");
                message.append(System.lineSeparator());
            }
            sb.append((CharSequence)message);
        }
        ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, sb + System.lineSeparator());
    }

    private static void createSkippedMessage(CommandResultsBuilder resultsBuilder, Consumer<String> messageCallback, Map<String, CompiledResult<ChangeSet>> compiledResults, int maxNumberOfChangesetsToPrint, StringBuilder sb) throws IOException {
        for (Map.Entry<String, CompiledResult<ChangeSet>> stringMyObjectEntry : compiledResults.entrySet()) {
            StringBuilder message = new StringBuilder();
            message.append("  ");
            message.append(stringMyObjectEntry.getKey());
            message.append(" (Short names: ");
            CompiledResult<ChangeSet> value = stringMyObjectEntry.getValue();
            message.append(StringUtil.join(value.shortnames, (String)", "));
            message.append(") skipped for:");
            message.append(System.lineSeparator());
            if (messageCallback != null) {
                messageCallback.accept(message + StringUtil.join(value.entities, (String)", ", obj -> {
                    ChangeSet changeSet = (ChangeSet)obj;
                    return changeSet.getId() + ":" + changeSet.getAuthor();
                }));
            }
            message.append(StringUtil.join((Collection)value.entities.stream().limit(maxNumberOfChangesetsToPrint).collect(Collectors.toList()), (String)("," + System.lineSeparator()), obj -> {
                ChangeSet changeSet = (ChangeSet)obj;
                return "    " + changeSet.getId() + ":" + changeSet.getAuthor();
            }));
            message.append(System.lineSeparator());
            if (value.entities.size() > maxNumberOfChangesetsToPrint) {
                int numSkippedChangesets = value.entities.size() - maxNumberOfChangesetsToPrint;
                boolean pluralized = numSkippedChangesets > 1;
                message.append("    (See ").append(numSkippedChangesets).append(" more changeset").append(pluralized ? "s" : "").append(" by setting command argument --verbose)");
                message.append(System.lineSeparator());
            }
            sb.append((CharSequence)message);
        }
        ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, sb + System.lineSeparator());
    }

    private static boolean isInSameFile(LiquibaseRuleResult rr, String checkSettingsConfigFilename) {
        if (rr.getConfigurableRule() == null || rr.getConfigurableRule().getFileInfo() == null || rr.getConfigurableRule().getFileInfo().getFilename() == null) {
            return false;
        }
        return rr.getConfigurableRule().getFileInfo().getFilename().equals(checkSettingsConfigFilename);
    }

    private static void outputDatabaseObjectsValidatedList(LazyDatabaseSnapshot lazyDatabaseSnapshot, boolean verbose, CommandResultsBuilder resultsBuilder, ChecksRunReportParameters checksRunReportParameters) throws IOException {
        if (lazyDatabaseSnapshot == null) {
            return;
        }
        StringBuilder databaseObjectsValidatedMessage = new StringBuilder("Database objects Validated:");
        databaseObjectsValidatedMessage.append(System.lineSeparator());
        try {
            Set typesSet = lazyDatabaseSnapshot.getSnapshot().getSnapshotControl().getTypesToInclude();
            ArrayList typesToInclude = new ArrayList(typesSet);
            Collections.sort(typesToInclude, new DatabaseObjectTypeSortComparator());
            for (Class includeType : typesToInclude) {
                Set databaseObjectsSet = lazyDatabaseSnapshot.getSnapshot().get(includeType);
                if (databaseObjectsSet.isEmpty()) continue;
                String objectTypeName = includeType.getSimpleName();
                int count = databaseObjectsSet.size();
                String outputLine = String.format("     %-20s: %d%n", StringUtil.upperCaseFirst((String)objectTypeName), count);
                if (checksRunReportParameters != null) {
                    checksRunReportParameters.getDatabaseChecksRunInfo().getDatabaseObjectsValidated().add(outputLine);
                }
                databaseObjectsValidatedMessage.append(outputLine);
                Database database = lazyDatabaseSnapshot.getDatabase();
                ArrayList databaseObjects = new ArrayList(databaseObjectsSet);
                Collections.sort(databaseObjects, new DatabaseObjectSortComparator());
                ArrayList<String> databaseObjectNames = new ArrayList<String>();
                for (DatabaseObject databaseObject : databaseObjects) {
                    if (database.isLiquibaseObject(databaseObject)) continue;
                    String databaseObjectName = DatabaseObjectUtils.buildFullyQualifiedName(databaseObject);
                    databaseObjectNames.add(databaseObjectName);
                    if (!verbose) continue;
                    databaseObjectsValidatedMessage.append(String.format("                    %s%n", databaseObjectName));
                }
                if (checksRunReportParameters == null) continue;
                checksRunReportParameters.getDatabaseChecksRunInfo().getVerboseObjectsValidated().add(new DatabaseChecksRunInfo.VerboseDatabaseObject(objectTypeName, count, databaseObjectNames));
            }
            if (verbose) {
                databaseObjectsValidatedMessage.append("To reduce details unset the --verbose property").append(System.lineSeparator());
            } else {
                databaseObjectsValidatedMessage.append("To increase details set the --verbose property").append(System.lineSeparator());
            }
        }
        catch (CommandExecutionException cee) {
            throw new UnexpectedLiquibaseException((Throwable)cee);
        }
        ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, databaseObjectsValidatedMessage + System.lineSeparator());
    }

    private static <T> void outputChecksResultsSummary(LinkedHashMap<T, LiquibaseQualityCheckResult> results, CommandResultsBuilder resultsBuilder, AtomicReference<SeverityEnum> maxSeverityEnum, LinkedHashSet<ChecksOutput> checksOutputs, String issuesHeader, BiFunction<T, RuleIteration, String> messageGenerator, Integer sqlParserFailSeverity, QuadConsumer<String, String, SeverityEnum, String> entryCallback, String checkSettingsConfigFilename, List<String> checksInChain) throws IOException {
        if (results != null && !results.isEmpty()) {
            boolean printedIssuesHeader = false;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (Map.Entry<T, LiquibaseQualityCheckResult> resultEntry : results.entrySet()) {
                T changeSet = resultEntry.getKey();
                List<LiquibaseRuleResult> ruleResults = resultEntry.getValue().getRuleResults();
                for (LiquibaseRuleResult ruleResult : ruleResults) {
                    if (ruleResult.hasRuleSucceeded() || ChecksRunJsonOutputHelper.isPartOfAChain(ruleResult.getRuleShortName(false), checksInChain)) continue;
                    try {
                        if (!ruleResult.getConfigurableRule().getFileInfo().getFilename().equals(checkSettingsConfigFilename)) {
                            continue;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    for (RuleIteration ruleIteration : ruleResult.getExecutions()) {
                        if (ChecksRunConsoleOutputHelper.isSkippable(ruleIteration)) continue;
                        SeverityEnum severityEnum = ruleResult.getRuleSeverity(sqlParserFailSeverity);
                        if (severityEnum.getValue() > maxSeverityEnum.get().getValue()) {
                            maxSeverityEnum.set(severityEnum);
                        }
                        if (!severityEnum.shouldOutputToChecksRunConsole(checksOutputs)) continue;
                        if (!printedIssuesHeader) {
                            ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, issuesHeader);
                            printedIssuesHeader = true;
                        }
                        String ruleMessage = ruleIteration.buildDisplayMessage();
                        String checkNameDisplay = ruleResult.getRule().getName() + ruleResult.getRuleShortName() + System.lineSeparator();
                        String identifier = messageGenerator.apply(changeSet, ruleIteration);
                        String message = "Check Name:         " + checkNameDisplay + identifier + ChecksRunConsoleOutputHelper.addConstraintIfAvailable(ruleResult) + "Check Severity:     " + (Object)((Object)severityEnum) + " (Return code: " + severityEnum.getExitValue() + ")" + System.lineSeparator() + "Message:            " + ProStringUtil.wrapStringCharacterWise(ruleMessage, 120, BREAK_STRING);
                        entries.add(new Entry(severityEnum, message + System.lineSeparator() + System.lineSeparator()));
                        if (entryCallback == null) continue;
                        entryCallback.accept(checkNameDisplay, identifier, severityEnum, ruleMessage);
                    }
                }
            }
            ChecksRunConsoleOutputHelper.outputChecksResultsSummaryMessages(resultsBuilder, checksOutputs, entries);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void outputChecksResultsSummaryMessages(CommandResultsBuilder resultsBuilder, LinkedHashSet<ChecksOutput> checksOutputs, List<Entry> entries) throws IOException {
        if (checksOutputs == null) ** GOTO lbl-1000
        if (checksOutputs.stream().anyMatch((Predicate<ChecksOutput>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Lcom/datical/liquibase/ext/command/checks/ChecksOutput;)Z)(ChecksOutput.SEVERITY_RELATED_KEYS))) {
            for (ChecksOutput checksOutput : checksOutputs) {
                if (!checksOutput.isSeverityRelated()) continue;
                requestedSeverityEnum = checksOutput.getCorrespondingSeverityEnum();
                for (Entry entry : entries) {
                    if (entry.severityEnum != requestedSeverityEnum) continue;
                    ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, entry.message);
                }
            }
        } else lbl-1000:
        // 3 sources

        {
            for (Entry entry : entries) {
                ChecksRunConsoleOutputHelper.sendMessage(resultsBuilder, entry.message);
            }
        }
    }

    private static int outputDatabaseChecksResultsSummary(LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> databaseResults, CommandResultsBuilder resultsBuilder, AtomicReference<SeverityEnum> maxSeverityEnum, LinkedHashSet<ChecksOutput> checksOutputs, Integer sqlParserFailSeverity, ChecksRunReportParameters checksRunReportParameters, String checkSettingsConfigFilename, List<String> checksInChain, CheckSettingsConfig checkSettingsConfig) throws IOException {
        String issuesHeader = System.lineSeparator() + "DATABASE CHECKS" + System.lineSeparator() + "---------------" + System.lineSeparator() + "Validation of the database snapshot found the following issues:" + System.lineSeparator() + System.lineSeparator();
        BiFunction<DatabaseObject, RuleIteration, String> messageGenerator = (databaseObject, ruleIteration) -> "Object Type:        " + databaseObject.getObjectTypeName() + (ChecksRunConsoleOutputHelper.isDatabaseObjectPro(databaseObject) ? " (Pro)" : "") + System.lineSeparator() + "Object Name:        " + databaseObject.getName() + System.lineSeparator() + "Object Location:    " + DatabaseObjectUtils.buildFullyQualifiedName(databaseObject) + System.lineSeparator();
        AtomicInteger triggerCount = new AtomicInteger();
        ChecksRunConsoleOutputHelper.outputChecksResultsSummary(databaseResults, resultsBuilder, maxSeverityEnum, checksOutputs, issuesHeader, messageGenerator, sqlParserFailSeverity, (checkNameDisplay, identifier, severityEnum, ruleMessage) -> triggerCount.incrementAndGet(), checkSettingsConfigFilename, checksInChain);
        checksRunReportParameters.getDatabaseChecksRunInfo().addDatabaseResults(databaseResults, checkSettingsConfigFilename, checksInChain, checkSettingsConfig);
        checksRunReportParameters.getDatabaseChecksRunInfo().setSqlParserFailSeverity(sqlParserFailSeverity);
        checksRunReportParameters.getDatabaseChecksRunInfo().setChecksTriggered(checksRunReportParameters.getDatabaseChecksRunInfo().getChecksTriggered() + triggerCount.get());
        return triggerCount.get();
    }

    private static String addConstraintIfAvailable(LiquibaseRuleResult ruleResult) {
        AbstractConfigurableRule configurableRule = ruleResult.getConfigurableRule();
        if (configurableRule == null || configurableRule instanceof BasicRule) {
            return "";
        }
        DynamicRuleParameter constraintParam = ((DynamicRule)configurableRule).getParameter(DynamicRuleParameterEnum.CONSTRAINT);
        if (constraintParam == null) {
            return "";
        }
        String constraints = (String)constraintParam.getValue();
        return "Constraints:        " + constraints + System.lineSeparator();
    }

    private static int outputChangelogChecksResultsSummary(LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> results, CommandResultsBuilder resultsBuilder, AtomicReference<SeverityEnum> maxSeverityEnum, LinkedHashSet<ChecksOutput> checksOutputs, Integer sqlParserFailSeverity, ChecksRunReportParameters checksRunReportParameters, String checkSettingsConfigFilename, List<String> checksInChain, CheckSettingsConfig checkSettingsConfig) throws IOException {
        String issuesHeader = "CHANGELOG CHECKS" + System.lineSeparator() + "----------------" + System.lineSeparator() + "Checks completed validation of the changelog and found the following issues:" + System.lineSeparator() + System.lineSeparator();
        BiFunction<ChangeSet, RuleIteration, String> messageGenerator = (changeSet, ruleIteration) -> "Changeset ID:       " + changeSet.getId() + (ruleIteration.isRollback() ? " - ROLLBACK CODE" : "") + System.lineSeparator() + "Changeset Filepath: " + ChecksOutputUtil.determineChangesetFilePath(changeSet, ruleIteration.getChange()) + ChecksOutputUtil.determineLineNumberForMatch(ruleIteration) + System.lineSeparator();
        AtomicInteger triggerCount = new AtomicInteger();
        ChecksRunConsoleOutputHelper.outputChecksResultsSummary(results, resultsBuilder, maxSeverityEnum, checksOutputs, issuesHeader, messageGenerator, sqlParserFailSeverity, (checkNameDisplay, identifier, severityEnum, ruleMessage) -> triggerCount.incrementAndGet(), checkSettingsConfigFilename, checksInChain);
        checksRunReportParameters.getChangelogChecksRunInfo().addChangeSetResults(results, checkSettingsConfigFilename, checksInChain, checkSettingsConfig);
        checksRunReportParameters.getChangelogChecksRunInfo().setSqlParserFailSeverity(sqlParserFailSeverity);
        checksRunReportParameters.getChangelogChecksRunInfo().setChecksTriggered(checksRunReportParameters.getChangelogChecksRunInfo().getChecksTriggered() + triggerCount.get());
        return triggerCount.get();
    }

    private static boolean isDatabaseObjectPro(DatabaseObject databaseObject) {
        LicenseServiceFactory licenseServiceFactory = (LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
        LicenseService existingLicenseService = licenseServiceFactory.getLicenseService();
        licenseServiceFactory.unregister(existingLicenseService);
        boolean isProObject = !databaseObject.snapshotByDefault();
        licenseServiceFactory.register((Plugin)existingLicenseService);
        return isProObject;
    }

    private static void sendMessage(CommandResultsBuilder resultsBuilder, String message) throws IOException {
        resultsBuilder.getOutputStream().write(message.getBytes());
    }

    private static void sendMessageToUi(String message) {
        Scope.getCurrentScope().getUI().sendMessage(message);
    }

    private static class Entry {
        public SeverityEnum severityEnum;
        public String message;

        public Entry(SeverityEnum severityEnum, String message) {
            this.severityEnum = severityEnum;
            this.message = message;
        }
    }

    public static class DatabaseObjectSortComparator
    implements Comparator {
        public int compare(Object o, Object t1) {
            String databaseObjectFQN = DatabaseObjectUtils.buildFullyQualifiedName((DatabaseObject)o);
            String toDatabaseObjectFQN = DatabaseObjectUtils.buildFullyQualifiedName((DatabaseObject)t1);
            return databaseObjectFQN.compareTo(toDatabaseObjectFQN);
        }
    }

    public static class DatabaseObjectTypeSortComparator
    implements Comparator {
        public int compare(Object o, Object t) {
            Class oClass = (Class)o;
            Class tClass = (Class)t;
            return oClass.getSimpleName().compareTo(tClass.getSimpleName());
        }
    }

    private static class CompiledResult<T> {
        public Set<String> shortnames;
        public Set<T> entities;

        public CompiledResult(Set<String> shortnames, Set<T> entities) {
            this.shortnames = shortnames;
            this.entities = entities;
        }

        public void compileResult(LiquibaseRuleResult ruleResult, Map<String, CompiledResult<T>> compiledResults, T changeSet) {
            String ruleName = ruleResult.getRule().getName();
            String ruleShortName = ruleResult.getRuleShortName(false);
            if (compiledResults.containsKey(ruleName)) {
                CompiledResult<T> compiledResult = compiledResults.get(ruleName);
                compiledResult.entities.add(changeSet);
                compiledResult.shortnames.add(ruleShortName);
            } else {
                LinkedHashSet<String> shortnames = new LinkedHashSet<String>();
                shortnames.add(ruleShortName);
                LinkedHashSet<T> changeSets = new LinkedHashSet<T>();
                changeSets.add(changeSet);
                compiledResults.put(ruleName, new CompiledResult(shortnames, changeSets));
            }
        }
    }
}

