/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.drift;

import com.datical.liquibase.ext.reports.AbstractReport;
import com.datical.liquibase.ext.reports.ReportType;
import com.datical.liquibase.ext.reports.drift.DriftReportParameters;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import liquibase.Scope;
import liquibase.util.StreamUtil;

public class DriftReport
extends AbstractReport {
    private static final String TEMPLATE_RESOURCE_ROOT = "liquibase/html";
    private static final String TEMPLATE_NAME = "drift-report.html";
    private final DriftReportParameters driftReportParameters;

    public DriftReport(String name, String path, DriftReportParameters driftReportParameters) {
        super(name, path);
        this.driftReportParameters = driftReportParameters;
    }

    @Override
    protected Object getReportParameters() {
        return this.driftReportParameters;
    }

    @Override
    protected String getTemplateName() {
        return TEMPLATE_NAME;
    }

    @Override
    protected String getTemplateResourceRoot() {
        return TEMPLATE_RESOURCE_ROOT;
    }

    @Override
    public String getReportTypeName() {
        return "Drift";
    }

    @Override
    public ReportType getReportType() {
        return ReportType.DRIFT;
    }

    @Override
    public String getReportString() throws IOException {
        String reportString = super.getReportString();
        if (reportString != null) {
            try {
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                try (InputStream footerStream = classloader.getResourceAsStream("liquibase/html/drift-report-header.html");
                     InputStream headerImageStream = classloader.getResourceAsStream("liquibase/html/liquibase-header-img-snippet.html");){
                    reportString = reportString.replace("<!-- styling and javascript placeholder 16fce428-a19f-468e-9512-9a490b3b602d -->", StreamUtil.readStreamAsString((InputStream)footerStream, (String)StandardCharsets.UTF_8.toString()));
                    reportString = reportString.replace("<!-- header image placeholder 9288b8b9-dc31-4cdc-a806-330e1a147637 -->", StreamUtil.readStreamAsString((InputStream)headerImageStream, (String)StandardCharsets.UTF_8.toString()));
                }
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to load the javascript and css dependencies for the generated drift report.", (Throwable)e);
            }
        }
        return reportString;
    }
}

