/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.storedlogic.AbstractUnexpectedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.DropPackageBodyChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;

public class UnexpectedPackageBodyChangeGenerator
extends AbstractUnexpectedStoredLogicChangeGenerator {
    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{DatabasePackage.class};
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (DatabasePackageBody.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        DropPackageBodyChange change = new DropPackageBodyChange();
        if (diffOutputControl.getIncludeCatalog()) {
            change.setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            change.setSchemaName(databaseObject.getSchema().getName());
        }
        change.setPackageBodyName(databaseObject.getName());
        return new Change[]{change};
    }
}

