/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.postgres.PostgresTriggerSnapshotGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtil;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class TriggerSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    public TriggerSnapshotGenerator() {
        super(Trigger.class, new Class[]{Schema.class, Catalog.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof DB2Database || database instanceof Db2zDatabase || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) throws DatabaseException {
        Database database = databaseSnapshot.getDatabase();
        if (databaseObject instanceof Catalog && database instanceof MSSQLDatabase || databaseObject instanceof Catalog && database instanceof PostgresDatabase || databaseObject instanceof Schema) {
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            String snapshotObjectSql = this.getSnapshotObjectSql(databaseObject, database);
            if (snapshotObjectSql == null || snapshotObjectSql.isEmpty()) {
                return;
            }
            List rs = executor.queryForList((SqlStatement)new RawSqlStatement(snapshotObjectSql));
            for (Map row : rs) {
                Trigger object = this.rowToObject(row, databaseObject, database);
                if (object == null || database.isSystemObject((DatabaseObject)object)) continue;
                if (databaseObject instanceof Schema) {
                    ((Schema)databaseObject).addDatabaseObject((DatabaseObject)object);
                    continue;
                }
                ((Catalog)databaseObject).addDatabaseObject((DatabaseObject)object);
            }
        }
    }

    protected String getSnapshotObjectSql(DatabaseObject object, Database database) {
        String sql;
        if (database instanceof PostgresDatabase) {
            return new PostgresTriggerSnapshotGenerator().getSnapshotObjectSql(object, database);
        }
        if (database instanceof MSSQLDatabase) {
            sql = "SELECT sys.triggers.name AS OBJECT_NAME, OBJECT_DEFINITION(sys.triggers.object_id) AS OBJECT_BODY, sys.triggers.create_date AS CREATED, sys.triggers.modify_date AS LAST_MODIFIED, 'VALID' as STATUS, IS_DISABLED as IS_DISABLED, parent.name as TABLE_NAME, uses_quoted_identifier FROM sys.triggers LEFT OUTER JOIN sys.objects on sys.objects.object_id=sys.triggers.object_id LEFT OUTER JOIN sys.all_objects parent ON triggers.parent_id = parent.object_id LEFT OUTER JOIN sys.sql_modules ON sql_modules.object_id=triggers.object_id";
            if (!(object instanceof Catalog)) {
                String jdbcSchemaName = ((MSSQLDatabase)database).getJdbcSchemaName(object.getSchema().toCatalogAndSchema());
                if (jdbcSchemaName == null) {
                    jdbcSchemaName = database.getDefaultSchemaName();
                }
                sql = sql + " INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and sys.schemas.name='" + jdbcSchemaName + "' ";
            }
            if (object instanceof Trigger) {
                sql = sql + " where sys.triggers.name='" + database.correctObjectName(object.getName(), Trigger.class) + "'";
            } else if (object instanceof Schema) {
                sql = sql + "";
            } else if (object instanceof Catalog) {
                sql = sql + " where parent_class=0";
            }
        } else if (database instanceof DB2Database) {
            sql = "SELECT TRIGNAME AS OBJECT_NAME, CREATE_TIME AS CREATED, ALTER_TIME AS LAST_MODIFIED, VALID AS STATUS, TEXT AS OBJECT_BODY, TABNAME AS TABLE_NAME, ENABLED FROM SYSCAT.TRIGGERS WHERE TRIGSCHEMA='" + database.correctObjectName(object.getSchema().getCatalogName(), Catalog.class) + "'";
            try {
                int dbMajorVersion = database.getDatabaseMajorVersion();
                if (dbMajorVersion < 10) {
                    sql = sql.replace("ALTER_TIME AS LAST_MODIFIED,", "");
                    sql = sql.replace("ENABLED", "'Y' AS ENABLED");
                }
            }
            catch (DatabaseException dbMajorVersion) {
                // empty catch block
            }
            if (object instanceof Trigger) {
                sql = sql + " AND TRIGNAME='" + database.correctObjectName(object.getName(), Trigger.class) + "'";
            }
        } else if (database instanceof Db2zDatabase) {
            sql = "SELECT NAME AS OBJECT_NAME, CREATEDTS AS CREATED, ALTEREDTS AS LAST_MODIFIED, 'Y' AS STATUS, STATEMENT AS OBJECT_BODY, TBNAME AS TABLE_NAME, 'Y' AS ENABLED FROM SYSIBM.SYSTRIGGERS WHERE SCHEMA='" + database.correctObjectName(object.getSchema().getCatalogName(), Catalog.class).toUpperCase() + "'";
            if (object instanceof Trigger) {
                sql = sql + " AND NAME='" + database.correctObjectName(object.getName(), Trigger.class).toUpperCase() + "'";
            }
        } else if (database instanceof OracleDatabase) {
            sql = "select OBJECT_NAME, CREATED, LAST_DDL_TIME AS LAST_MODIFIED, ALL_OBJECTS.STATUS, ALL_TRIGGERS.STATUS as TRIGGER_STATUS, trigger_body AS OBJECT_BODY, ACTION_TYPE, WHEN_CLAUSE, REFERENCING_NAMES, COLUMN_NAME, TABLE_NAME, BASE_OBJECT_TYPE, all_triggers.owner as TRIGGER_OWNER, TABLE_OWNER, TRIGGERING_EVENT, TRIGGER_TYPE, DESCRIPTION as TRIGGER_DESCRIPTION from ALL_OBJECTS join all_triggers on trigger_name=object_name and all_triggers.owner=all_objects.owner where object_type='TRIGGER' and all_triggers.owner='" + database.correctObjectName(object.getSchema().getCatalogName(), Catalog.class) + "'";
            if (object instanceof Trigger) {
                String objectName = database.correctObjectName(object.getName(), Trigger.class);
                sql = sql + " and trigger_name='" + objectName + "'";
            }
        } else if (database instanceof MySQLDatabase) {
            String jdbcSchemaName = object.getSchema().getName();
            sql = "select action_statement as OBJECT_BODY, trigger_name as OBJECT_NAME, event_object_table as TABLE_NAME, event_object_schema as TABLE_OWNER, event_manipulation as TRIGGERING_EVENT, action_timing as WHEN_CLAUSE FROM INFORMATION_SCHEMA.TRIGGERS WHERE trigger_schema = '" + jdbcSchemaName + "';";
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database for trigger snapshot: " + database.getShortName());
        }
        return sql;
    }

    @Override
    protected String getAddToSql(Schema schema, Database database) throws DatabaseException {
        if (database instanceof PostgresDatabase) {
            return new PostgresTriggerSnapshotGenerator().getAddToSql(schema, database);
        }
        if (database instanceof MSSQLDatabase) {
            String jdbcSchemaName = ((MSSQLDatabase)database).getJdbcSchemaName(schema.toCatalogAndSchema());
            if (jdbcSchemaName == null) {
                jdbcSchemaName = database.getDefaultSchemaName();
            }
            return "SELECT  sys.objects.name AS OBJECT_NAME FROM sys.objects INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and sys.schemas.name='" + jdbcSchemaName + "' where type_desc='SQL_TRIGGER'";
        }
        if (database instanceof DB2Database) {
            return "SELECT TRIGNAME AS OBJECT_NAME FROM SYSCAT.TRIGGERS WHERE TRIGSCHEMA='" + ((DB2Database)database).getJdbcSchemaName(schema.toCatalogAndSchema()) + "'";
        }
        if (database instanceof Db2zDatabase) {
            return "SELECT NAME AS OBJECT_NAME FROM SYSIBM.SYSTRIGGERS WHERE SCHEMA='" + ((Db2zDatabase)database).getJdbcSchemaName(schema.toCatalogAndSchema()) + "'";
        }
        if (database instanceof MySQLDatabase) {
            String jdbcSchemaName = ((MySQLDatabase)database).getJdbcSchemaName(schema.toCatalogAndSchema());
            return "SELECT TRIGGER_NAME as OBJECT_NAME FROM INFORMATION_SCHEMA.TRIGGERS WHERE TRIGGER_SCHEMA='" + jdbcSchemaName + "'";
        }
        return super.getAddToSql(schema, database);
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Trigger example = (Trigger)databaseObject;
        if (example.getBody() == null) {
            String sql;
            Database database = snapshot.getDatabase();
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            List rows = executor.queryForList((SqlStatement)new RawSqlStatement(sql = this.getSnapshotObjectSql(databaseObject, database)));
            if (rows.isEmpty()) {
                return null;
            }
            try {
                JdbcUtil.requiredSingleResult((Collection)rows);
            }
            catch (DatabaseException e) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error snapshotting " + (Object)((Object)example) + " with result set of " + sql, (Throwable)e);
                throw e;
            }
            Map row = (Map)rows.get(0);
            return this.rowToObject(row, (DatabaseObject)databaseObject.getSchema(), database);
        }
        return databaseObject;
    }

    private Trigger rowToObject(Map<?, ?> row, DatabaseObject container, Database database) {
        String body = (String)row.get("OBJECT_BODY");
        String name = (String)row.get("OBJECT_NAME");
        Boolean valid = database instanceof AbstractDb2Database ? Boolean.valueOf(row.get("STATUS").equals("Y")) : (database instanceof MySQLDatabase ? Boolean.TRUE : Boolean.valueOf(row.get("STATUS").equals("VALID")));
        boolean disabled = database instanceof OracleDatabase || database instanceof PostgresDatabase ? !row.get("TRIGGER_STATUS").equals("ENABLED") : (database instanceof AbstractDb2Database ? !row.get("ENABLED").equals("Y") : (database instanceof MySQLDatabase ? false : (Boolean)row.get("IS_DISABLED")));
        String actionType = (String)row.get("ACTION_TYPE");
        String whenClause = (String)row.get("WHEN_CLAUSE");
        String referencingNames = (String)row.get("REFERENCING_NAMES");
        String columnName = (String)row.get("COLUMN_NAME");
        String tableName = (String)row.get("TABLE_NAME");
        String baseObjectType = (String)row.get("BASE_OBJECT_TYPE");
        String tableOwner = (String)row.get("TABLE_OWNER");
        String triggeringEvent = (String)row.get("TRIGGERING_EVENT");
        String triggerType = (String)row.get("TRIGGER_TYPE");
        Schema schema = null;
        Catalog catalog = null;
        if (container instanceof Schema) {
            schema = (Schema)container;
        } else {
            catalog = (Catalog)container;
        }
        if (body == null) {
            try {
                List clrEvents;
                String fullyQualifiedName = name;
                if (schema != null) {
                    fullyQualifiedName = schema + "." + fullyQualifiedName;
                }
                if (!(clrEvents = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawParameterizedSqlStatement("SELECT sp.name AS [sp_name], schema_name(sp.schema_id) as schema_name, table_obj.name as [table_name], schema_name(table_obj.schema_id) as [table_schema], events.type_desc as [type_desc], sp.type as object_type, case when amsp.object_id is null then N'''' else asmblsp.name end AS [AssemblyName], case when amsp.object_id is null then N'''' else amsp.assembly_class end AS [ClassName], case when amsp.object_id is null then N'''' else amsp.assembly_method end AS [MethodName], sp.object_id AS [object_id] FROM sys.all_objects AS sp JOIN sys.triggers AS triggers on triggers.object_id=sp.object_id LEFT OUTER JOIN sys.objects AS table_obj on table_obj.object_id=triggers.parent_id LEFT OUTER JOIN sys.assembly_modules AS amsp ON amsp.object_id = sp.object_id LEFT OUTER JOIN sys.assemblies AS asmblsp ON asmblsp.assembly_id = amsp.assembly_id LEFT OUTER JOIN sys.events AS events ON events.object_id = sp.object_id WHERE sp.object_id=object_id('?')", new Object[]{fullyQualifiedName}))).isEmpty()) {
                    Map clrObject = (Map)clrEvents.get(0);
                    body = "CREATE TRIGGER " + this.alwaysQuoteDatabaseObject(null, (String)clrObject.get("SCHEMA_NAME"), (String)clrObject.get("SP_NAME"), Trigger.class, database) + " ON " + this.alwaysQuoteDatabaseObject(null, (String)clrObject.get("TABLE_SCHEMA"), (String)clrObject.get("TABLE_NAME"), Table.class, database) + " FOR ";
                    body = body + StringUtil.join((Collection)clrEvents, (String)", ", (StringUtil.StringUtilFormatter)new StringUtil.StringUtilFormatter<Map<String, ?>>(){

                        public String toString(Map<String, ?> obj) {
                            return (String)obj.get("TYPE_DESC");
                        }
                    });
                    body = body + " AS EXTERNAL NAME " + clrObject.get("ASSEMBLYNAME") + ".[" + clrObject.get("CLASSNAME") + "]." + clrObject.get("METHODNAME");
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }
        if (body == null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Omitting " + this.getObjectType(database).toLowerCase() + " '" + name + "': OBJECT_BODY is null. Null OBJECT_BODY values are often due to permission issues");
            return null;
        }
        body = StringUtils.trimToNull((String)StringUtils.trimToEmpty((String)body.replace("\r\n", "\n").replace("\r", "\n")));
        if (database instanceof OracleDatabase) {
            String triggerDescription = (String)row.get("TRIGGER_DESCRIPTION");
            triggerDescription = triggerDescription.replaceFirst("(?i)\"?" + row.get("TRIGGER_OWNER") + "\"?\\.", "");
            if (whenClause != null) {
                triggerDescription = triggerDescription + "WHEN (" + whenClause + ") ";
            }
            body = "CREATE OR REPLACE TRIGGER " + triggerDescription + body;
        } else if (database instanceof MySQLDatabase) {
            body = "CREATE TRIGGER " + name + " " + whenClause + " " + triggeringEvent + " ON " + tableName + " FOR EACH ROW " + body + "\n";
        }
        Schema tableSchema = null;
        if (tableOwner != null) {
            tableSchema = new Schema(tableOwner, null);
        }
        Trigger trigger = ((Trigger)((Trigger)((Trigger)((Trigger)new Trigger().setSchema(schema)).setCatalog(catalog).setName(name)).setValid(valid)).setBody(body)).setDisabled(disabled).setActionType(actionType).setWhenClause(whenClause).setReferencingNames(referencingNames).setColumnName(columnName).setTableName(tableName).setBaseObjectType(baseObjectType).setTableSchema(tableSchema).setTriggeringEvent(triggeringEvent).setTriggerType(triggerType);
        if (database instanceof MSSQLDatabase) {
            trigger.setAttribute("usesQuotedIdentifier", row.get("USES_QUOTED_IDENTIFIER"));
        }
        return trigger;
    }

    @Override
    protected String getObjectType(Database database) {
        return "TRIGGER";
    }

    @Override
    protected StoredDatabaseLogic<?> createReturnObject() {
        return new Trigger();
    }
}

