/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.mustachejava.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import liquibase.repackaged.com.github.mustachejava.MustacheResolver;

public class ClasspathResolver
implements MustacheResolver {
    private final String resourceRoot;

    public ClasspathResolver() {
        this.resourceRoot = null;
    }

    public ClasspathResolver(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    @Override
    public Reader getReader(String resourceName) {
        String fullResourceName;
        String normalizeResourceName;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        URL resource = ccl.getResource(normalizeResourceName = URI.create(fullResourceName = this.concatResourceRootAndResourceName(resourceName)).normalize().getPath());
        if (resource != null) {
            if (resource.getProtocol().equals("jar")) {
                if (normalizeResourceName.endsWith("/")) {
                    return null;
                }
                if (ccl.getResource(normalizeResourceName + "/") != null) {
                    return null;
                }
            } else if (resource.getProtocol().equals("file") && new File(resource.getPath()).isDirectory()) {
                return null;
            }
        } else {
            resource = ClasspathResolver.class.getClassLoader().getResource(normalizeResourceName);
        }
        if (resource != null) {
            try {
                return new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private String concatResourceRootAndResourceName(String resourceName) {
        if (this.resourceRoot == null || resourceName == null) {
            return resourceName;
        }
        if (resourceName.startsWith("/") && this.resourceRoot.endsWith("/")) {
            return this.resourceRoot.substring(0, this.resourceRoot.length() - 1) + resourceName;
        }
        if (resourceName.startsWith("/") && !this.resourceRoot.endsWith("/") || !resourceName.startsWith("/") && this.resourceRoot.endsWith("/")) {
            return this.resourceRoot + resourceName;
        }
        return this.resourceRoot + "/" + resourceName;
    }
}

