/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import liquibase.license.LicenseServiceUtils;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtil;

public class Synonym
extends AbstractDatabaseObject {
    public Synonym() {
    }

    public Synonym(String catalogName, String schemaName, String sequenceName) {
        this.setSchema(new Schema(catalogName, schemaName));
        this.setName(sequenceName);
    }

    public boolean snapshotByDefault() {
        return LicenseServiceUtils.isProLicenseValid();
    }

    public DatabaseObject[] getContainingObjects() {
        return null;
    }

    public String getName() {
        return (String)this.getAttribute("name", String.class);
    }

    public Synonym setName(String name) {
        this.setAttribute("name", name);
        return this;
    }

    public Schema getSchema() {
        return (Schema)this.getAttribute("schema", Schema.class);
    }

    public Synonym setSchema(Schema schema) {
        this.setAttribute("schema", schema);
        return this;
    }

    public Synonym setSchema(String catalog, String schema) {
        return this.setSchema(new Schema(catalog, schema));
    }

    public boolean isPrivate() {
        Boolean isPrivate = (Boolean)this.getAttribute("private", Boolean.class);
        if (isPrivate == null) {
            isPrivate = false;
        }
        return isPrivate;
    }

    public Synonym setPrivate(boolean isPrivate) {
        this.setAttribute("private", isPrivate);
        return this;
    }

    public Schema getObjectSchema() {
        return (Schema)this.getAttribute("objectSchema", Schema.class);
    }

    public Synonym setObjectSchema(Schema schema) {
        this.setAttribute("objectSchema", schema);
        return this;
    }

    public Synonym setObjectSchema(String catalog, String schema) {
        return this.setObjectSchema(new Schema(catalog, schema));
    }

    public String getObjectName() {
        return (String)this.getAttribute("objectName", String.class);
    }

    public Synonym setObjectName(String name) {
        this.setAttribute("objectName", name);
        return this;
    }

    public String getObjectType() {
        return (String)this.getAttribute("objectType", String.class);
    }

    public Synonym setObjectType(String type) {
        this.setAttribute("objectType", type);
        return this;
    }

    public String toString() {
        if (!this.isPrivate()) {
            return "PUBLIC " + super.toString();
        }
        return super.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Synonym that = (Synonym)((Object)obj);
        if (this.isPrivate() != that.isPrivate()) {
            return false;
        }
        if (this.getSchema() != null && that.getSchema() != null) {
            return StringUtil.trimToEmpty((String)this.getSchema().getName()).equalsIgnoreCase(StringUtil.trimToEmpty((String)that.getSchema().getName()));
        }
        return StringUtil.trimToEmpty((String)this.getName()).equalsIgnoreCase(StringUtil.trimToEmpty((String)that.getName()));
    }

    public int hashCode() {
        return (this.isPrivate() + ":" + StringUtil.trimToEmpty((String)this.getName()).toLowerCase()).hashCode();
    }

    public int compareTo(Object o) {
        Synonym that = (Synonym)((Object)o);
        int compareTo = Boolean.valueOf(this.isPrivate()).compareTo(that.isPrivate());
        if (compareTo != 0) {
            return compareTo;
        }
        if (this.getSchema() != null && that.getSchema() != null) {
            return StringUtil.trimToEmpty((String)this.getSchema().getName()).compareToIgnoreCase(StringUtil.trimToEmpty((String)that.getSchema().getName()));
        }
        return super.compareTo(o);
    }
}

