/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym.change;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.CreateSynonymStatement;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;

public class CreateSynonymGenerator
extends AbstractSqlGenerator<CreateSynonymStatement> {
    public boolean supports(CreateSynonymStatement statement, Database database) {
        return (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof MSSQLDatabase || database instanceof EnterpriseDBDatabase) && super.supports((SqlStatement)statement, database);
    }

    public ValidationErrors validate(CreateSynonymStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("synonymName", (Object)statement.getSynonymName());
        if (database instanceof DB2Database) {
            validationErrors.checkRequiredField("objectType", (Object)statement.getObjectType());
        }
        if (!(statement.isPrivate() != null && statement.isPrivate().booleanValue() || statement.getSynonymCatalogName() == null && statement.getSynonymSchemaName() == null)) {
            validationErrors.addError("Cannot specify schema name for non-private synonyms");
        }
        return validationErrors;
    }

    public Warnings warn(CreateSynonymStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Warnings warn = super.warn((SqlStatement)statement, database, sqlGeneratorChain);
        if (database instanceof MSSQLDatabase && statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
            warn.addWarning("Microsoft SQL Server does not support replacing synonyms. To replace a synonym in SQL Server, precede the createSynonym refactoring with a dropSynonym refactoring in your changeset.");
        }
        if (database instanceof MSSQLDatabase && statement.isPrivate() != null && !statement.isPrivate().booleanValue()) {
            warn.addWarning("MSSQL does not support public synonyms. Creating " + statement.getSynonymName() + " as private");
        }
        return warn;
    }

    public Sql[] generateSql(CreateSynonymStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql;
        if (database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase) {
            sql = this.generateSqlForOracle(statement, database);
        } else if (database instanceof DB2Database) {
            sql = this.generateSqlForDB2(statement, database);
        } else if (database instanceof Db2zDatabase) {
            sql = this.generateSqlForDB2Zos(statement, database);
        } else if (database instanceof MSSQLDatabase) {
            sql = this.generateSqlForMSSQL(statement, database);
        } else {
            throw new UnexpectedLiquibaseException("Unexpected database type: " + database.getShortName());
        }
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }

    protected String generateSqlForOracle(CreateSynonymStatement statement, Database database) {
        String fullSynonymName = statement.isPrivate() == null || statement.isPrivate() == false ? database.escapeObjectName(statement.getSynonymName(), Synonym.class) : database.escapeObjectName(statement.getSynonymCatalogName(), statement.getSynonymSchemaName(), statement.getSynonymName(), Synonym.class);
        StringBuilder sql = new StringBuilder("CREATE ");
        if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
            sql.append("OR REPLACE ");
        }
        if (statement.isPrivate() == null || !statement.isPrivate().booleanValue()) {
            sql.append("PUBLIC ");
        }
        sql.append("SYNONYM ").append(fullSynonymName).append(" FOR ").append(database.escapeObjectName(statement.getObjectCatalogName(), statement.getObjectSchemaName(), statement.getObjectName(), DatabaseObject.class));
        return sql.toString();
    }

    protected String generateSqlForMSSQL(CreateSynonymStatement statement, Database database) {
        String fullSynonymName = statement.isPrivate() == null || statement.isPrivate() == false ? database.escapeObjectName(statement.getSynonymName(), Synonym.class) : database.escapeObjectName(statement.getSynonymCatalogName(), statement.getSynonymSchemaName(), statement.getSynonymName(), Synonym.class);
        StringBuilder sql = new StringBuilder();
        if (statement.getSynonymCatalogName() != null) {
            sql.append("USE [" + statement.getSynonymCatalogName() + "]\n");
        }
        sql.append("CREATE SYNONYM ");
        String synonymName = database.escapeObjectName(null, statement.getObjectSchemaName(), statement.getObjectName(), DatabaseObject.class);
        if (statement.getObjectCatalogName() != null) {
            synonymName = database.escapeObjectName(statement.getObjectCatalogName(), Catalog.class) + "." + synonymName;
        }
        sql.append(fullSynonymName).append(" FOR ").append(synonymName);
        if (statement.getSynonymCatalogName() != null) {
            sql.append("\nUSE [" + database.getDefaultCatalogName() + "]\n");
        }
        return sql.toString();
    }

    protected String generateSqlForDB2(CreateSynonymStatement statement, Database database) {
        String fullSynonymName = statement.isPrivate() == null || statement.isPrivate() == false ? database.escapeObjectName(statement.getSynonymName(), Synonym.class) : database.escapeObjectName(statement.getSynonymCatalogName(), statement.getSynonymSchemaName(), statement.getSynonymName(), Synonym.class);
        StringBuilder sql = new StringBuilder("CREATE ");
        if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
            sql.append("OR REPLACE ");
        }
        if (statement.isPrivate() == null || !statement.isPrivate().booleanValue()) {
            sql.append("PUBLIC ");
        }
        sql.append("ALIAS ").append(fullSynonymName).append(" FOR ").append(statement.getObjectType().toUpperCase()).append(" ").append(database.escapeObjectName(statement.getObjectCatalogName(), statement.getObjectSchemaName(), statement.getObjectName(), DatabaseObject.class));
        return sql.toString();
    }

    private String generateSqlForDB2Zos(CreateSynonymStatement statement, Database database) {
        String fullSynonymName = statement.isPrivate() == null || statement.isPrivate() == false ? database.escapeObjectName(statement.getSynonymName(), Synonym.class) : database.escapeObjectName(statement.getSynonymCatalogName(), statement.getSynonymSchemaName(), statement.getSynonymName(), Synonym.class);
        StringBuilder sql = new StringBuilder("CREATE ");
        if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
            sql.append("OR REPLACE ");
        }
        if (statement.isPrivate() == null || !statement.isPrivate().booleanValue()) {
            sql.append("PUBLIC ");
        }
        sql.append("ALIAS ").append(fullSynonymName).append(" FOR ").append(database.escapeObjectName(statement.getObjectCatalogName(), statement.getObjectSchemaName(), statement.getObjectName(), DatabaseObject.class));
        return sql.toString();
    }
}

