/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;

public class YamlChangelogRewriter
extends AbstractChangelogRewriter {
    public static final String CHANGES = "changes:";
    public static final String LABELS = "labels";
    public static final String CONTEXT = "context";
    public static final String CONTEXT_FILTER = "contextFilter";
    public static final String CHANGE_SET = "changeSet:";
    public static final String INCLUDE = "include:";
    public static final String INCLUDE_ALL = "includeAll:";
    public static final String FILE = "file: ";
    public static final String PATH = "path: ";
    public static final String LABELS_REPLACEMENT_STRING = "labels: ";
    public static final String CONTEXT_REPLACEMENT_STRING = "context: ";

    @Override
    public boolean supports(String path) {
        return path.toLowerCase().endsWith(".yaml") || path.toLowerCase().endsWith(".yml");
    }

    @Override
    public String handle(String changelogString) throws LiquibaseException {
        StringBuilder newChangeLogString = new StringBuilder();
        String[] lines = changelogString.replace("\r\n", "\n").split("\n");
        boolean changeSetFound = false;
        String id = null;
        String author = null;
        boolean hasLabels = false;
        boolean hasContexts = false;
        String contextsLine = null;
        String labelsLine = null;
        for (String line : lines) {
            if (line.isEmpty()) {
                newChangeLogString.append(line);
                newChangeLogString.append(System.lineSeparator());
                continue;
            }
            if (line.contains(CHANGES) && changeSetFound) {
                if (this.modType == ChangelogRewriter.MOD_TYPE.LABELS && !hasLabels) {
                    this.handleAddLabelsToYaml(newChangeLogString, id, author, line, labelsLine);
                } else if (this.modType == ChangelogRewriter.MOD_TYPE.CONTEXTS && !hasContexts) {
                    this.handleAddContextsToYaml(newChangeLogString, id, author, line, contextsLine);
                }
                changeSetFound = false;
                hasLabels = false;
                hasContexts = false;
            } else if (changeSetFound) {
                String message;
                ChangeSet changeSet;
                String[] parts = line.split(":");
                AbstractChangelogRewriter.KeyValuePair kvp = this.parseKeyValuePair(parts);
                if (kvp.key.equals("id")) {
                    id = kvp.value;
                } else if (kvp.key.equals("author")) {
                    author = kvp.value;
                } else if (this.modType == ChangelogRewriter.MOD_TYPE.LABELS && kvp.key.equals(LABELS)) {
                    changeSet = this.getChangeSet(author, id);
                    if (changeSet != null) {
                        labelsLine = line;
                        if (changeSet.isIgnore()) {
                            message = "Ignoring changeset '" + changeSet + "'";
                            Scope.getCurrentScope().getUI().sendMessage(message);
                            changeSetFound = false;
                            hasLabels = false;
                            id = null;
                            author = null;
                        } else {
                            if (parts.length <= 1) continue;
                            line = this.rewriteLabelsYaml(line, parts[1], kvp.value, changeSet);
                            hasLabels = true;
                        }
                    } else {
                        changeSetFound = false;
                        hasLabels = false;
                        hasContexts = false;
                    }
                } else if (this.modType == ChangelogRewriter.MOD_TYPE.CONTEXTS && (kvp.key.equals(CONTEXT) || kvp.key.equals(CONTEXT_FILTER))) {
                    changeSet = this.getChangeSet(author, id);
                    if (changeSet != null) {
                        contextsLine = line;
                        if (changeSet.isIgnore()) {
                            message = "Ignoring changeset '" + changeSet + "'";
                            Scope.getCurrentScope().getUI().sendMessage(message);
                            changeSetFound = false;
                            hasContexts = false;
                            id = null;
                            author = null;
                        } else {
                            if (parts.length <= 1) continue;
                            line = this.rewriteContextsYaml(line, parts[1], kvp.value, changeSet);
                            hasContexts = true;
                        }
                    } else {
                        changeSetFound = false;
                        hasLabels = false;
                        hasContexts = false;
                    }
                }
            } else if (line.contains(CHANGE_SET)) {
                changeSetFound = true;
            }
            newChangeLogString.append(line);
            newChangeLogString.append(System.lineSeparator());
        }
        this.handleIncludes(changelogString);
        return newChangeLogString.toString();
    }

    private void handleAddLabelsToYaml(StringBuilder newChangeLogString, String id, String author, String line, String labelsLine) {
        if (labelsLine == null) {
            this.addNewLabelsLineToYaml(newChangeLogString, id, author, line);
        } else {
            this.addNewLabelsLineToYaml(newChangeLogString, id, author, labelsLine);
        }
    }

    private void handleAddContextsToYaml(StringBuilder newChangeLogString, String id, String author, String line, String contextsLine) {
        if (contextsLine == null) {
            this.addNewContextsLineToYaml(newChangeLogString, id, author, line);
        } else {
            this.addNewContextsLineToYaml(newChangeLogString, id, author, contextsLine);
        }
    }

    private void addNewLabelsLineToYaml(StringBuilder newChangeLogString, String id, String author, String line) {
        ChangeSet changeSet = this.getChangeSet(author, id);
        if (changeSet != null && StringUtil.isNotEmpty((String)changeSet.getLabels().toString())) {
            String newLabelsLine = line.replace(CHANGES, LABELS_REPLACEMENT_STRING) + " \"" + changeSet.getLabels() + "\"";
            newChangeLogString.append(newLabelsLine);
            newChangeLogString.append(System.lineSeparator());
        }
    }

    private void addNewContextsLineToYaml(StringBuilder newChangeLogString, String id, String author, String line) {
        String contextStringForFile;
        ChangeSet changeSet = this.getChangeSet(author, id);
        if (changeSet != null && StringUtil.isNotEmpty((String)(contextStringForFile = this.createContextStringForFile(changeSet)))) {
            String newContextsLine = line.replace(CHANGES, CONTEXT_REPLACEMENT_STRING) + " \"" + contextStringForFile + "\"";
            newChangeLogString.append(newContextsLine);
            newChangeLogString.append(System.lineSeparator());
        }
    }

    private String rewriteContextsYaml(String line, String toReplace, String value, ChangeSet changeSet) {
        if (changeSet != null && changeSet.getContextFilter() != null) {
            String newContexts = this.createContextStringForFile(changeSet);
            line = this.replaceIfModified(line, toReplace, value, newContexts);
        }
        return line;
    }

    private String rewriteLabelsYaml(String line, String toReplace, String fileValue, ChangeSet changeSet) {
        if (changeSet != null && changeSet.getLabels() != null) {
            String newLabels = changeSet.getLabels().toString();
            line = this.replaceIfModified(line, toReplace, fileValue, newLabels);
        }
        return line;
    }

    private String replaceIfModified(String line, String toReplace, String fileValue, String newValue) {
        if (StringUtil.isNotEmpty((String)newValue) && !fileValue.equals(newValue)) {
            line = toReplace.startsWith("\"") && toReplace.endsWith("\"") ? line.replace(":" + toReplace, ": \"" + newValue + "\",") : line.replace(":" + toReplace, ": \"" + newValue + "\"");
        }
        return line;
    }
}

