/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.database.jvm;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;

public class ProJdbcConnection
extends JdbcConnection {
    private String username;
    private String password;
    public static final String MATCH_ORACLE_CREDS = "(?i)jdbc:oracle:thin:(.*?)([/])(.*?)((?=@)).*";

    public ProJdbcConnection() {
    }

    public ProJdbcConnection(Connection connection) {
        super(connection);
    }

    public int getPriority() {
        return 101;
    }

    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        super.open(url, driverObject, driverProperties);
        String passwordValue = driverProperties.getProperty("password");
        if (passwordValue == null) {
            passwordValue = this.getPasswordFromUrl(url);
        }
        String user = driverProperties.getProperty("user");
        String[] tokens = null;
        if (user == null || passwordValue == null) {
            tokens = this.getOracleCredentialsFromUrl(url);
        }
        if (user == null) {
            user = tokens[0];
        }
        if (passwordValue == null) {
            passwordValue = tokens[1];
        }
        this.setPassword(passwordValue);
        this.setUsername(user);
    }

    public String getConnectionUserName() {
        if (this.username == null) {
            return super.getConnectionUserName();
        }
        if (!this.username.contains("[") || !this.username.contains("]")) {
            return super.getConnectionUserName();
        }
        return this.username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordFromUrl(String connectionUrl) {
        String password = null;
        String[] splitUrl = connectionUrl.split("password=");
        if (splitUrl.length > 1) {
            int nextDelimiter = splitUrl[1].indexOf(38);
            password = splitUrl[1].substring(0, nextDelimiter > 0 ? nextDelimiter : splitUrl[1].length());
        }
        return password;
    }

    private String[] getOracleCredentialsFromUrl(String connectionUrl) {
        String[] tokens = new String[2];
        Pattern pattern = Pattern.compile(MATCH_ORACLE_CREDS);
        Matcher m = pattern.matcher(connectionUrl);
        if (m.matches()) {
            tokens[0] = m.group(1);
            tokens[1] = m.group(3);
        }
        return tokens;
    }
}

