/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.provider;

import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;

public abstract class AbstractFlowGlobalArgsValueProvider
extends AbstractMapConfigurationValueProvider {
    private final Map<String, Object> globalMap = new HashMap<String, Object>();

    protected AbstractFlowGlobalArgsValueProvider(Map<String, Object> globalMap) {
        if (globalMap != null) {
            OutputStream cachedOutputStream;
            String outputFile;
            this.globalMap.putAll(globalMap);
            if (globalMap.containsKey("outputFile") && LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.containsKey(outputFile = (String)globalMap.get("outputFile")) && (cachedOutputStream = LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.get(outputFile)) != null) {
                try {
                    AbstractFlowGlobalArgsValueProvider.closeAndReopenOutputStream(cachedOutputStream, outputFile);
                }
                catch (IOException ioe) {
                    Scope.getCurrentScope().getLog(AbstractFlowGlobalArgsValueProvider.class).warning("A problem occurred while resetting the output stream: " + ioe.getMessage() + ".  Continuing");
                }
            }
        }
    }

    private static void closeAndReopenOutputStream(OutputStream cachedOutputStream, String outputFile) throws IOException {
        cachedOutputStream.flush();
        cachedOutputStream.close();
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        OutputStream outputStream = pathHandlerFactory.openResourceOutputStream(outputFile, new OpenOptions().setCreateIfNeeded(true));
        LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.put(outputFile, outputStream);
    }

    protected Map<?, ?> getMap() {
        return this.globalMap;
    }

    protected String getSourceDescription() {
        return "Global configuration values from Flow";
    }

    protected boolean keyMatches(String wantedKey, String storedKey) {
        if (super.keyMatches(wantedKey, storedKey)) {
            return true;
        }
        return super.keyMatches(wantedKey.replaceFirst("^liquibase\\.", ""), storedKey);
    }
}

