/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.sqlgenerator.DatabaseChangeLogHistoryColumns;
import com.datical.liquibase.ext.statement.SelectFromDatabaseChangeLogHistoryStatement;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.TempObjectQuotingStrategy;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class SelectFromDatabaseChangeLogHistoryGenerator
extends AbstractSqlGenerator<SelectFromDatabaseChangeLogHistoryStatement> {
    public static final int MAX_NON_VERBOSE_COLUMN_LENGTH = 500;

    public ValidationErrors validate(SelectFromDatabaseChangeLogHistoryStatement statement, Database database, SqlGeneratorChain<SelectFromDatabaseChangeLogHistoryStatement> sqlGeneratorChain) {
        return new ValidationErrors();
    }

    public Sql[] generateSql(SelectFromDatabaseChangeLogHistoryStatement statement, Database database, SqlGeneratorChain<SelectFromDatabaseChangeLogHistoryStatement> sqlGeneratorChain) {
        try (TempObjectQuotingStrategy tempObjectQuotingStrategy = database.temporarilySetObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);){
            Sql[] sqlArray = new Sql[]{new UnparsedSql("SELECT " + StringUtil.join((Object[])DatabaseChangeLogHistoryColumns.values(), (String)", ", obj -> {
                Boolean verbose = statement.getVerbose();
                String escapedColumnName = database.escapeColumnName(null, null, null, obj.toString());
                if (Boolean.FALSE.equals(verbose) && ((DatabaseChangeLogHistoryColumns)((Object)((Object)obj))).isVerboseColumn()) {
                    int verboseColumnLength = 501;
                    return this.getSubstringFunction(database) + "(" + escapedColumnName + ", 1, " + verboseColumnLength + ") AS " + escapedColumnName;
                }
                return escapedColumnName;
            }) + " FROM " + database.escapeTableName(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), DatabaseChangelogHistoryConfiguration.getTableName(database)), new DatabaseObject[0])};
            return sqlArray;
        }
    }

    private String getSubstringFunction(Database database) {
        String substringFunction = "SUBSTRING";
        if (database instanceof OracleDatabase) {
            substringFunction = "SUBSTR";
        }
        return substringFunction;
    }
}

