/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public abstract class AbstractMissingStoredLogicChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator {
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, View.class, Column.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            return -1;
        }
        return 1;
    }

    public static Change[] wrapWithQuotedIdentifier(DatabaseObject databaseObject, Database database, Change[] changes) {
        if (!(database instanceof MSSQLDatabase)) {
            return changes;
        }
        boolean useQuoted = (Boolean)databaseObject.getAttribute("usesQuotedIdentifier", (Object)true);
        if (!useQuoted) {
            ArrayList<Change> returnChanges = new ArrayList<Change>(Arrays.asList(changes));
            returnChanges.add(0, (Change)new RawSQLChange("SET QUOTED_IDENTIFIER OFF"));
            returnChanges.add((Change)new RawSQLChange("SET QUOTED_IDENTIFIER ON"));
            return returnChanges.toArray(new Change[returnChanges.size()]);
        }
        return changes;
    }

    public static <T extends Change> T findChange(Class<T> type, Change[] changes) {
        for (Change change : changes) {
            if (!type.isAssignableFrom(change.getClass())) continue;
            return (T)change;
        }
        return null;
    }
}

