/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.AbstractChangedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.AddCheckConstraintChange;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DisableCheckConstraintChange;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DropCheckConstraintChange;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.EnableCheckConstraintChange;
import java.util.ArrayList;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;

public class ChangedCheckConstraintChangeGenerator
extends AbstractChangedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (CheckConstraint.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences objectDifferences, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        CheckConstraint constraint = (CheckConstraint)databaseObject;
        ArrayList<LicenseValidationChange> changes = new ArrayList<LicenseValidationChange>();
        if (objectDifferences.isDifferent("body")) {
            DropCheckConstraintChange dropConstraintChange = new DropCheckConstraintChange();
            dropConstraintChange.setTableName(constraint.getTable().getName());
            if (diffOutputControl.getIncludeCatalog()) {
                dropConstraintChange.setCatalogName(constraint.getTable().getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                dropConstraintChange.setSchemaName(constraint.getTable().getSchema().getName());
            }
            dropConstraintChange.setConstraintName(constraint.getName());
            AddCheckConstraintChange addNewConstraintChange = new AddCheckConstraintChange();
            addNewConstraintChange.setTableName(constraint.getTable().getName());
            if (diffOutputControl.getIncludeCatalog()) {
                addNewConstraintChange.setCatalogName(constraint.getTable().getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                addNewConstraintChange.setSchemaName(constraint.getTable().getSchema().getName());
            }
            addNewConstraintChange.setConstraintName(constraint.getName());
            addNewConstraintChange.setDisabled(constraint.isDisabled());
            addNewConstraintChange.setConstraintBody((String)objectDifferences.getDifference("body").getReferenceValue());
            changes.add(dropConstraintChange);
            changes.add(addNewConstraintChange);
        }
        if (objectDifferences.isDifferent("disabled")) {
            if (((CheckConstraint)databaseObject).isDisabled()) {
                DisableCheckConstraintChange disableCheckConstraintChange = new DisableCheckConstraintChange();
                disableCheckConstraintChange.setConstraintName(databaseObject.getName());
                disableCheckConstraintChange.setTableName(constraint.getTable().getName());
                if (diffOutputControl.getIncludeCatalog()) {
                    disableCheckConstraintChange.setCatalogName(databaseObject.getSchema().getCatalogName());
                }
                if (diffOutputControl.getIncludeSchema()) {
                    disableCheckConstraintChange.setSchemaName(databaseObject.getSchema().getName());
                }
                changes.add(disableCheckConstraintChange);
            } else {
                EnableCheckConstraintChange enableCheckConstraintChange = new EnableCheckConstraintChange();
                enableCheckConstraintChange.setConstraintName(databaseObject.getName());
                enableCheckConstraintChange.setTableName(constraint.getTable().getName());
                if (diffOutputControl.getIncludeCatalog()) {
                    enableCheckConstraintChange.setCatalogName(databaseObject.getSchema().getCatalogName());
                }
                if (diffOutputControl.getIncludeSchema()) {
                    enableCheckConstraintChange.setSchemaName(databaseObject.getSchema().getName());
                }
                changes.add(enableCheckConstraintChange);
            }
        }
        return changes.toArray(new Change[changes.size()]);
    }
}

