/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.storedlogic.AbstractUnexpectedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.DropPackageChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;

public class UnexpectedPackageChangeGenerator
extends AbstractUnexpectedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (DatabasePackage.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain changeGeneratorChain) {
        DropPackageChange change = new DropPackageChange();
        if (diffOutputControl.getIncludeCatalog()) {
            change.setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            change.setSchemaName(databaseObject.getSchema().getName());
        }
        change.setPackageName(databaseObject.getName());
        DatabasePackageBody packageBody = new DatabasePackageBody();
        packageBody.setSchema(databaseObject.getSchema());
        packageBody.setName(databaseObject.getName());
        diffOutputControl.setAlreadyHandledUnexpected((DatabaseObject)packageBody);
        return new Change[]{change};
    }
}

